(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      4348,        128]
NotebookOptionsPosition[      4104,        115]
NotebookOutlinePosition[      4449,        130]
CellTagsIndexPosition[      4406,        127]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]yx", "=", "\[Tau]xy"}], ";", 
    RowBox[{"\[Tau]zy", "=", "\[Tau]yz"}], ";", 
    RowBox[{"\[Tau]xz", "=", "\[Tau]zx"}], ";", "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]tensor", "=", 
     RowBox[{"(", GridBox[{
        {"\[Sigma]x", "\[Tau]xy", "\[Tau]xz"},
        {"\[Tau]yx", "\[Sigma]y", "\[Tau]yz"},
        {"\[Tau]zx", "\[Tau]zy", "\[Sigma]z"}
       }], ")"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"n", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"traction", "=", 
     RowBox[{"\[Sigma]tensor", ".", "n"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]", "=", 
     RowBox[{"traction", ".", "n"}]}], ";", 
    RowBox[{"\[Tau]", "=", 
     SqrtBox[
      RowBox[{
       RowBox[{"traction", ".", "traction"}], "-", 
       SuperscriptBox["\[Sigma]", "2"]}]]}], ";", "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Sigma]", ",", "\[Tau]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", 
        RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<Stress Tensor = \>\"", ",", "\[Sigma]tensor"}], "}"}], 
        "]"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<\[Sigma]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Sigma]x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Sigma]y", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Sigma]z", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Tau]xy", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Tau]yz", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Tau]zx", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5610839940571227`*^9, 3.561084311214263*^9}, {
  3.5610843462942696`*^9, 3.561084511916743*^9}, {3.5610845520880404`*^9, 
  3.5610845552312202`*^9}, {3.561084588759138*^9, 3.561084764840209*^9}, {
  3.5610848098637843`*^9, 3.5610848338071537`*^9}, {3.561084884951079*^9, 
  3.5610848905033965`*^9}, {3.561085023277991*^9, 3.561085127539954*^9}, {
  3.5610852089086084`*^9, 3.561085237884266*^9}, {3.5610863739972477`*^9, 
  3.561086377828467*^9}}]
},
WindowSize->{707, 797},
WindowMargins->{{Automatic, 161}, {4, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 3543, 93, 265, "Input"]
}
]
*)

(* End of internal cache information *)
