(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    273230,       5904]
NotebookOptionsPosition[    268607,       5768]
NotebookOutlinePosition[    269086,       5786]
CellTagsIndexPosition[    269043,       5783]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Visualizing rotations (and the Arvo algorithm for random rotations)\
\>", "Title",
 CellChangeTimes->{{3.5940970787563324`*^9, 3.594097086347767*^9}, {
  3.594133165589381*^9, 3.594133175389942*^9}, {3.5945641790946217`*^9, 
  3.594564193589451*^9}}],

Cell[CellGroupData[{

Cell["Useful commands", "Section",
 CellChangeTimes->{{3.5945643630601435`*^9, 3.5945643652282677`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Commands to make a cube with dots on the faces (like a die)\
\>", "Subsection",
 CellChangeTimes->{{3.5941635263679185`*^9, 3.594163538839632*^9}, {
  3.5945641991417685`*^9, 3.5945642420532227`*^9}}],

Cell[TextData[{
 "The following commands make a die (singular of dice).\nThe scheme used to \
put dots on the faces of the die and to set up a local coordinate directions \
for any given face is controlled using the Boolean variable called permMap.\n\
The local coordinate directions define the orientation of the face.\nFor \
example, if you look at the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["5", "th"], TraditionalForm]]],
 " face of the cube, then the scheme listed below will show you 5 dots (like \
five dots on a die face) with the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "1"], TraditionalForm]]],
 " direction pointing to your right an the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "3"], TraditionalForm]]],
 " direction pointing up. The cross product of these vectors,  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      UnderscriptBox["e", "~"], "1"], "\[Cross]", 
     SubscriptBox[
      UnderscriptBox["e", "~"], "3"]}], "=", 
    RowBox[{"-", 
     SubscriptBox[
      UnderscriptBox["e", "~"], "2"]}]}], TraditionalForm]]],
 ", is the normal to the face.\n\nIf permMap is true, the local face \
directions are set as follows\n\t1: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "2"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "3"], TraditionalForm]]],
 "\n\t2: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "3"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "1"], TraditionalForm]]],
 "\n\t3: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "2"], TraditionalForm]]],
 "\n\t4: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "3"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "2"], TraditionalForm]]],
 "\t(changes to face #6 if permMap=False)\n\t5: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "3"], TraditionalForm]]],
 "\n\t6: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "2"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    UnderscriptBox["e", "~"], "1"], TraditionalForm]]],
 "\t(changes to face #4 if permMap=False)\n\t\nWhen permMap is true, the last \
three face numbers follow a \[OpenCurlyDoubleQuote]missing\
\[CloseCurlyDoubleQuote] index scheme, similar to what is used in Voigt \
notation.\nWhen permMap is false, the face numbering scheme is the standard \
one used for dice (namely, opposite sides always sum to 7, which is \
convenient to easily know which sides are behind the visible sides)"
}], "Text",
 CellChangeTimes->{{3.594164573857832*^9, 3.5941651430123854`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.594175967048485*^9, 3.5941759683055563`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cube", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "1", "]"}], ",", "White", ",", 
      RowBox[{"Cuboid", "[", 
       RowBox[{
        RowBox[{"0.999", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], ",", 
        RowBox[{"0.999", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", "r_", ",", "dir_"}], 
    "]"}], ":=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "\[Phi]", "]"}], 
            RowBox[{"dir", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"Sin", "[", "\[Phi]", "]"}], 
            RowBox[{"dir", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}]}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", "0", ",", 
        RowBox[{"2", " ", "\[Pi]"}], ",", 
        FractionBox[
         RowBox[{"2", " ", "\[Pi]"}], "20"]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e1", ",", "e2", ",", "e3"}], "}"}], "=", 
   RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", "0.15"}], ";", 
  RowBox[{"s", "=", "0.3"}], ";", 
  RowBox[{"permMap", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"permMap", ",", 
    RowBox[{
     RowBox[{"color", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", ".8", ",", ".1"}], "]"}], ",", "Blue", ",", 
        "Green", ",", "Purple", ",", "Orange"}], "}"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"color", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", ".8", ",", ".1"}], "]"}], ",", "Blue", ",", 
        "Orange", ",", "Purple", ",", "Green"}], "}"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eloc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e2", ",", "e3", ",", "e1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e3", ",", "e1", ",", "e2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e1", ",", "e2", ",", "e3"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{"permMap", ",", 
       RowBox[{"{", 
        RowBox[{"e3", ",", "e2", ",", 
         RowBox[{"-", "e1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e2", ",", "e1", ",", 
         RowBox[{"-", "e3"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"e1", ",", "e3", ",", 
       RowBox[{"-", "e2"}]}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{"permMap", ",", 
       RowBox[{"{", 
        RowBox[{"e2", ",", "e1", ",", 
         RowBox[{"-", "e3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e3", ",", "e2", ",", 
         RowBox[{"-", "e1"}]}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"die", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"cube", ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"color", "[", "1", "]"}], ",", 
         RowBox[{
          RowBox[{"dir", "=", 
           RowBox[{"eloc", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", 
          RowBox[{"disk", "[", 
           RowBox[{
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", "r", ",", "dir"}], 
           "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"color", "[", "2", "]"}], ",", 
         RowBox[{
          RowBox[{"dir", "=", 
           RowBox[{"eloc", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"disk", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"s", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"dir", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "+", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{"dir", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "-", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"color", "[", "3", "]"}], ",", 
         RowBox[{
          RowBox[{"dir", "=", 
           RowBox[{"eloc", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"disk", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"1.3", "s", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{"dir", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{"dir", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1.3", "s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "+", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"color", "[", "4", "]"}], ",", 
         RowBox[{
          RowBox[{"dir", "=", 
           RowBox[{"eloc", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"disk", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"s", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"dir", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{"dir", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "-", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "+", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"color", "[", "5", "]"}], ",", 
         RowBox[{
          RowBox[{"dir", "=", 
           RowBox[{"eloc", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"disk", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"1.2", "s", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"dir", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{"dir", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1.2", "s", 
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "-", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1.2", "s", 
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"1.2", "s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "+", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{"dir", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", "r", ",", "dir"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"color", "[", "6", "]"}], ",", 
         RowBox[{
          RowBox[{"dir", "=", 
           RowBox[{"eloc", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"disk", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"s", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"dir", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "-", 
                RowBox[{"1.5", 
                 RowBox[{"dir", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"dir", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{"-", 
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "+", 
               RowBox[{"1.5", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "-", 
               RowBox[{"1.5", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{"dir", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"disk", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dir", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "+", 
               RowBox[{"1.5", 
                RowBox[{"dir", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"dir", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", "r", ",", "dir"}], 
          "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"10", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.594094436450201*^9, 3.594094932647582*^9}, {
   3.5940971759278903`*^9, 3.594097302242115*^9}, {3.59409740023872*^9, 
   3.5940974174867067`*^9}, {3.5940974813263583`*^9, 
   3.5940976035413485`*^9}, {3.5940976409254866`*^9, 3.594097675164445*^9}, {
   3.5940977391161027`*^9, 3.5940977865958185`*^9}, {3.594097822491872*^9, 
   3.594097988115345*^9}, {3.59409804345051*^9, 3.5940982513414*^9}, {
   3.594098465083626*^9, 3.5940985074700503`*^9}, {3.594098554683751*^9, 
   3.5940987697110496`*^9}, {3.5940988214580092`*^9, 
   3.5940988314805827`*^9}, {3.594098900929555*^9, 3.5940989208856964`*^9}, {
   3.5940991504618273`*^9, 3.5940991672837896`*^9}, {3.594099203091838*^9, 
   3.5940992068310513`*^9}, {3.5940992506605587`*^9, 
   3.5940992630912695`*^9}, {3.5940992946520743`*^9, 3.594099388959469*^9}, {
   3.5940998675578427`*^9, 3.5940998738212013`*^9}, 3.594100256584094*^9, 
   3.594100622173004*^9, 3.5941292879775944`*^9, {3.594129329697981*^9, 
   3.594129344776843*^9}, {3.5941298499037347`*^9, 3.5941299611140957`*^9}, {
   3.594129994962032*^9, 3.5941300130910687`*^9}, {3.5941300499431763`*^9, 
   3.5941300760646706`*^9}, {3.594130116985011*^9, 3.594130154017129*^9}, {
   3.5941302300384774`*^9, 3.594130306696862*^9}, {3.594130337870645*^9, 
   3.5941303454320774`*^9}, {3.5941304428186474`*^9, 3.59413058308267*^9}, {
   3.594133347028759*^9, 3.594133347097763*^9}, 3.594163382733703*^9, {
   3.5941635628360043`*^9, 3.59416371469169*^9}, {3.5941644216101236`*^9, 
   3.594164431326679*^9}, {3.5941651675717897`*^9, 3.5941651747862024`*^9}, {
   3.5941652143154635`*^9, 3.5941653279719644`*^9}, {3.5941815381691346`*^9, 
   3.594181734765379*^9}, {3.5941817709824505`*^9, 3.594181795552856*^9}, {
   3.5941818333100157`*^9, 3.594181833805044*^9}, {3.5941818843259335`*^9, 
   3.594181901275903*^9}, {3.594186879897664*^9, 3.594186881958782*^9}, {
   3.59418702267083*^9, 3.594187024259921*^9}, {3.594187668195752*^9, 
   3.594187724839992*^9}, {3.594216512609558*^9, 3.5942165534608946`*^9}, {
   3.5942165844226656`*^9, 3.5942166459421844`*^9}, {3.5942431512752028`*^9, 
   3.594243292372273*^9}, {3.5942461863738003`*^9, 3.594246301501385*^9}, {
   3.5943253141166487`*^9, 3.5943253414692125`*^9}, 3.5943369226096163`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Command to rotate and/or distort the die\
\>", "Subsection",
 CellChangeTimes->{{3.594564347101231*^9, 3.594564353828616*^9}, {
  3.59456910294825*^9, 3.594569106914477*^9}}],

Cell["\<\
The following commands show how to distort the die based on a given \
deformation gradient tensor F.
The plot range is an optional argument.\
\>", "Text",
 CellChangeTimes->{{3.59416391558118*^9, 3.5941639478770275`*^9}, {
  3.5941642357304916`*^9, 3.5941642438659573`*^9}, {3.5945642788053246`*^9, 
  3.5945642915810556`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"showMap", "[", 
    RowBox[{"F_", ",", 
     RowBox[{"rng_:", "Automatic"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "initial", ",", "deformed", ",", "Fdotc", ",", "pic", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"corners", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
          "                  ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", "  ", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "  ", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "   ", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1", ",", "  ", "1"}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"faceCon", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "7", ",", "6", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "8", ",", "7", ",", "3", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "6", ",", "7", ",", "8", ",", "5"}], "}"}], ",", 
          "\[IndentingNewLine]", "                  ", 
          RowBox[{"{", 
           RowBox[{"8", ",", "5", ",", "1", ",", "4", ",", "8"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "2", ",", "1", ",", "5", ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "3"}], "}"}]}], 
         "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Fdotc", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F", ".", "#1"}], "&"}], ")"}], "/@", "corners"}]}], ";", 
      RowBox[{"initial", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", 
          RowBox[{"GraphicsComplex", "[", 
           RowBox[{"corners", ",", 
            RowBox[{"Line", "[", "faceCon", "]"}]}], "]"}]}], "}"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"deformed", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"GeometricTransformation", "[", 
          RowBox[{
           RowBox[{"First", "@", 
            RowBox[{"Graphics", "[", "die", "]"}]}], ",", "F"}], "]"}], "}"}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pic", "=", 
       RowBox[{"Show", "[", 
        RowBox[{"initial", ",", "deformed", ",", 
         RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
         RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
         RowBox[{"Axes", "\[Rule]", "False"}], ",", 
         RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
         RowBox[{"ViewPoint", "\[Rule]", 
          RowBox[{"10", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"VERIFICATION", " ", "TEST"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"showMap", "[", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0", "0"},
        {"0", "0", "1"},
        {"0", 
         RowBox[{"-", "1"}], "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], "]"}], ",", 
   RowBox[{"showMap", "[", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0", "1"},
         {"0", "1", "0"},
         {"1", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ",", "All"}], "]"}], ",", 
   RowBox[{"showMap", "[", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", "1"}], "0"},
         {"1", "0", "0"},
         {"0", "0", "1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ",", "All"}], "]"}], ",", 
   RowBox[{"showMap", "[", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "0", "0"},
         {"0", "0", 
          RowBox[{"-", "1"}]},
         {"0", "1", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ",", "All"}], "]"}], ",", 
   RowBox[{"showMap", "[", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0.8", "0"},
        {"0", "1", "0"},
        {"0", "0", "1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], "]"}], ",", 
   RowBox[{"showMap", "[", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{"-", "1"}], "0.8", "0"},
        {"0", 
         RowBox[{"-", "1"}], "0"},
        {"0", 
         RowBox[{"-", "1.8"}], "0.5"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], "]"}], ",", 
   RowBox[{"showMap", "[", 
    RowBox[{"(", GridBox[{
       {"1.1", "0.8", "0"},
       {"0", ".6", 
        RowBox[{"-", ".1"}]},
       {"0", ".2", "1.4"}
      }], ")"}], "]"}]}], "}"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdz00owwEABfAZUTJqxhZWEzJDLc1HTRNqs6UdJmVmm2YKKZK0gzYlDsvW
lpq4GbLalMlls/IRLZEUUZMmsWlm2RLRxP/t8Ppd3uG9Us2YbJBMIpGKicAI
ZelB5o+07oy443DVo0rCqHchs4tQO594lxPGsiR/UHuiz+4lrGHm5UDzhpYK
D+esdKh2/JTAbVURB+rZQ1y4LGiohyvcUyGccF+LoIR1JYOVDp4C3oRparip
2e2H5K+yYeiSN6fs4H+PwxDnfBL+9gV10OTqMUDL3vMsFNfWGWFLyGeG5VVi
K6R7pFuQVKA8gDMG7jGkBlm3kEUrvIePNEnKtkbhU6ofWItD78VlhQI7WH9s
2BQ+eoMZNkMMvuq6P5SE01HeJxyYSiShQBRIUxFKzyj50CfcT9mZ+8KAzvY7
JrSZGBYYqjYuwnQ73z6KX07/OvwHMbnmkg==
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Function to map a point onto a disk such that a uniform distribution on the \
sphere corresponds to a uniform distribution on the disk\
\>", "Subsection",
 CellChangeTimes->{{3.555612563179383*^9, 3.5556125927710752`*^9}, {
  3.594326857175906*^9, 3.5943268609511223`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LambertEqualAreaMappingFromDiskToSphere", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"R", "=", "1"}], ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]", 
      ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"r", "=", 
      RowBox[{"Norm", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Psi]", "=", 
      RowBox[{"ArcTan", "@@", "x"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", "\[Psi]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"2", 
       RowBox[{"ArcSin", "[", 
        FractionBox["r", 
         RowBox[{"2", "R"}]], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"R", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{"R", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{"R", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LambertEqualAreaMappingFromDiskToSphere", "[", 
   RowBox[{"x_", ",", "dir1_", ",", "dir2_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"R", "=", "1"}], ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]", 
      ",", "r", ",", "dir3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dir3", "=", 
      RowBox[{"dir1", "\[Cross]", "dir2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"Norm", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Psi]", "=", 
      RowBox[{"ArcTan", "@@", "x"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", "\[Psi]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"2", 
       RowBox[{"ArcSin", "[", 
        FractionBox["r", 
         RowBox[{"2", "R"}]], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{
       RowBox[{"R", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}], "dir1"}], "+", 
       RowBox[{"R", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}], "dir2"}], "+", 
       RowBox[{"R", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "dir3"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.555613033203266*^9, 3.5556130430098276`*^9}, {
  3.5556130785368595`*^9, 3.5556131326809564`*^9}, {3.555613165192816*^9, 
  3.555613368881466*^9}, {3.594324034365451*^9, 3.5943240853993697`*^9}, {
  3.5943279847554*^9, 3.5943280092588015`*^9}}],

Cell["\<\


The optional dir1 and dir2 arguments define the basis for the plane \
perpendicular to the north pole, which lets you look at the sphere from an \
orientation other than the north pole.\
\>", "Text",
 CellChangeTimes->{{3.5943219043946238`*^9, 3.594321935122381*^9}, {
  3.594564659098076*^9, 3.5945646748739786`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"R", "=", "1"}], ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]",
        ",", "r", ",", "\[Rho]vec", ",", "\[Rho]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Theta]", "=", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"n", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}]}], ";", 
      RowBox[{"\[Rho]vec", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{"n", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]", "=", 
       SqrtBox[
        RowBox[{"\[Rho]vec", ".", "\[Rho]vec"}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"\[Rho]", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
           "**", "**", "**", "  ", "then"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
           "**", "**", "**", "  ", "else"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\[Phi]", "=", 
          RowBox[{"ArcTan", "@@", "\[Rho]vec"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Psi]", "=", "\[Phi]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"r", "=", 
          RowBox[{"2", "R", " ", 
           RowBox[{"Sin", "[", 
            FractionBox["\[Theta]", "2"], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"Cos", "[", "\[Psi]", "]"}]}], ",", 
           RowBox[{"r", " ", 
            RowBox[{"Sin", "[", "\[Psi]", "]"}]}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "**", "**", "**", "**", "**", "**", "**", "**", "**", "   ", 
           "indeterminate"}], " ", 
          RowBox[{"(", 
           RowBox[{
           "same", " ", "as", " ", "the", " ", "\"\<else\>\"", " ", "part"}], 
           ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\[Phi]", "=", 
          RowBox[{"ArcTan", "@@", "\[Rho]vec"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Psi]", "=", "\[Phi]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"r", "=", 
          RowBox[{"2", "R", " ", 
           RowBox[{"Sin", "[", 
            FractionBox["\[Theta]", "2"], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"Cos", "[", "\[Psi]", "]"}]}], ",", 
           RowBox[{"r", " ", 
            RowBox[{"Sin", "[", "\[Psi]", "]"}]}]}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", 
    RowBox[{"n_", ",", "dir1_", ",", "dir2_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "n2", ",", "n3", ",", "dir3", ",", 
       RowBox[{"R", "=", "1"}], ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]",
        ",", "r", ",", "\[Rho]vec", ",", "\[Rho]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dir3", "=", 
       RowBox[{"dir1", "\[Cross]", "dir2"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"n1", "=", 
       RowBox[{"n", ".", "dir1"}]}], ";", 
      RowBox[{"n2", "=", 
       RowBox[{"n", ".", "dir2"}]}], ";", 
      RowBox[{"n3", "=", 
       RowBox[{"n", ".", "dir3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Theta]", "=", 
       RowBox[{"ArcCos", "[", "n3", "]"}]}], ";", 
      RowBox[{"\[Rho]vec", "=", 
       RowBox[{"{", 
        RowBox[{"n1", ",", "n2"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]", "=", 
       SqrtBox[
        RowBox[{"\[Rho]vec", ".", "\[Rho]vec"}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"\[Rho]", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
           "**", "**", "**", "  ", "then"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"n3", ">", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
           "**", "**", "**", "  ", "else"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\[Phi]", "=", 
          RowBox[{"ArcTan", "@@", "\[Rho]vec"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Psi]", "=", "\[Phi]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"r", "=", 
          RowBox[{"2", "R", " ", 
           RowBox[{"Sin", "[", 
            FractionBox["\[Theta]", "2"], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"Cos", "[", "\[Psi]", "]"}]}], ",", 
           RowBox[{"r", " ", 
            RowBox[{"Sin", "[", "\[Psi]", "]"}]}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "**", "**", "**", "**", "**", "**", "**", "**", "**", "   ", 
           "indeterminate"}], " ", 
          RowBox[{"(", 
           RowBox[{
           "same", " ", "as", " ", "the", " ", "\"\<else\>\"", " ", "part"}], 
           ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\[Phi]", "=", 
          RowBox[{"ArcTan", "@@", "\[Rho]vec"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Psi]", "=", "\[Phi]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"r", "=", 
          RowBox[{"2", "R", " ", 
           RowBox[{"Sin", "[", 
            FractionBox["\[Theta]", "2"], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"Cos", "[", "\[Psi]", "]"}]}], ",", 
           RowBox[{"r", " ", 
            RowBox[{"Sin", "[", "\[Psi]", "]"}]}]}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "/", "5"}], ",", 
     RowBox[{"4", "/", "5"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5943218679495387`*^9, 3.594321896605178*^9}, {
   3.594321950589266*^9, 3.5943221084622955`*^9}, {3.594322548978492*^9, 
   3.59432271557802*^9}, {3.594328759199696*^9, 3.5943287604227657`*^9}, {
   3.5943295056573906`*^9, 3.5943295432905436`*^9}, {3.594329672097911*^9, 
   3.5943297429559636`*^9}, {3.594330069218625*^9, 3.5943300732658563`*^9}, {
   3.5943301276979694`*^9, 3.5943301317532015`*^9}, {3.59433018347116*^9, 
   3.594330222958418*^9}, {3.5943302634557343`*^9, 3.59433030009583*^9}, 
   3.594330777057111*^9, {3.594330815291298*^9, 3.594330876296787*^9}, {
   3.5943310509457765`*^9, 3.5943310783603444`*^9}, {3.5943334465917997`*^9, 
   3.5943335104784536`*^9}}],

Cell["\<\


The following proves that the mapping truly is area preserving.
\tjacSphere is the area element on the unit sphere.
\tjacDisk is the area element on the disk
The result of this calculation is that they are equal\
\>", "Text",
 CellChangeTimes->{{3.5943298128589616`*^9, 3.5943298778176775`*^9}}],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"R", "=", "1"}], ",", "\[Theta]", ",", "\[Phi]", ",", "\[Eta]", 
     ",", "\[Nu]", ",", "jmat", ",", "jacSphere", ",", "jacDisk"}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"R", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
       RowBox[{"R", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
       RowBox[{"R", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Eta]", "=", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"jmat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"n", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"\[Eta]", "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"jacSphere", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"Det", "[", 
         RowBox[{
          RowBox[{"jmat", "\[Transpose]"}], ".", "jmat"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"0", "<", "\[Theta]", "<", "\[Pi]"}], ",", 
         RowBox[{"\[Phi]", ">", "0"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Nu]", "=", 
     RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", "n", "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"jmat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Nu]", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"\[Eta]", "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"jacDisk", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"Det", "[", 
         RowBox[{
          RowBox[{"jmat", "\[Transpose]"}], ".", "jmat"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"0", "<", "\[Theta]", "<", "\[Pi]"}], ",", 
         RowBox[{"\[Phi]", ">", "0"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"jacSphere", ",", "jacDisk"}], "}"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.5943269072157683`*^9, 3.594326920774544*^9}, {
  3.5943270248224955`*^9, 3.5943270291827445`*^9}, {3.5943270963825884`*^9, 
  3.5943272967260475`*^9}, {3.594327328157845*^9, 3.594327698078003*^9}, {
  3.5943279681954527`*^9, 3.5943279684834695`*^9}, {3.5943280436427684`*^9, 
  3.5943280620828233`*^9}, {3.594328153314041*^9, 3.5943282171376915`*^9}, {
  3.594329769487481*^9, 3.5943298006712646`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diskDotPlot", "[", 
   RowBox[{"ntab_", ",", "dir1_", ",", "dir2_", ",", 
    RowBox[{"colr_:", "Black"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "ctr", ",", "first", ",", "second", ",", "nam1", ",", "nam2", ",", 
      RowBox[{"prng", "=", 
       RowBox[{"2.1", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], ",", 
      RowBox[{"isize", "=", "200"}], ",", "ptsize", ",", "npts", ",", "dots", 
      ",", "circs", ",", "equatorColor", ",", 
      RowBox[{"lineStyle", "=", 
       RowBox[{"Thickness", "[", "0.015", "]"}]}], ",", 
      RowBox[{"dashStyle", "=", 
       RowBox[{"Dashing", "[", 
        RowBox[{"{", "}"}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"equatorColor", "=", "White"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"colr", "\[NotEqual]", "Black"}], ",", 
       RowBox[{"equatorColor", "=", "White"}], ",", 
       RowBox[{"equatorColor", "=", "Green"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"dir1", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"nam1", "=", "\"\<x\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"nam1", "=", "\"\<y\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"nam1", "=", "\"\<z\>\""}], ",", "_", ",", 
       RowBox[{"nam1", "=", 
        RowBox[{"ToString", "[", "dir1", "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"dir2", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"nam2", "=", "\"\<x\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"nam2", "=", "\"\<y\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"nam2", "=", "\"\<z\>\""}], ",", "_", ",", 
       RowBox[{"nam2", "=", 
        RowBox[{"ToString", "[", "dir2", "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"npts", "=", 
      RowBox[{"Length", "[", "ntab", "]"}]}], ";", 
     RowBox[{"ptsize", "=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"0.2", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"4", "\[Pi]"}], "npts"], ")"}], 
          RowBox[{"1", "/", "2"}]]}], ",", "0.03"}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"npts", "<", "200"}], ",", 
       RowBox[{
        RowBox[{"equatorColor", "=", "Gray"}], ";", 
        RowBox[{"lineStyle", "=", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], ";", 
        RowBox[{"dashStyle", "=", "Dashed"}]}]}], "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"npts", "<", "10"}], ",", 
       RowBox[{"ptsize", "=", "0.06"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"npts", "\[Equal]", "6"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dots", "=", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Graphics", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"color", "[", "idot", "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"ctr", "=", 
                RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", 
                 RowBox[{
                  RowBox[{"N", "[", 
                   RowBox[{"ntab", "[", 
                    RowBox[{"[", "idot", "]"}], "]"}], "]"}], ",", "dir1", 
                  ",", "dir2"}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"Disk", "[", 
                RowBox[{"ctr", ",", ".2"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Text", "[", 
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"ToString", "[", "idot", "]"}], ",", "White", ",", 
                   RowBox[{"FontFamily", "\[Rule]", "\"\<ArialBlack\>\""}], 
                   ",", "18"}], "]"}], "]"}], ",", "ctr"}], "]"}]}], 
             "\[IndentingNewLine]", "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"idot", ",", "6"}], "}"}]}], "]"}]}], ";", 
        RowBox[{"prng", "=", 
         RowBox[{"2.3", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], ";", 
        RowBox[{"isize", "=", "300"}], ";"}], "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dots", "=", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"LambertEqualAreaMappingFromSphereToDisk", "[", 
              RowBox[{
               RowBox[{"N", "[", 
                RowBox[{"ntab", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "dir1", ",", 
               "dir2"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "ntab", "]"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "prng"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"colr", ",", 
               RowBox[{"PointSize", "[", "ptsize", "]"}]}], "}"}], "}"}]}]}], 
          "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"circs", "=", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", "1", "]"}], ",", "equatorColor", ",", 
         "lineStyle", ",", "dashStyle", ",", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           SqrtBox["2"]}], "]"}], ",", 
         RowBox[{"Dashing", "[", 
          RowBox[{"{", "}"}], "]"}], ",", "Black", ",", 
         RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"npts", "<", "20"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"first", "=", "circs"}], ";", 
        RowBox[{"second", "=", "dots"}], ";"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"first", "=", "dots"}], ";", 
        RowBox[{"second", "=", "circs"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{"first", ",", "second", ",", 
       RowBox[{"PlotRange", "\[Rule]", "prng"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", 
       RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "isize"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"nam1", ",", "nam2"}], "}"}]}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"diskDotPlot", "[", "ntab_", "]"}], ":=", 
   RowBox[{"diskDotPlot", "[", 
    RowBox[{"ntab", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"diskDotPlot", "[", 
    RowBox[{"ntab_", ",", "colr_"}], "]"}], ":=", 
   RowBox[{"diskDotPlot", "[", 
    RowBox[{"ntab", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "colr"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.594320953619242*^9, 3.594321005226194*^9}, {
   3.5943210641205626`*^9, 3.594321100984671*^9}, {3.594321143376096*^9, 
   3.5943212275759115`*^9}, {3.594321826028141*^9, 3.5943218269771957`*^9}, {
   3.594322149536645*^9, 3.5943221525988197`*^9}, {3.5943223080807133`*^9, 
   3.5943223109598775`*^9}, {3.5943224839917746`*^9, 3.594322532430545*^9}, 
   3.5943227760594797`*^9, {3.5943234243215585`*^9, 3.594323425256612*^9}, {
   3.594323550863796*^9, 3.5943235638515387`*^9}, {3.5943305234546056`*^9, 
   3.5943306011680503`*^9}, {3.594336778459371*^9, 3.594336814042406*^9}, {
   3.594337356759448*^9, 3.5943374057182484`*^9}, {3.5943375154615254`*^9, 
   3.5943375187017107`*^9}, {3.5943375662674313`*^9, 3.594337590611824*^9}, {
   3.594337624028735*^9, 3.59433763268323*^9}}],

Cell["\<\
VERIFICATION TEST for the diskDotPlot function:  The Lambert projection is \
here shown for three different viewpoints: the first is the view down the \
z-axis, the next is the view of the same point from the x-axis, and the last \
one is the view from y-axis.\
\>", "Text",
 CellChangeTimes->{{3.5941842786378803`*^9, 3.594184297060934*^9}, {
  3.594567358647482*^9, 3.5945673711511965`*^9}, {3.594567407191258*^9, 
  3.594567486869816*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ntab", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"diskDotPlot", "[", 
        RowBox[{"ntab", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "Red"}], "]"}], ",", 
       "\"\<     \>\"", ",", 
       RowBox[{"diskDotPlot", "[", 
        RowBox[{"ntab", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "Green"}], "]"}], 
       ",", "\"\<     \>\"", ",", 
       RowBox[{"diskDotPlot", "[", 
        RowBox[{"ntab", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", "Blue"}], "]"}]}], 
      "}"}], "]"}]}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", "0", ",", "\[Pi]"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5941840666317544`*^9, {3.594184129111328*^9, 3.594184182751396*^9}, {
   3.594184312998846*^9, 3.5941843183211503`*^9}, {3.594322188825892*^9, 
   3.594322206417898*^9}, {3.5943223483730173`*^9, 3.594322360057686*^9}, {
   3.594323656471836*^9, 3.5943237198974648`*^9}, {3.594323808934557*^9, 
   3.5943238383912416`*^9}, 3.5943239292144365`*^9, {3.594567092307248*^9, 
   3.5945671833314543`*^9}, {3.594567300082132*^9, 3.5945673544412413`*^9}, {
   3.5945673885301905`*^9, 3.59456740040287*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sphereDotPlot", "[", 
   RowBox[{"ntab_", ",", 
    RowBox[{"colr_:", "Black"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ptsize", ",", "npts"}], "}"}], ",", 
    RowBox[{
     RowBox[{"npts", "=", 
      RowBox[{"Length", "[", "ntab", "]"}]}], ";", 
     RowBox[{"ptsize", "=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"0.25", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"4", "\[Pi]"}], "npts"], ")"}], 
          RowBox[{"1", "/", "2"}]]}], ",", "0.013"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Opacity", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"npts", "<", "5"}], ",", ".4", ",", "1"}], "]"}], "]"}], 
          ",", "White", ",", " ", 
          RowBox[{"Specularity", "[", 
           RowBox[{"White", ",", "10"}], "]"}], ",", 
          RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
          RowBox[{"Sphere", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", ".99"}], "]"}]}], 
         "}"}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", 
           RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Green", ",", 
            RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ListPointPlot3D", "[", 
        RowBox[{
         RowBox[{"N", "[", "ntab", "]"}], ",", 
         RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"colr", ",", 
             RowBox[{"PointSize", "[", "ptsize", "]"}]}], "}"}], "}"}]}]}], 
        "]"}], "\[IndentingNewLine]", ",", 
       RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ntab", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Normalize", "[", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "3"}], "]"}], "]"}], 
     ",", 
     RowBox[{"{", "2000", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p1", "=", 
    RowBox[{"sphereDotPlot", "[", "ntab", "]"}]}], ",", 
   RowBox[{"p2", "=", 
    RowBox[{"diskDotPlot", "[", "ntab", "]"}]}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.5556125956922426`*^9, 3.555612642219904*^9}, {
   3.555612798042816*^9, 3.555612841539304*^9}, {3.555612936506736*^9, 
   3.5556129802992406`*^9}, {3.5556130607388415`*^9, 
   3.5556130686582947`*^9}, {3.555613151330023*^9, 3.5556131565453215`*^9}, {
   3.5556132282974253`*^9, 3.5556132313135977`*^9}, {3.555613398376153*^9, 
   3.555613434896242*^9}, {3.5556137105750103`*^9, 3.5556138073425446`*^9}, {
   3.555613869310089*^9, 3.5556138882351713`*^9}, {3.5556139287104864`*^9, 
   3.5556140090220804`*^9}, {3.555614080109146*^9, 3.5556143883247747`*^9}, {
   3.5556144427798896`*^9, 3.5556145065535374`*^9}, {3.5556152290088596`*^9, 
   3.555615246191842*^9}, {3.555615282271906*^9, 3.555615321080126*^9}, {
   3.555615787529805*^9, 3.555615831607326*^9}, {3.555615904206478*^9, 
   3.555615984357063*^9}, {3.5556160395092173`*^9, 3.5556160401412535`*^9}, {
   3.5556161232770085`*^9, 3.555616147916418*^9}, {3.5556170323320036`*^9, 
   3.5556171457324896`*^9}, {3.555618103696282*^9, 3.555618126838606*^9}, {
   3.5556188190431976`*^9, 3.555618832769983*^9}, {3.55562401396533*^9, 
   3.555624026069022*^9}, {3.594166598784651*^9, 3.594166611771394*^9}, {
   3.5941666664485207`*^9, 3.594166807037562*^9}, {3.5941668998048677`*^9, 
   3.5941669003739004`*^9}, {3.594167221317258*^9, 3.5941672220362988`*^9}, {
   3.594172814204152*^9, 3.5941731075079284`*^9}, {3.594173139402753*^9, 
   3.594173147147196*^9}, {3.5941731799220705`*^9, 3.5941731997142024`*^9}, {
   3.594173356938195*^9, 3.594173381047574*^9}, {3.5941734857765636`*^9, 
   3.594173691208314*^9}, {3.5941737390160484`*^9, 3.5941739191673527`*^9}, {
   3.5941739742075005`*^9, 3.594174175171995*^9}, {3.594174208317891*^9, 
   3.5941742411567698`*^9}, {3.594174276940816*^9, 3.594174341956535*^9}, {
   3.5941748377558928`*^9, 3.594174838491935*^9}, {3.594174942305873*^9, 
   3.594174969656437*^9}, {3.594175110240478*^9, 3.5941751108795147`*^9}, {
   3.59417515503004*^9, 3.5941751806945076`*^9}, 3.5941752747858896`*^9, {
   3.5941759398039265`*^9, 3.594175940619973*^9}, {3.594177156802535*^9, 
   3.5941771708033357`*^9}, 3.5941805263132596`*^9, {3.5941810580386724`*^9, 
   3.594181085648252*^9}, {3.594181131790891*^9, 3.5941811440215907`*^9}, 
   3.594182043432034*^9, {3.5941825847079935`*^9, 3.5941826489176655`*^9}, {
   3.5941826877158847`*^9, 3.5941827194266987`*^9}, {3.59418275581878*^9, 
   3.59418286910626*^9}, {3.594182911282672*^9, 3.5941832606646557`*^9}, {
   3.5941832935925393`*^9, 3.5941832970397363`*^9}, {3.594183346670575*^9, 
   3.594183394422306*^9}, {3.594183894114887*^9, 3.594183894234894*^9}, 
   3.5941840515988946`*^9, 3.5941843583594403`*^9, {3.5941844345607986`*^9, 
   3.5941844370489407`*^9}, {3.5941845295282307`*^9, 3.594184536663639*^9}, {
   3.594184598262162*^9, 3.5941845986941867`*^9}, 3.5941849668852463`*^9, {
   3.5942170750997305`*^9, 3.5942170878424597`*^9}, {3.594217162463728*^9, 
   3.594217207295292*^9}, 3.594217266649687*^9, 3.5942173372477245`*^9, {
   3.5942212157155604`*^9, 3.594221310410977*^9}, {3.5942213814940424`*^9, 
   3.5942214831058545`*^9}, {3.5942215219540763`*^9, 
   3.5942219951331406`*^9}, {3.5942220335193357`*^9, 3.594222126362646*^9}, {
   3.594222161725669*^9, 3.5942221824228525`*^9}, {3.5942222374209986`*^9, 
   3.5942222559730597`*^9}, 3.5942436368849783`*^9, {3.594243692411154*^9, 
   3.5942437167555466`*^9}, {3.59424405722002*^9, 3.5942441857233696`*^9}, 
   3.5942442269797297`*^9, {3.594244257075451*^9, 3.5942442933825274`*^9}, {
   3.594320225714608*^9, 3.59432034305732*^9}, {3.594320441455948*^9, 
   3.5943205510122147`*^9}, {3.5943205885753627`*^9, 
   3.5943208427659016`*^9}, {3.5943209044444294`*^9, 
   3.5943209238525395`*^9}, {3.594337319826336*^9, 3.5943373329140844`*^9}}],

Cell["\<\
The above example shows bias when simply normalizing a vector {r1,r2,r3} \
because it basically creates a point in a cube and then normalizes it, and \
the above plot shows \[OpenCurlyDoubleQuote]echos\[CloseCurlyDoubleQuote] of \
the cube.  The above plot also shows superiority of the Lambert mapping for \
more clearly showing bias in the sampling.


Below is a correct uniform sampling\
\>", "Text",
 CellChangeTimes->{{3.59417599511209*^9, 3.594176079838936*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ntab", "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"z", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "=", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ";", 
        RowBox[{"\[Theta]", "=", 
         RowBox[{"ArcCos", "[", "z", "]"}]}], ";", 
        RowBox[{"\[Phi]", "=", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}], "]"}]}], ";", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", "5000", "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p1", "=", 
    RowBox[{"sphereDotPlot", "[", "ntab", "]"}]}], ",", 
   RowBox[{"p2", "=", 
    RowBox[{"diskDotPlot", "[", 
     RowBox[{"ntab", ",", "Blue"}], "]"}]}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.594174548611355*^9, 3.5941747334269257`*^9}, {
   3.5941747990026765`*^9, 3.594174817762749*^9}, 3.594180535385779*^9, {
   3.5943374715430136`*^9, 3.5943374732801127`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nautical representation of a rotation", "Subsection",
 CellChangeTimes->{{3.5556070946265993`*^9, 3.555607101473991*^9}, {
  3.594176087823393*^9, 3.5941760920626354`*^9}}],

Cell["\<\
The following takes a list of rotations as input and returns a table of \
Graphics3D commands for the Nautical arrows representing the rotations.
The Nautical representation puts the \[OpenCurlyDoubleQuote]mast\
\[CloseCurlyDoubleQuote] of a sailboat pointing in the direction of the third \
column of the rotation.  The first column of the rotation defines the heading \
of the boat. \
\>", "Text",
 CellChangeTimes->{{3.5556087943978205`*^9, 3.555608830541888*^9}, {
  3.594176100807135*^9, 3.594176155942289*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeArrowTable", "[", "rlist_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"autosizeReductionFactor", "=", "2.0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"th", "=", "2"}], ",", 
       RowBox[{"tw", "=", "10"}], ",", 
       RowBox[{"(*", 
        RowBox[{"tail", " ", "height", " ", "and", " ", "width"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"ah", "=", ".5"}], ",", 
       RowBox[{"aw", "=", "4"}], ",", 
       RowBox[{"(*", 
        RowBox[{"arrow", " ", "height", " ", "and", " ", "width"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"as", "=", ".1"}], ",", 
       RowBox[{"(*", 
        RowBox[{
        "arrow", " ", "scale", " ", "of", " ", "aw", " ", "to", " ", "angle", 
         " ", "arrowhead", " ", "back", " ", "a", " ", "bit"}], "*)"}], 
       "\[IndentingNewLine]", "characteristicLength", ",", "scalefac", ",", 
       "n", ",", "arrowLength", ",", "arrow", ",", "arrow3D", ",", "nr"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"arrowLength", "=", 
       RowBox[{"tw", "+", "aw"}]}], 
      RowBox[{"(*", " ", 
       RowBox[{
       "total", " ", "length", " ", "of", " ", "nominal", " ", "arrow", " ", 
        "defined", " ", "here"}], "*)"}], ";", "\[IndentingNewLine]", 
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "rlist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"characteristicLength", "=", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"N", "[", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"4", "\[Pi]"}], "n"], ")"}], 
           RowBox[{"1", "/", "2"}]], "]"}], ",", "0.2"}], "]"}]}], ";", 
      RowBox[{"scalefac", "=", 
       RowBox[{"autosizeReductionFactor", "*", 
        FractionBox["characteristicLength", "arrowLength"]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"arrow", "=", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"-", "th"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"tw", ",", 
           RowBox[{
            RowBox[{"-", "th"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tw", "-", 
            RowBox[{"aw", "*", "as"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"th", "+", "ah"}], ")"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tw", "+", "aw"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tw", "-", 
            RowBox[{"aw", "*", "as"}]}], ",", 
           RowBox[{"th", "+", "ah"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"tw", ",", 
           RowBox[{"th", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"th", "/", "2"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"two", "-", 
        RowBox[{"dimensional", " ", "reference", " ", "arrow"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"arrow", "[", 
          RowBox[{"[", 
           RowBox[{"apnt", ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"arrow", "[", 
           RowBox[{"[", 
            RowBox[{"apnt", ",", "1"}], "]"}], "]"}], "-", 
          RowBox[{"arrowLength", "/", "2"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"apnt", ",", 
          RowBox[{"Length", "[", "arrow", "]"}]}], "}"}]}], "]"}], ";", 
      RowBox[{"(*", " ", 
       RowBox[{"center", " ", "the", " ", "arrow"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"arrow", "=", 
       RowBox[{"arrow", "*", "scalefac"}]}], ";", 
      RowBox[{"nr", "=", 
       RowBox[{"Length", "[", "rlist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"arrow3D", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"r", "/", "nr"}], "]"}], ",", 
           RowBox[{"Polygon", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"rlist", "[", 
                RowBox[{"[", 
                 RowBox[{"r", ",", "All", ",", "3"}], "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"rlist", "[", 
                 RowBox[{"[", "r", "]"}], "]"}], ".", 
                RowBox[{"Append", "[", 
                 RowBox[{
                  RowBox[{"arrow", "[", 
                   RowBox[{"[", "apnt", "]"}], "]"}], ",", "0"}], "]"}]}]}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"apnt", ",", 
                RowBox[{"Length", "[", "arrow", "]"}]}], "}"}]}], "]"}], 
            "\[IndentingNewLine]", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "nr"}], "}"}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5555971252533836`*^9, 3.555597225266104*^9}, {
   3.555597265938431*^9, 3.555597305705705*^9}, {3.5555973364014606`*^9, 
   3.5555974180571313`*^9}, {3.555597478929613*^9, 3.555597824909402*^9}, {
   3.5555979062740555`*^9, 3.5555979898968387`*^9}, {3.555598201319931*^9, 
   3.5555982322637014`*^9}, {3.5555982698408504`*^9, 3.555598356782823*^9}, {
   3.5555983969111185`*^9, 3.5555984091348176`*^9}, {3.5555984401665926`*^9, 
   3.555598477342719*^9}, {3.5555985102546015`*^9, 3.5555985811426563`*^9}, {
   3.555598659029111*^9, 3.5555986852386103`*^9}, {3.5555987223027296`*^9, 
   3.5555987742377005`*^9}, {3.5555990470183024`*^9, 3.5555990483453784`*^9}, 
   3.555599276193411*^9, {3.5555994747917695`*^9, 3.5555995105838165`*^9}, 
   3.5555995565894485`*^9, {3.555599591959471*^9, 3.555599732238495*^9}, {
   3.5556059245946774`*^9, 3.555605986374211*^9}, {3.5556063130648966`*^9, 
   3.5556063862320814`*^9}, {3.5556064411442223`*^9, 
   3.5556065738308115`*^9}, {3.5556066047195787`*^9, 
   3.5556066321981497`*^9}, {3.555608946389514*^9, 3.5556089829726067`*^9}, {
   3.555623442393638*^9, 3.5556234534492702`*^9}, {3.594165436218156*^9, 
   3.5941654479698277`*^9}, {3.5941694850857377`*^9, 
   3.5941695180196214`*^9}, {3.5941695620431395`*^9, 
   3.5941695628501854`*^9}, {3.594170792835537*^9, 3.5941708062363033`*^9}, 
   3.5941708481547008`*^9}],

Cell["The following plots the arrows created using makeArrowTable", "Text",
 CellChangeTimes->{{3.555611835448759*^9, 3.5556118512166605`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NauticalPlot", "[", "rlist_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"nmax", "=", "2000"}], ",", 
      RowBox[{"c1", "=", "Black"}], ",", 
      RowBox[{"c2", "=", "Black"}], ",", 
      RowBox[{"c3", "=", "Black"}], ",", 
      RowBox[{"dd", "=", ".3"}], ",", "rot"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "rlist", "]"}], ">", "nmax"}], ",", 
       RowBox[{
        RowBox[{"rot", "=", 
         RowBox[{"RandomChoice", "[", 
          RowBox[{"rlist", ",", "nmax"}], "]"}]}], ";"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Nautical depiction of \>\"", ",", "nmax", ",", 
          "\"\< out of \>\"", ",", 
          RowBox[{"Length", "[", "rlist", "]"}], ",", "\"\< rotations\>\""}], 
         "]"}], "*)"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"rot", "=", "rlist"}], ";"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Nautical depiction of \>\"", ",", 
          RowBox[{"Length", "[", "rlist", "]"}], ",", "\"\< rotations\>\""}], 
         "]"}], "*)"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<Can't determine length of rlist\>\"", "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "rlist", "]"}], "<", "5"}], ",", ".5", 
            ",", "1"}], "]"}], "]"}], ",", "White", ",", " ", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "10"}], "]"}], ",", 
         RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
         RowBox[{"Sphere", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"Opacity", "[", "1", "]"}], ",", 
         RowBox[{"makeArrowTable", "[", "rot", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "\[IndentingNewLine]",
          "c1", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "+", "dd"}], ",", "0", ",", "0"}], "}"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<x\>\"", ",", "Italic", ",", "c1", ",", "16"}], "]"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"1.4", "dd"}]}], ",", "0", ",", "0"}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", "c2", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"1", "+", "dd"}], ",", "0"}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<y\>\"", ",", "Italic", ",", "c2", ",", "16"}], "]"}],
            ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "+", 
              RowBox[{"1.4", "dd"}]}], ",", "0"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "c3", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"1", "+", "dd"}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<z\>\"", ",", "Italic", ",", "c3", ",", "16"}], "]"}],
            ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"1", "+", 
              RowBox[{"1.4", "dd"}]}]}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "-", "dd"}], ",", 
            RowBox[{"1", "+", "dd"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "-", "dd"}], ",", 
            RowBox[{"1", "+", "dd"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "-", "dd"}], ",", 
            RowBox[{"1", "+", "dd"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ImageCrop", "[", 
  RowBox[{"NauticalPlot", "[", 
   RowBox[{"{", 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"3", "/", "5"}], 
        RowBox[{"4", "/", "5"}], "0"},
       {"0", "0", 
        RowBox[{"-", "1"}]},
       {
        RowBox[{
         RowBox[{"-", "4"}], "/", "5"}], 
        RowBox[{"3", "/", "5"}], "0"}
      }], ")"}], "}"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5555978898971186`*^9, 3.5555979001717067`*^9}, {
   3.555598795261903*^9, 3.555598799550148*^9}, {3.55559902914028*^9, 
   3.555599209514597*^9}, {3.555607181443565*^9, 3.55560723118641*^9}, {
   3.5556074252655106`*^9, 3.5556074316258745`*^9}, {3.555607545729401*^9, 
   3.555607639272751*^9}, {3.5556076847213507`*^9, 3.5556076855503983`*^9}, {
   3.5556079708327155`*^9, 3.555608127077652*^9}, {3.555608157078368*^9, 
   3.5556084265577817`*^9}, {3.555608463373887*^9, 3.555608537517128*^9}, {
   3.5556086076851416`*^9, 3.5556086446372547`*^9}, {3.5556090365716724`*^9, 
   3.5556090511535063`*^9}, {3.5556090845534167`*^9, 3.555609160753775*^9}, {
   3.555609192601597*^9, 3.555609309121261*^9}, {3.5556093965522623`*^9, 
   3.555609593192509*^9}, 3.555609645757516*^9, 3.5556096858088064`*^9, {
   3.5556097203037796`*^9, 3.555609720926815*^9}, {3.555609902248186*^9, 
   3.555609903038231*^9}, 3.555611783963814*^9, {3.5556188580484285`*^9, 
   3.555618860359561*^9}, {3.5556191254877253`*^9, 3.5556191271818223`*^9}, {
   3.5556194468371058`*^9, 3.555619447196126*^9}, {3.555623272610927*^9, 
   3.555623272960947*^9}, {3.5556234629278126`*^9, 3.5556234632318296`*^9}, {
   3.594177022582858*^9, 3.5941770558627615`*^9}, {3.59418119383344*^9, 
   3.594181319103605*^9}, {3.5942453872290916`*^9, 3.5942454006598597`*^9}, {
   3.594245475436137*^9, 3.5942455079269953`*^9}, {3.594245549228358*^9, 
   3.594245566723358*^9}, {3.5942456071046677`*^9, 3.59424561308601*^9}, {
   3.5943216696911993`*^9, 3.5943216810778503`*^9}}],

Cell[TextData[{
 "Below are defined several rotation functions that map three numbers (each \
on the interval from 0 to 1) to the nine components of a rotation tensor. The \
following function evaluates the Jacobian of the transformation, divided by \
the 3D surface area of a sphere of radius ",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]]],
 " in 4-D space.  The mapping is uniform if the Jacobian is independent of \
the inputs.  This function takes a while to run, so it is skipped if skipJac \
is true."
}], "Text",
 CellChangeTimes->{{3.594319360020094*^9, 3.594319415324257*^9}, {
  3.5943194636360197`*^9, 3.594319508603592*^9}, {3.5943196676026864`*^9, 
  3.5943197087780414`*^9}, {3.5943197746578093`*^9, 3.5943197809971724`*^9}, {
  3.5943214321096106`*^9, 3.5943215007015333`*^9}}],

Cell[BoxData[
 RowBox[{"skipJac", "=", "True"}]], "Input",
 CellChangeTimes->{{3.5943195016531944`*^9, 3.594319511084734*^9}, {
  3.594319716138462*^9, 3.594319718042571*^9}, {3.5943200310964766`*^9, 
  3.5943200468083754`*^9}, {3.594324876094595*^9, 3.594324876686629*^9}, {
  3.594325499562255*^9, 3.594325500226293*^9}, {3.5943328942932096`*^9, 
  3.594332895459276*^9}, {3.5943456973155007`*^9, 3.5943457030298276`*^9}, {
  3.5943517688807745`*^9, 3.5943517694648075`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"jacRot", "[", "rotfn_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "r", ",", "r1", ",", "r2", ",", "r3", ",", "\[DoubleStruckCapitalR]", 
      ",", "dRdr", ",", "jacobian", ",", 
      RowBox[{"area4Dsphere", "=", 
       RowBox[{"6", 
        SqrtBox["3"], 
        SuperscriptBox["\[Pi]", "2"]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{"skipJac", ",", 
       RowBox[{"Return", "[", "\"\<skipJac is True\>\"", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"{", 
       RowBox[{"r1", ",", "r2", ",", "r3"}], "}"}]}], ";", 
     RowBox[{"\[DoubleStruckCapitalR]", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"rotfn", "@@", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dRdr", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"\[DoubleStruckCapitalR]", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"r", "[", 
           RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"jacobian", "=", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Det", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", "dRdr", "]"}], ".", "dRdr"}], "]"}], 
        "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"jacobian", "/", "area4Dsphere"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.5943198391154966`*^9, 3.594319855339424*^9}, {
  3.5943199434504642`*^9, 3.5943200235300446`*^9}, {3.5943200697546883`*^9, 
  3.5943200729868727`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization of collection of rotations.", "Subsection",
 CellChangeTimes->{{3.5556121142147036`*^9, 3.5556121327667646`*^9}, {
  3.5556185910891595`*^9, 3.5556185970645013`*^9}}],

Cell["\<\
This makes a 2x4 grid. The first three entries on each row depict the \
rotations of e1, e2, and e3. The last entry in each row is the Nautical \
representation.
The 1st row corresponds to the result when the three random numbers are \
rectilinearly spaced on a perfect cube.
The 2nd row corresponds to the result when the three random numbers are \
randomly selected from a cube.\
\>", "Text",
 CellChangeTimes->{{3.5556121370540094`*^9, 3.555612267509471*^9}, {
   3.555618610281257*^9, 3.5556186677045417`*^9}, 3.594569924285228*^9}],

Cell["\<\
Allowable values for dotPlotFunction are sphereDotPlot and diskDotPlot\
\>", "Text",
 CellChangeTimes->{{3.5556185168259115`*^9, 3.5556185359290047`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gridit", "[", "x_", "]"}], ":=", 
   RowBox[{"Flatten", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gridit", "[", "x_", "]"}], ":=", 
   RowBox[{"Grid", "[", "x", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5556237389426*^9, 3.5556238283167114`*^9}, {
  3.5941714978038588`*^9, 3.594171501976097*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"visualizeRotation", "[", 
   RowBox[{"rotFunction_", ",", "dotPlotFunction_", ",", "ndiv_", ",", 
    RowBox[{"overlay_:", "False"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "rot", ",", "r1", ",", "r2", ",", "r3", ",", "\[Delta]", ",", "nlist", 
      ",", "jnk", ",", 
      RowBox[{"hue", "=", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Blue"}], "}"}]}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{"skipLengthyComputations", ",", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<skipLengthyComputations is True\>\"", "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Delta]", "=", 
      RowBox[{"1", "/", "ndiv"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"gridit", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"rot", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"Transpose", "@", 
               RowBox[{"rotFunction", "[", 
                RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"r1", ",", "0", ",", "1", ",", "\[Delta]"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"r2", ",", "0", ",", "1", ",", "\[Delta]"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"r3", ",", "0", ",", "1", ",", "\[Delta]"}], "}"}]}], 
             "]"}], ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nlist", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"Transpose", "/@", "rot"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"jnk", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"jnk", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"dotPlotFunction", "[", 
                  RowBox[{
                   RowBox[{"nlist", "[", 
                    RowBox[{"[", "idir", "]"}], "]"}], ",", 
                   RowBox[{"hue", "[", 
                    RowBox[{"[", "idir", "]"}], "]"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"idir", ",", "3"}], "}"}]}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{"overlay", ",", 
                RowBox[{"{", 
                 RowBox[{"Show", "[", "jnk", "]"}], "}"}], ",", "jnk"}], 
               "]"}]}], ",", 
             RowBox[{"NauticalPlot", "[", "rot", "]"}]}], "}"}], "]"}]}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", "-"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"rot", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"r1", "=", 
                RowBox[{"RandomReal", "[", "]"}]}], ";", 
               RowBox[{"r2", "=", 
                RowBox[{"RandomReal", "[", "]"}]}], ";", 
               RowBox[{"r3", "=", 
                RowBox[{"RandomReal", "[", "]"}]}], ";", 
               RowBox[{"Transpose", "@", 
                RowBox[{"rotFunction", "[", 
                 RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "0", ",", "ndiv"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", "0", ",", "ndiv"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", "ndiv"}], "}"}]}], "]"}], ",", 
            "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nlist", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"Transpose", "/@", "rot"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"jnk", "=", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"dotPlotFunction", "[", 
                 RowBox[{
                  RowBox[{"nlist", "[", 
                   RowBox[{"[", "idir", "]"}], "]"}], ",", 
                  RowBox[{"hue", "[", 
                   RowBox[{"[", "idir", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"idir", ",", "3"}], "}"}]}], "]"}]}], ";", 
             RowBox[{"If", "[", 
              RowBox[{"overlay", ",", 
               RowBox[{"{", 
                RowBox[{"Show", "[", "jnk", "]"}], "}"}], ",", "jnk"}], 
              "]"}]}], "\[IndentingNewLine]", ",", 
            RowBox[{"NauticalPlot", "[", "rot", "]"}]}], "}"}], 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.5941663469452467`*^9, 3.5941663594969645`*^9}, {
   3.5941664107528963`*^9, 3.594166415496167*^9}, {3.5941675174011927`*^9, 
   3.59416751857226*^9}, {3.5941676329288006`*^9, 3.594167643912429*^9}, {
   3.5941678324412117`*^9, 3.5941678491461673`*^9}, {3.5941678971179113`*^9, 
   3.5941679171060543`*^9}, {3.594167976046426*^9, 3.5941680112214375`*^9}, {
   3.5941680609812837`*^9, 3.594168103784732*^9}, {3.594168385571849*^9, 
   3.594168387070935*^9}, {3.5941684650023923`*^9, 3.594168484595513*^9}, {
   3.5941685208915887`*^9, 3.5941685452509823`*^9}, 3.5941685963059025`*^9, {
   3.594170911363316*^9, 3.594170957446952*^9}, {3.594170990894865*^9, 
   3.594171075441701*^9}, {3.5941711281627164`*^9, 3.5941711412774663`*^9}, {
   3.594171587116967*^9, 3.594171600228717*^9}, {3.594171642185117*^9, 
   3.5941716512326345`*^9}, {3.5941716870326815`*^9, 3.594171772212554*^9}, {
   3.5941718120868344`*^9, 3.5941718310039167`*^9}, {3.59417190222299*^9, 
   3.594171910948489*^9}, {3.594171946565526*^9, 3.594172006057929*^9}, {
   3.5941726148447495`*^9, 3.594172662108453*^9}, {3.594176547204668*^9, 
   3.5941765498928213`*^9}, {3.594176902895012*^9, 3.5941769051471405`*^9}, {
   3.5941773132104807`*^9, 3.594177319554844*^9}, {3.5941775539382496`*^9, 
   3.5941776704969163`*^9}, {3.59417778821865*^9, 3.5941777897847395`*^9}, {
   3.594177826392833*^9, 3.594177845184908*^9}, {3.594177876993727*^9, 
   3.594177953359095*^9}, {3.594177983671829*^9, 3.5941781755828056`*^9}, {
   3.594178223141526*^9, 3.594178272845369*^9}, 3.594180810283502*^9, {
   3.594180842507345*^9, 3.5941808591792984`*^9}, {3.5941813631781254`*^9, 
   3.5941814023063636`*^9}, {3.5941820827092805`*^9, 
   3.5941820835743303`*^9}, {3.5941821916855135`*^9, 3.594182192752575*^9}, {
   3.594337040957385*^9, 3.5943371814364204`*^9}, {3.594337732815957*^9, 
   3.5943377601935234`*^9}, {3.5945695084224415`*^9, 3.5945695769503613`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"visualizeRotation", "[", 
   RowBox[{"rotFunction_", ",", "dotPlotFunction_", ",", "ndiv_", ",", 
    RowBox[{"overlay_:", "False"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "rot", ",", "r1", ",", "r2", ",", "r3", ",", "\[Delta]", ",", "nlist", 
      ",", "jnk"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{"skipLengthyComputations", ",", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<skipLengthyComputations is True\>\"", "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Delta]", "=", 
      RowBox[{"1", "/", "ndiv"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"gridit", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"rot", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"rotFunction", "[", 
               RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"r1", ",", "0", ",", "1", ",", "\[Delta]"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"r2", ",", "0", ",", "1", ",", "\[Delta]"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"r3", ",", "0", ",", "1", ",", "\[Delta]"}], "}"}]}], 
             "]"}], ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nlist", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"Transpose", "/@", "rot"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"jnk", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"jnk", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"dotPlotFunction", "[", 
                  RowBox[{
                   RowBox[{"nlist", "[", 
                    RowBox[{"[", "idir", "]"}], "]"}], ",", 
                   RowBox[{"Hue", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"idir", "-", "1"}], ")"}], "/", "3"}], "]"}]}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"idir", ",", "3"}], "}"}]}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{"overlay", ",", 
                RowBox[{"{", 
                 RowBox[{"Show", "[", "jnk", "]"}], "}"}], ",", "jnk"}], 
               "]"}]}], ",", 
             RowBox[{"NauticalPlot", "[", "rot", "]"}]}], "}"}], "]"}]}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", "-"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"rot", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"r1", "=", 
                RowBox[{"RandomReal", "[", "]"}]}], ";", 
               RowBox[{"r2", "=", 
                RowBox[{"RandomReal", "[", "]"}]}], ";", 
               RowBox[{"r3", "=", 
                RowBox[{"RandomReal", "[", "]"}]}], ";", 
               RowBox[{"rotFunction", "[", 
                RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "0", ",", "ndiv"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", "0", ",", "ndiv"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", "ndiv"}], "}"}]}], "]"}], ",", 
            "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nlist", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"Transpose", "/@", "rot"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"jnk", "=", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"dotPlotFunction", "[", 
                 RowBox[{
                  RowBox[{"nlist", "[", 
                   RowBox[{"[", "idir", "]"}], "]"}], ",", 
                  RowBox[{"Hue", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"idir", "-", "1"}], ")"}], "/", "3"}], "]"}]}], 
                 "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"idir", ",", "3"}], "}"}]}], "]"}]}], ";", 
             RowBox[{"If", "[", 
              RowBox[{"overlay", ",", 
               RowBox[{"{", 
                RowBox[{"Show", "[", "jnk", "]"}], "}"}], ",", "jnk"}], 
              "]"}]}], "\[IndentingNewLine]", ",", 
            RowBox[{"NauticalPlot", "[", "rot", "]"}]}], "}"}], 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.5941663469452467`*^9, 3.5941663594969645`*^9}, {
   3.5941664107528963`*^9, 3.594166415496167*^9}, {3.5941675174011927`*^9, 
   3.59416751857226*^9}, {3.5941676329288006`*^9, 3.594167643912429*^9}, {
   3.5941678324412117`*^9, 3.5941678491461673`*^9}, {3.5941678971179113`*^9, 
   3.5941679171060543`*^9}, {3.594167976046426*^9, 3.5941680112214375`*^9}, {
   3.5941680609812837`*^9, 3.594168103784732*^9}, {3.594168385571849*^9, 
   3.594168387070935*^9}, {3.5941684650023923`*^9, 3.594168484595513*^9}, {
   3.5941685208915887`*^9, 3.5941685452509823`*^9}, 3.5941685963059025`*^9, {
   3.594170911363316*^9, 3.594170957446952*^9}, {3.594170990894865*^9, 
   3.594171075441701*^9}, {3.5941711281627164`*^9, 3.5941711412774663`*^9}, {
   3.594171587116967*^9, 3.594171600228717*^9}, {3.594171642185117*^9, 
   3.5941716512326345`*^9}, {3.5941716870326815`*^9, 3.594171772212554*^9}, {
   3.5941718120868344`*^9, 3.5941718310039167`*^9}, {3.59417190222299*^9, 
   3.594171910948489*^9}, {3.594171946565526*^9, 3.594172006057929*^9}, {
   3.5941726148447495`*^9, 3.594172662108453*^9}, {3.594176547204668*^9, 
   3.5941765498928213`*^9}, {3.594176902895012*^9, 3.5941769051471405`*^9}, {
   3.5941773132104807`*^9, 3.594177319554844*^9}, {3.5941775539382496`*^9, 
   3.5941776704969163`*^9}, {3.59417778821865*^9, 3.5941777897847395`*^9}, {
   3.594177826392833*^9, 3.594177845184908*^9}, {3.594177876993727*^9, 
   3.594177953359095*^9}, {3.594177983671829*^9, 3.5941781755828056`*^9}, {
   3.594178223141526*^9, 3.594178272845369*^9}, 3.594180810283502*^9, {
   3.594180842507345*^9, 3.5941808591792984`*^9}, {3.5941813631781254`*^9, 
   3.5941814023063636`*^9}, {3.5941820827092805`*^9, 
   3.5941820835743303`*^9}, {3.5941821916855135`*^9, 3.594182192752575*^9}, {
   3.5942640722718153`*^9, 3.5942640835034575`*^9}, {3.594569605133973*^9, 
   3.5945696056950054`*^9}}],

Cell["\<\



The following is the workhorse visualizer.  It shows three representatins for \
a rotation.  It uses the above functions with a rotation list of length 1.\
\>", "Text",
 CellChangeTimes->{{3.5945699406451635`*^9, 3.5945700007646017`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"visRotation", "[", 
   RowBox[{
   "rotFunction_", ",", "dotPlotFunction_", ",", "r1_", ",", "r2_", ",", 
    "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rot", ",", "nlist", ",", 
      RowBox[{"range", "=", 
       RowBox[{"1.7", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rot", "=", 
      RowBox[{"rotFunction", "[", 
       RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}]}], ";", 
     RowBox[{"Nlist", "=", 
      RowBox[{"eloc", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "3"}], "]"}], "]"}]}], ";", 
     RowBox[{"nlist", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"rot", ".", 
         RowBox[{"Nlist", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "6"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"dotPlotFunction", "[", "nlist", "]"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"showMap", "[", 
          RowBox[{
           RowBox[{"rotFunction", "[", 
            RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", "range"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"ImageCrop", "[", 
            RowBox[{"NauticalPlot", "[", 
             RowBox[{"{", "rot", "}"}], "]"}], "]"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "}"}], "]"}]}]}], "\[IndentingNewLine]",
    "]"}]}]], "Input",
 CellChangeTimes->{
  3.594186223235105*^9, 3.5941863687734294`*^9, 3.5941864742174606`*^9, {
   3.5941872828357105`*^9, 3.5941872895400944`*^9}, 3.5941879685589323`*^9, {
   3.5941881710145116`*^9, 3.594188177055857*^9}, 3.594188210589775*^9, {
   3.5942438086288013`*^9, 3.594243902267157*^9}, {3.5942439443705654`*^9, 
   3.594243975082322*^9}, {3.594244316648858*^9, 3.5942443656486607`*^9}, {
   3.594244539615611*^9, 3.594244542582781*^9}, {3.59424468399887*^9, 
   3.5942446930703883`*^9}, {3.5942447447183423`*^9, 
   3.5942448067578907`*^9}, {3.594244882901246*^9, 3.5942449717163258`*^9}, {
   3.5942450745082054`*^9, 3.5942451147965097`*^9}, {3.5942453014981885`*^9, 
   3.5942453356821437`*^9}, {3.5942456351202707`*^9, 3.594245661975806*^9}, {
   3.594245742367405*^9, 3.594245758046302*^9}, {3.594245830734459*^9, 
   3.594245888117741*^9}, {3.5942460175571446`*^9, 3.594246060556604*^9}, {
   3.5942653452386246`*^9, 3.594265346452694*^9}, {3.5942654613242645`*^9, 
   3.594265462484331*^9}, {3.5943033613190203`*^9, 3.594303362312077*^9}, {
   3.594332802447956*^9, 3.5943328667756357`*^9}, {3.5943331883990316`*^9, 
   3.5943332318605175`*^9}, 3.5943335489156523`*^9, {3.594344046089056*^9, 
   3.594344047257123*^9}, {3.5943445036452265`*^9, 3.5943445047822914`*^9}, {
   3.5943467816385202`*^9, 3.594346782611576*^9}, {3.594346833589492*^9, 
   3.594346836949684*^9}, {3.59434787557409*^9, 3.594347885861678*^9}, {
   3.59435179886749*^9, 3.5943518003555746`*^9}, {3.594354250537717*^9, 
   3.594354256283046*^9}, {3.5943604752937527`*^9, 3.5943605023493004`*^9}, {
   3.594360621724128*^9, 3.5943606221561527`*^9}, {3.594360666947715*^9, 
   3.594360688099924*^9}, {3.5945697091379223`*^9, 3.59456971085002*^9}, {
   3.5945700094630995`*^9, 3.5945700103671513`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Various mappings from 3 numbers (each on the interval from 0 to 1) to a \
rotation\
\>", "Section",
 CellChangeTimes->{{3.594319331541465*^9, 3.594319355148815*^9}, {
  3.594564888912221*^9, 3.594564891856389*^9}}],

Cell["\<\
Not all of the following mappings provide uniform Jacobians, which are needed \
to get a uniform mapping.\
\>", "Text",
 CellChangeTimes->{{3.5945650415039487`*^9, 3.5945650651272993`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Arvo Random Rotation (most elegant and efficient means of generating a \
uniform, non-biased, rotation)\
\>", "Subsection",
 CellChangeTimes->{{3.555607116769866*^9, 3.5556071208100967`*^9}, {
  3.5945651411106453`*^9, 3.594565169590275*^9}}],

Cell[TextData[Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsnQWUFEf7rz/cXReX4K7B3d01eICLuwY5EODiENwlcJHgDsEJGtzdCe7u
c587ddNn/rPCArPs0t/vOSecma7qqrdk0k/11vQkbdyuSuMQ//nPfyLzz3r+
+3+vHUIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBC
CCGEEEIIIYQQQgghhBBCCCGEEEIIIYQnuHr16gEhhBAe4tatW4H9/3UhhBCe
4X/9r//1HyGEEB7if//v/x3Y/18XQgjhGYwn58yZs5oQQoivIH369PJkIYSw
E8aT/8//+T+BHYgQQnzfYMjyZCGEsBPyZCGE8AjyZCGEsBnyZCGE8AjyZCGE
sBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8Ajy
ZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE
8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBny
ZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGE
sBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8Ajy
ZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE
8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBny
ZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGE
sBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8Ajy
ZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE
8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBny
ZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGE
sBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8Ajy
ZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBnyZCGE8AjyZCGEsBlBzZPP
nj17/fr1wI7ie+LRo0ctW7bcu3dvYAcS1KGj/nJy+fJlHzO8e/du9+7dZDh6
9KhvhQwaNGjGjBkBFaL4zpEnCyGEzQhSnjxmzJhEiRJlyZLl4cOHgR1LQLF1
69aqVatu3LjRUwX+9NNPBQoU+Pjxo6cKtCu3b98uWrQosz1dunR37951S337
9m2/fv1ChgwZMWLEGjVq+FbIgwcPihUrNnPmzA8fPgRwvOL7Q54shBA2I0h5
8s2bN7NlyxY+fPh//vknsGPxmeXLl797987/+Xfs2DFr1izXIwMGDIgcOTKi
5ZF4/v77by8vr/Xr13ukNNvz66+/MttDhAgxduxYt6T9+/dzHE/+/fff379/
70chDGiMGDFu3LgRkJGK7xJ5shBC2Iwg5ckO593RoOzJRYoUWbp0qf/zjxw5
skqVKq5H3r59e+/evdevX399MBh7ixYtChcuTJlfX9p/AyVLlvyPE7c7xtev
X8+ZMyfHw4QJc+XKFb8LYfiyZs3avn37gIxUfJfIk4UQwmbIk/3Ppk2bIkSI
MG/ePH/mf/z4cYoUKdw82YMcPXo0evToGzZsCKDybQZ+W6hQoQQJEnj35NGj
R6dKlYrj/Hvnzp1PFtWpU6cYMWJcuHAhwIIV3yXyZCGEsBke9OTLly+fOHHC
j32b9+/fR+2eP3/uY+qZM2dI8tGTSeLER48euZ3y4MGDN2/evHz5ktTjx4+b
HREcOXbsGEc+eWPw2rVrd+/epdhLly65Hr948aJrgQb0qVixYvTV4MGDXZPe
v39Pq8l//vx510Jev37ds2fPkCFDFi1alFSc2Rx/9uwZb4ncyvn27VsKPOrk
6dOnroVcvXrV1HXu3DlST5486dq93bt3x9bOnj3rdzOtCF+8eEGBpqJXr175
fZZ/QBQpij58+PAhLz4ZiX8wETKCdCDjwutbt259fbGwbt26jBkzMijBgwd3
9WSO16lTp3bt2gxut27d/FPU4cOHo0WLRq96JDBhG+TJQghhMz7Lk/GWli1b
NnHSrl07/jXfR0Np+vTpkyxZsoQJEzZs2ND1PtuePXtM/p9//rlChQrYRZky
ZVwfzoDFTZs2rVWrVilTpkSSf/jhB1dPxk6pMXny5HHjxi1VqtTChQvNF9bu
3bvXtm3bPHnyVKtWrUGDBqRGjRoV1Vm8eDF1eXl5cYSzDh486FtbJk6cSF3Z
s2cvWbJk4sSJe/XqZUresWNH2rRpOT1+/PjEc+rUKZMfc4sTJw59RUWNGzdG
zs1xgg8bNmysWLFSp07dsWPHJ0+emOOIcfny5YMFC5Y1a9YZM2ZYKt6pUycO
TpkyxbzFgQcNGkSZdEuWLFk4Zc2aNSaJPOnSpQsdOjTV0XV58+YNFy7cnDlz
rCbgyfS230NG944dOzZBggRUUa5cuRQpUkSIEAFR9OORDv4Bn6fHiDankxIl
SoQKFSp69Oj03tcUe+TIEbqLfmZ9Ubly5TRp0tBXdAsrrK8p1rBo0SImzO3b
tyNFimR5MiVXqVLl9OnTTIPIkSP/9ddf/imKxQ6zvW/fvl8flbAT8mQhhLAZ
n+XJHz58GDp0KOqCxsyfPx9VQA6R5OPHj6OazZo1Q2vLli2L6ly7ds2cgqnG
ixePKnAq5PbAgQO4NDnNV6VQU2wQv5o7dy7ucfbsWRzV8uS7d+8WKVIkV65c
V65cIXXChAnkpF5z4uzZsxFUXPfEiROkLl26NGLEiJgkqszbR48ekZQ/f37f
2oLMUxd2N2nSpPbt22PjlInAE96GDRso4eHDh7Vq1cqQIcO5c+dM2zFw2j5r
1izX/cCtW7fOnTv31atXz5w5g9ZWrVr1xYsXJolWoF5u+y5Wr15Nb0yePNm8
HT58eIwYMThIN3IiV1jaaL6Xh4qzCiBCuujVq1d0aebMmQsWLGhuTWOqxYoV
a9Sokd9DhsazfMAG6WHqxfxpbJgwYdB+K88XPCtjzJgxxEaEDEqIECHq1atH
P6D0rs9MY4g/96EQRYsWZSFAtBUrVkTmaThzKV++fNbzTyjwyzZj00bWRCtX
rmSK4skEb46zviNmQi1evDh+zrj7p7Q3b95g2ixtviASYWPkyUIIYTM+d98F
NogXpUqV6ubNm7du3bKedcxbrAmHad68OQVu3brVOgVxxUysZzIUKlQIFzV/
99+zZw9WPHDgQEvVXPdd1K9fP1q0aNbTbpGZNm3aUNTJkycdzk0XpFaqVMmk
UjtCnidPHnOnl8wpU6bMmTOnH22pW7duhAgRiJxgOAv/TJo0aYkSJawv2WFN
qC+eZnwPFcdU3faNEAYWR8B//PEHOSnQ2ieA70WJEsXNkzdu3Gh5MmelSZOm
XLly1i4OmoYfcsTUguIi/7dv3zap9C3abG7XY+bo7ic9GS007scoUO+CBQuI
li61bJOeHzJkyPTp0/0ux421a9cyE3iBebI2GT16NH1IsaauGzdu0Bu4bqtW
rfbv3+//YgmDhrNeYP1VoEAByqQPLUlmtjRo0IDVGZZu9Yk/oZmY8NGjR40n
M0yHDh1i6UFXP3nyZPv27bTC/57MIiVWrFjyZOGGPFkIIWzGl3kyvup2/Nix
Y02bNs2bNy+q6ebJW7ZsQXusW4uunkwSmcePH29ldvXk8uXLx4gRw3Vbcq9e
vYIFC4bhOHzx5KJFi5q3VIcXfdKTEX7rb/oUGDVq1MqVK7vmyZIlS9q0aS1P
5vW9e/dcMxw/fpxK8ziJGTPmZ3kyBfLa3CE3GE+2ZPjrPdnAqqFIkSLp06d3
C37JkiVUETZs2Ny5c/unHO/UrFkT7XT77tvw4cPxz127dtWpUwf5vHjx4meV
iaxyVqlSpVwP0s90L+K9c+dOVLlChQqfdRscn69atarDudGF2Uu3T5kypWfP
nuYPH5MmTeJInz59/HkDXJ4sfESeLIQQNsMjnoyERI8eHQ1D/EaMGBEUPNnh
vDn5SU8eNGiQ9dY/nmy09s2bN0Zub9y4kTJlSsJYsWKFw6m1bp5Mt0ybNo3X
5Dc3jb178oQJE6zqjCfTajTY4TlPpurkyZMbGUYvXbuUGpHSL/Pkc+fOJUqU
qEGDBq6PuaOuggULHjhwgNddunRhvFz3ePiHWbNmWTuxrfvJBw8ezJYt26lT
p4g/Q4YMGTNm/CxPnjp1aunSpc3roUOH0u2sDoYMGfLRCQVyxP8/tCdPFj4i
TxZCCJvx9Z6MoCJLFLJs2TLejh07ltfr169fs2aN2am7bt063zx5x44dIUOG
HDVqlFWaqydXq1YNX1q4cKFJevz4cf78+UOHDm2+g+a3J79//z5NmjSf9GTX
r2LhY7Fjx06RIoX1nTtkjyOdO3c2b43Wzps3b9WqVa1atXI4b5zigaY3aGD1
6tXx5GvXrpHB8e/9ZA6SRCFGJl09+fz58wSZNGlS68/9LAHoXvTSvPXDk/2z
PxmPpah9+/Zt27aNJcDAgQM5iNK7Pvv37du3lkJbMDqsfdwevmHx/PlzFix4
LKshmo92Opz3e631jrWNhNoZL7NPxrTdj1+yQ6fJf/jw4Xbt2rFY4C0G26RJ
kz59+rgWyyIlXbp0OXLkMJ7MQI8ZM8bv3R30PHNp3Lhx5q3x5MKFC5sSTIFe
Xl40wY9CXDGe7LakEkKeLIQQNuPLPLl169bWEQQ1fvz4FIJZISSYm5GQevXq
jRw5kgwFCxbEk63fODOebHYRI2m//PJL3Lhxzf3ne/fuIWx4svmxMzQPgSle
vLh5iAQeThKSY4rCQvHkihUrmmJxcjy5SJEi5q21P9m4EG4543+CFOXKlQsN
tiyUnFSB2WK/DqckN27cmDKtR0OQStM6dOjQtWtX86CJfv36YXQlS5YkQtQX
qw8TJgyqb+404pM0NmvWrGvXrjVfeHT868nNmjUzO4QpnDjNAzRYHeTNm5f2
WrsjatWqRYGrV6/m9aNHjyjN8mSH83kXrt9x846pq0GDBpSD0LIeoZ8rVKjg
egfbR082N8ZxSx/36969ezdy5MjZs2fPkiUL5depU+fIkSNI+549e1yzcS6r
GOaANV64aNiwYV1rd8XsoK5ZsyZDQLT9+/cfNGhQlSpVXJ+hB3Pnzk2SJIlV
F7OOPmGt4dsTPAhj0qRJlGndLh42bBgV/fnnn6b5rBpYrDEn/f9cO9Z3FOj6
2BYhHPJkIYSwHZ/lySgZ3oLDxIwZM1OmTOYmHnrJ6VgTrpI5c2Y0D31CaMuX
L4/urlq1ythj/vz5jUxGjBgRscmRIwe65XDezcOI8D0KxLiQaqQFPT59+rTD
qcqYMKpJaoECBUaPHm1uKl6+fDljxowYO7rC6Y8fPzaPhqBwJJaQ/vrrLyya
MFB6PG3Tpk0l/ydUQcOxXAJ2fVwztla5cuUuXbrg+WRzfVAY8dNd5cqVYy1g
7pGivqhyqVKl2rVrh25t3769bNmyrmeh1rxFqq1NyAMGDOAIIr18+XJzBMGj
r9DvFi1a1K9f39ovPXHiRKSRzFjrzZs3ectr6rK+czd16lS0E0f1bbxQxLZt
23LWwIED0UvaRYFjx451/V1mHz2ZxQsrHXrPx63F9DZFUSy2T0eVLl2aBu7a
tcstD3JOqlUXRxhKJkOePHl8jJYMFMhZOHDVqlUpH8N3k+Rjx44xXrt377aO
oKzkjBMnjlndeAc9ptPIwwwxjy65devW4MGDWVgxn5ktZsiAEWQ2+taZrnTq
1ImZo+cnCzfkyUIIYTM+y5ORlrUuuDqMSdq4cSMee+fOHV6jdg7nIx1MZpJQ
MqzGvN2wYYPrptYrV65wEG/hIEnr1q2zHkQM+KdVoOH58+fkMUWZG6ookHlr
9NvHs1zZu3evyf+5u2eDDnSCl5fXV/4eH9KYMGFC7/uT7927x2roc7+CZ2Ds
cPvo0aMvWLAAM7eeWML6hWXCF/9AISuCFClSoNBLly5t2bKlaxIrrJkzZ35Z
sZ8L05h1AasDfz4cQ/z3IE8WQgibEdR+t1r4H5YkLVq0KFy48Jc9UtjhvOHM
6UyAOHHiuG3xnTp1avny5X3bouw3ZgeFuV0fLlw467da3r9/36BBg3379n1B
mVevXk2bNi1lBnOC2Fvf40PmK1as+MWd8LmwsIoSJQorrG9TnfiOkCcLIYTN
kCd/1/z9998JEiSwnk39uTx//rxHjx4dnRw+fNg6/uDBg5IlS6K7X1bs0aNH
O/7L3LlzrS/uoeLNmjX73B8fMXDW9OnTrWJdd5sMGzbsW07gunXrli5d2ref
Xxf/zciThRDCZsiTv3e2bNlSqlQp6xkdHuHt27eXL1/+gt/p85vHjx9/7u+D
+IcbN258M2udNWtWjRo13HZNC2GQJwshhM2QJ9uAkydPBoR/Cu8cPXrU+qKl
EG7Ik4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbI
k4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQ
wmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPI
k4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4UQwiPIk4UQwmbIk4Xh
48ePjx8/fvTo0YcPHwI7ls/j2bNnT548CewoPIYZiBcvXgR2IAHF+/fvmWa0
0bekN2/efPuoPII8WQghbIY8WRiuX78eL1686NGjT506NbBj+f/cu3dvwoQJ
EydOnDRpEi/Gjx/Pv5Oc8OLkyZMoPVM3U6ZMWbJkefv2bWDH6wEePHgwbNiw
uHHjNmnSJLBj+Wx27dqF5H8y24gRI5hmyZIle/jwoevx8+fPd+7cmaQpU6YE
WIwBizxZCCFshjxZGN69e9e0aVMmQ8mSJQM7lv9P/fr1cWC06vTp05gwsfHv
/v37eZsvX7706dM/f/586dKl0aJFQ7rs4cmvX7+uXLly8ODB+/fvH9ixfB7b
tm2LESPG8uXLP5lz0aJFDGWuXLmePXvmevzJkyeMKUljxowJsDADFnmyEELY
DHmysOjWrVvQ8eSnT58WLVp02bJl5m2ePHmIbfjw4eZtqVKlevTo8eHDh+3b
t0eJEmXw4MH+uZP5XdCoUaMwYcJcvXo1sAP5PHbs2FG+fPlbt259MidD5psM
58iRI0GCBFeuXAmAAL8F8mQhhLAZ8mRhEaQ8ecOGDfny5bPsF0+OFSvW0aNH
zdsaNWpMnz6dF3/88QcxL1q0KNAC9Sjv3r2rWbNm9OjRb9y4EdixBBSrVq2K
GzfuyZMn3Y6/evUqU6ZM2bNnf//+faAE9vXIk4UQwmbIk4MOOOHr16/98zW6
t2/fvnZivXb76tPrf/H+lajXLrjV5d2TyRBY+xnOnTtnqdTp06cTJUrkurni
2rVrBw8e5MW8efOCBw++ZMkSmoNkupbgGjz94NYQ3nrvHAyNcvxuMrUYkXvj
xC3VHPnoxLUu09V+9KdJOnbsWKhQoTp16uSW5ON4WT5p5oB5a2bRJ1WTbFYk
3qMyhZhyXJOsbjQdZbXRt0lrjrv1BsufFClSPH/+3G28Fi5cyFCy8HErxPvI
ujU56CBPFkIImxGUPXnHjh3z589Hh27cuMGLFStWfP2jGLjQ41SU9ueff+7Z
s4cXCxYsePTo0VcWayIEPGf58uW8WLt27ecWMnbsWGywa9eu3q3AjYEDB5Lz
hx9+mDJlyo8//sjrNGnS0ByTumbNGpQykZMcOXIsXbrUKtA1Cdq3b3/48GGr
WDdPxm244mM1gb4HwNw0rly5spsX0a4sWbIkTpx42LBhSZMmrVatmvUUBYKn
l/Lnz89YzJo1K23atMWLFze7AkhatWoVSZkzZ8bNzHID9u3b17x5c7qlQIEC
169f9zGSe/fulS1btkWLFvg5fUvnL1u2zERF0vjx41OnTj1t2rS+ffsye80p
KD192LNnTyJp164dYaxfv96t2EOHDpFUokSJwYMHhwsXbs6cOa5tZEqY8frl
l1+sHti5c2fjxo2nT5/OIqJo0aKkNmrU6MWLF5MnT+Z1y5YtDxw44EeXjhgx
IleuXATPJ6J///4FCxZ0vYPN/xDMwoQOqV69ujnIyiV79uy5c+emIU2bNiUD
HWsF/9tvv925c8cq4e7du8zntm3bkrl37970jJWUM2fOkCFDJkyYsEaNGlYv
mUoZZdcdzg8fPqQ5yZMnr1ChguuX/v7555/ChQsTQMOGDa1pHxSQJwshhM0I
mp7MBbdJkyZcHLkoJ0iQgH/RodChQ5s/tX8xL1++7NChQ48ePYYOHRoxYsR0
6dLVrl07WLBgmPPXFIsIlS9fHt/Gc+LFi1epUqWUKVMiZp9r9WgbYxEzZsxP
PuXs+fPn1PUfJ1mzZo0ePTovOnbs6HD+UTtGjBjY2qZNm9AtknCSkSNHmhNr
1apFzrhx42IjdevW5TVHLFF08+S3b9+iKByhaZ/XI55myJAhPm6uIEL0OHLk
yFOnTt2yZQuNbdasmUliSmPCJIUNG5bTGXRK2LBhA6cMGDCASYV7Y4n0FUZH
ftZNsWPHTpIkCRLL6gPx9jES/BA9Zs4w0Czc8GQ6k+FAkkuXLo0Pb9261Xzl
kALJf+XKlTJlyhAGR5gSmzdvxmlZ4Ny+fdsq86+//kL1WbMg6jikKdAkvXr1
imFFCFeuXDl37lw+AuPGjeP4kSNHMmbMyLqAYpk2JLEuCx8+PK/r169POQwr
85AJ72MrWDrRUTTEy8uLRSKSTDkcNKlMG1qH2bLQCBMmDKkO58P3mGmtW7cm
J2HQn2h2pEiR6C4+RDVr1qT3aJ0pgS5lFhH27t27u3TpwilVq1Y1SXQLHz3K
xG9JypMnj1namHVNlChR8H+T88GDBzSBDuEIJl+vXj1zHEmmn+lts65hBFkp
+G8eBTjyZCGEsBlB05O5UteoUcPhvFZGixaNy+Xx48dTpEgxYcKErymW62m7
du3evXuHINFqrvUHDx7k6r9w4UIrz9WrVz9ra+iLFy+4gq9Zs4bXderUwSsQ
1MmTJ5cqVcryZK7sFy5cuHTpkt9/JuYsDKpXr16fvJ8MyAlNKFKkCFLNmiJT
pkz79+/Hr7Jnz85xjNfUjqTxFm02YoYo8rp79+4O59epggcPjvNcvHjRlOn9
fjL50afA3StrZBjdXbdunVsS4xghQgTzGLGnT5+iauiTSZo9e/aZM2cYXGyQ
/rx8+TK9xPqLJQMLB7qFEcFpmVTMscOHD8eJEwd/w+LoQwa0X79+Pn4xEOX+
+++/GWXTh6g7Ckf5zEwiNDeKicfy5FOnTlEUSon9Eo/DObc53VqaYcJ0OA00
90uLFy/u6sl9+vQhKnPTFTfGz1u0aMEsYqxpCJOZI2b23rp1i65AIE05rAf5
4NBG702gxkaNGh09ehRHTZ8+PW8ZX/rBeDJNwH5Hjx7Na+YMwlylShXTvSwK
OE7T8FtiYEXGYg0TpocHDRrEccuTx44dGy5cuFGjRvGanvGexGfELYkwEiZM
WKhQIZONzq9evTqpFMJMHjNmjGXaCLy1aKIEsn3934M8hTxZCCFsRtD0ZITW
/Il87ty54cOHN7eRsRGjLlyjUbuOHTtaD0PwJygEvu1w+pXVastdSe3du3fy
5Mkxyb59+/r/hx4srcWTo0ePbv76bIrlEo9CpE2bNmbMmHjLxIkT/b7JbLXx
kxhPRnhMXSYG2oU4cRxna9asGbKEgPEWg0IUHc476jdv3mSBQJK5V+yHJwcR
cKooUaIgdd57ZsCAAaFChUJcHc5tD7FixapcubJJIjMqZWmkwzkWtN08eYwC
GRGcE+EkCQPnIDMNzZ41a1anTp3Onz/vYzAUwgoucuTI1g1hKtq4cSODmzdv
XrOtt2LFimnSpLE2q3AKnkxvm8HNmDEjixprGtA6VisjRoxwOKU6UaJE+LwZ
TRZWrJuQf0ze8a8nU5FZtty9e5c1Ed1iUqdNm4Z/mil9//59kpo3b+5bl1I+
KztKmzFjhnmLA+O9yGqFChXoCuOxLArIY21sIBtdGiJEiPnz55uGm0n+7Nmz
cuXKpUuXzmxWwajN3hUzXoguCxMWZQ6nDCdJksQ1yfLkx48fx48fn9WlqWvn
zp18lKgLeWbliJ8zdiaJRQ194uXl1b59e5Yb/llUfjPkyUIIYTOCpidbtGzZ
EhE6d+6c60G8DgfgCt62bdsvKJNrNELIpXbfvn2ux7EjisUx/vzzTy7Q5m6Y
/8FbcubMyTXdVee4iKdMmXL16tUU265dO/TViPrX4+rJFkuXLjWbMdCe5i7M
mTMHMUPgixQpEiNGDFpXrVq16tWr04dB35OHDRtm7SpxBTGOEycOUmpMiTUO
PrZ3714rA4bMiYsXL7aOHDt2jCaHCRPm0KFDjIj1LTzjyWPGjME5cTm/b/tX
rVoVzaZ264jZFmK+fIcloutlypSxUuleViusoT44YdGUJUsWK7Vo0aKca+7f
4q68njlzpkn666+/eDtw4EAzo/BDgkcOzdsLFy7w0bBkuGHDhswuI+dIPkl8
dvxoBROVlcLu3bsdzmmTP3/+t2/fIqscxHLNrW+WeNRoliEOp/DnyJEDz7c2
6hgePXrEpEKwzVs+OJi/2a3x5MkTRJcZZcbI3DQ2SdTFa8rfsmWLw7lfmrO2
bdtmCjG3mlnrMUwMiutnitd9+vRhFMjPguVzF8sBijxZCCFsRlD25OfPn5cr
V+6nn37y/oiA06dPI3tf5slYUIoUKXBah/PSf/bsWXN8/PjxkydPdji/z8Xl
G0n4rGJdz+Libna9OpzS8vLlSwyhVq1aCRIksKTUO5y1du3aa9eu+ac6Hz0Z
ScuWLRvHMTfvp+zZs4cI6bfu3bujOidOnPB730VQAJVFlojKGJ0raH+kSJHM
/hx6GPNH8Pbv3083OpwrlFy5cmGk9Il1yuXLl3GzJk2auM0o48nm5qrDKX6u
+4ddQbBxMzrK1aWNJ5v7rsaTO3ToYFTT8a+um40Wf/zxB5bOsoVZZ24pEyRh
m79BjBw5ksJZVZn9EsaTrfUaHwTOtbbokw0xNjvPqbRYsWJp0qQxs65Fixb0
zMmTJ60Y3HDVdbSzb9++Zl+38WQ+dA7nui9JkiQI/z///GPCM2dlzZrVrTRM
nlmE4lp2TdiWDKPQ5cuXR7Ypx9WTOUKQhQoVMn+4GTBgAGdZXwZ0261hcerU
KQaL/zNQ1NatW+mBunXr+tjGQEGeLIQQNiMIejJqhAR27drVVYbPnTvXuXNn
62+sPnoyenP06FHLe93g2tquXbupU6fevHkTMzGejDhRrFvO5cuXc923fr55
7969VapU8c1vCaxy5coHDhz4+eefo0aNar6FhLyZHcsG1Ld58+YhQ4Zs2LCh
Hw3nLPM7ZZ/c8oEWli5d2rsnW4WkT5+eSHAJfBjDnD17tuNfTw4fPvyRI0ee
PXuGueHJoUKFsr45ZTw5T5481g+l4XVNmzYNxP2fRoZ99GTsFE0y24AvXbrE
kDEEuG6bNm0c/+5qzps3r9tZSDKrJDSYTka0WrZsycRw9WTUDuV2vQvtCn1F
TrNNwoITqX3p0qVU2q9fP6Kiq/lkmVSzp9d4MgsxXk+aNInljNmEzOT54Ycf
mNjoffLkyTNnzoyKmx/jc/Vk5iTC2bNnT2vDBnMySpQoZlFgbjX36NHDNWnm
zJlmEeEdV0++fv06gm3+zMG4M3OMJ2O/fMRKlSpFaeae7apVqyJEiFC2bFm3
0vhYMZHQY1ydt3wAWSkgw3yQ+/Tpg9sPHToUHzb7Oownk1SnTh2ybdiwweFc
IaZLl454SDXPu2BxwYlz5841c2DWrFlmRcBHnqiMkPOho+voJYfzgTN8IojW
tweVfBvkyUIIYTOCoCdzMU2dOnW8ePFQmjhx4mTMmHHRokW//PKL65eSfPTk
33//HVtImTKl2+/hGm7duoWE4DD58uVDaLlGcy0uXry4q9A6nA9r5TruKiRo
A13Uvn17H6PduHEj5pkkSRLEI1y4cNmzZ0e9Klas6Ha9JiTkP1WqVN5/XsEi
f/78VERRrrdAfaRv375mHzLKZz3LwnD37l2O0HtoeaVKlapXr265BEklSpRA
deiiChUq0BtjxoyJGTMmPnn+/HlcJWvWrGbbhtFv5M08gsP1e47fDFRq8ODB
dBomTwyMgtuDzhiR6NGjm9vvV69eTZAgAdMGizPbdwmepdDEiRPdil2/fj3t
rVWrFoLKkLFkcDgti85nMjRu3Bi3xHV9+0k4PDlZsmTWz51YoebIkQPHQ9Tp
eRyVOWZ+OhBzzpAhAx1rCpwzZw7jwihYiz5WYRRIvcQTN25cLy8vlNIsCvDD
okWLFi5cmOFgoNFg113TDRo0iB8/vvnW3okTJzjRWkqQhLfTIj8+17gc04CA
mauuj2JjScUnrlmzZr/++ist4lPGlDbbOUgiQtcnuRl69eoVOXJkPlBG6fng
8PGxeoNTIkaMSN+6JtWsWZNWm13QDue6jzbyqaQbTV0fP35EvPm8UEiZMmUQ
YLPRhaUNBaLu9FiRIkWsbTbIOU2mLZ98VkyAIk8WQgibEQQ92eGUh27duh0+
fJiLI07Yu3dvt0c/+ejJBw8eNFpl/QHdDS70FLt06VJy8oJizd1IC9SlQ4cO
JKGU5hteMGvWrDZt2nDQxzJfvHhBhKSeOnUKC+LFvHnzUH2TitotWbLE7K5E
RM1+Wt9ajUJzunFav2HJ0O1ffHxW3qNHj/AcUkeMGGE9PMHhXAWsWLGC41Om
TDEPDdu8eTNvsThOwWFMmdbf+uko/DNQngt38eJFKx6D29ZuFHHdunWmb/mX
tzTZddcKDfTxW5OoFAY+fvx418emMWTz58+nRpzZj+9a0lHm903coKixY8ea
R45gktOmTbMK4aC1xEOb8edjx45ZfxkhG0sqzJwpx7mTJ092vXPOeDFdu3fv
fvnyZbeobt68ae3mpfmrV6+2NpOYr2qyuvTjO6Hv378nqgEDBrj9sYDA+Nwx
ASiNjkJWreBJIkLvncMygSbTM1YShbMEo6PIzwqRKWd1tUkaOnSo22KW6vjU
u/7VhpysCwYOHEiErjuit2/fbuaD6150/kfRv39/6+nZgYU8WQghbEbQ9ORP
4tv+ZK6nzZs3/7LLJVfqjh07otl4b7ly5VwvdggJBvUFZeIb4cOHN9+EGjJk
SMiQIc23lr4j8uXLF+jPTxbiu0CeLIQQNuM79eTWrVsHCxbMy8vL7Tbv4sWL
69Sp489Hq7kxb968MGHCmI0HvDB7eh3OW4U1atRw297gT27evDllyhTUvUuX
Lj/99NOGDRv8/7i5oMCDBw/oT9dnOwghfEOeLIQQNuM79eRdu3YtcuL29a7y
5ct7/468P3n79u2KFStMsWvWrLH+iHzhwgV//vaH/Vi3bp1vm1iEEG7Ik4UQ
wmZ8p57sG/7/nY7PIiDK/C74r224EF+APFkIIWyGzTxZCCECC3myEELYDHmy
EEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELY
DHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmy
EELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4
BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYjKDvyXfu3Dl//rwfGU6f
Pv3333/fvHnzm4UU0NCWKlWq1KtX78GDB4EdS2Dy8uXL/fv3/+0L9+7dI8/R
o0fr169fq1atd+/eBXa8fvHmzRvaMnbs2K5duwZ2LCKgkCcLIYTNCOKevGLF
iuLFiydMmLBbt24vXrxwS33y5En79u3jxIkTM2ZMDCRQIvQnGO/Tp0/9mXn0
6NH/cbJgwYLPquXWrVu7d+/+6aefGNDr168HcXX8JD169AgZMmSSJEnGjRuX
MmXKYMGCxY0bt2nTps2bNw8XLlzJkiURafLQUcmSJXv79m1gx+sXz58/r1On
TogQIcqUKWMdZLzcwh4yZEirVq1ev379zQP0LyxPvH8SfYRp3KxZMxoe0CEF
HeTJQghhM4K4J2N6I0aMIMLgwYN7l8bffvsNdyJpzpw579+/D5QI/UmDBg2G
Dx/uz8x79uyJHz9+ihQpTp486f8qtmzZ4uXlhUCGDx8+nBOk68OHD18Ub+BD
5Jhw/fr1WQ3xNk+ePEyDwYMHv3fC6ilBggQ42B9//MHxVKlSBXFPhtu3b8eI
EaNixYrm7Zs3bwj7119/dc0zatSopEmT+lNEvz0MSqlSpfz5v4uaTl69ehXQ
UQUd5MlCCGEzgrgn4xJNmjQxN1fnzp3rmrRt27a4ceNyPHPmzC9fvgysCP3D
/fv3c+fO/VlXzzt37ph9Bf7kwYMHeCO9kTVr1hs3brRs2ZLXYcKEQZ4/P94g
AeObJUsW624knhwxYsTVq1ebt9jayJEjeWE8efr06YEWqL/p27dvyJAhWQSZ
t0eOHIkZM2a7du1c87AwRKcDIzp/sWnTJibV7Nmz/ZP54cOH/1U3kx3yZCGE
sB1B3JPRv2jRonn35BcvXlSrVi1p0qQcz5kzZyBG+EnQ3QkTJgQLFqx58+YB
d8+TWqJEiUJv1K1bl7fdunUznbZ27doAqjGg2b9//7Jly8zru3fvpkuXznVz
BQ00TTOevGjRokAL1N907NgxePDg1t8IBg8eTOR79+4N3Kg+i99++42Y/enJ
/4XIk4UQwmYEcU8+e/ZsrVq1MmXKRJCjR4+2ju/YsaN9+/ZmS8bEiRP9LuT+
/fvz5s3zj5B8+PABm61QoUL9+vXxGbqlgpNZs2ahas+fP9+4caM58uuvv755
88Y68fLly+3atbOSCNv86ZwCOWKUNUSIECVKlOjdu7cVVaNGjUhduHAhTeNF
p06drly5QtLKlSt527p1a7OlefPmzRX+pXLlyrdu3eLg8OHDzZFx48bxFoFc
vXo1wbOyePfuXbNmzcyddsI21T179oyo+Pdzuj+oYGS4f//+Hz9+dD3+/v37
MmXKkNSnT5/atWsfOnTIdVDg1atXtJp5MnDgwBs3bvhWPoPVuXPnBQsW3L59
u0GDBm3btr106ZKVRAkHDhxgmrnu93706FHTpk3pf5Zv1p3/48ePM10vXrxo
3lLauXPnzFm8TpkyZalSpRgCgmSSpEmThsjz589v7jBT4KhRo8wEMGzfvp0Z
wgieP3+euhhfswXFgt6wkrxHaEHVU6dOPXXq1NWrV3v27FmjRg1ax2TeunUr
8Y8ZM8btLCsJK2Zy7tq1y/RDnTp1IkWKRMwFCxY0X5t9+fIlMdM/9MDPP//c
okULEyHljxw5kg+FVSafPlMXmVu1atW4cWNbfkdVniyEEDYjiHsyl1SkZdmy
ZQSZKFEis9eRS23RokWxi5IlS3IcnfC7kF9++SV48OCcfuLECb9zIh74ktHa
iBEjFitWDAvNkSMHp2fJkqVSpUpdu3bFuLAFjvTt29echWakSpUqWLBg0aJF
Gzp0qJeXF0q8ePFiUyAe9cMPP1BglChRBg8evGLFCnPW4cOHEydObLZehw8f
nn8pIUOGDJyC78WKFYu3Zkv26dOnTRhkDhUq1IULF/DDKlWqRI0adciQIZYJ
m+rQIUwvZMiQnG6tIIz/ExXa8wWjEOjMnj3bx5vGrA6SJk1KY1u2bIkM0yED
BgxwTe3QoQPdXsdJ2bJlfSz89evXnB46dOgIESIULlwY0aWTU6RIwekoInaX
OnVqerJq1aponjkFpy1fvjwjwrjkyZMnV65cDx8+ZHYxLXHIjBkzspb5559/
0qdPj8abtQnyTBUs7hzOJRIzIUyYMNmyZaMEkpjY6Gu1atXixIljFnQ7d+5k
UnEKhSdMmJCoyM+gWwsBxpTlW4wYMVgj9OjRg8Fl+nlfCyDq2bNnZ3ZRGg3h
A0VILDwpinXZoEGDaLVZahmIBIllZiJ79CcnYssO5w4oZDtu3LjYPvn37dtH
/9AhrMXChQtn9RtNYEKymkuSJAnVmW8N/P3333yU+ODQBOJkZjKarpXaBnmy
EELYjCDuyXgFnrl8+XKCxBaMJ+NCKNO9e/cQAzTJ76fGOVw8+fjx45+s0Tg5
9OrVy9wTPnDgABd3SkAquO7joggGGbj0m1OMJ5PHPJ0MpyIVObG+Q1egQAFz
z9PtdijdznGse/78+Ug4JTRt2tQUaNSa41ZmEwb8/vvv+AkiTahuBcLkyZON
tAMqbh3fvXt31qxZDx48+MkeCGrgY2nTpqU5ZunhCn2CKGKS5Hn69Gns2LFL
ly5tkugZFjUo9IwZM16+fDllyhTXB024wgTjrCJFitDhzDe0+ccff6xXr54x
Rg4uWbKEocRsGV9zCjOKgTBC26RJE/I/ePCgePHi48ePZ1agxzdv3jx69Cgx
d+vWzaqF6Xrt2jXzFpFmIVa7dm3z9smTJ0TLGopTsF+mGcWyOqDheD4rI4LB
wFmCWTt+sWtmTqNGjYiNgeZEFgXe5wPKysRjIUaGTZs20VErV67kbalSpZhm
hIEnW2HA9OnTaRo6TVG9e/em+SixSeLjgyevWrXKvF26dClNpnzsl+6l3woV
KsRqgqVi/fr1c+bMiVHTEMJjQbF69Wr6hHpZgHBK9OjRt27d+jmz4PtAniyE
EDYjKHvypUuXuNQ+evSIKzU6ZDz5+vXr+Cq2wNWfCzp6+clyMGp/7rtwuHgy
tZgjp06doqJQoUJZQo7toKmZMmW6c+eOFeqZM2e2bduGhLRr147TMRw3T/Z+
9cQ0OJ44cWIcA1OiBGNBPnrymzdv+vbtSxjYUbhw4ax7m95BSIYNG4a9sIiY
NGmSddz1zvN3BN0SJ04cJN/7phGaSS+ZW/RunmzOIjVDhgw4Jy69f/9+H8t/
/PjxjRs3SpYsyRwz2x6uXr1KXUi42fLNxEudOnX+/PmtrcVooeneESNGWE9y
5qwjR44wQM2aNeMtYxc2bFjrC4YIJKVZOzSwYlKpwrxFShkdPJOKiMc0Z+PG
jdSOkzORtm/fjtAi89Yj45o3b85MOH36tMO54KK0mTNnem8dnxe6gnPLli1r
lpmsBZjP5q8wbp5MqwmAfkPyqahhw4aunmwWgMi2eUuEfBCQ3qhRo5pNFNTF
NOY1XY0PV6xY0XwELl++zFLFeHKdOnV4bW1rsRnyZCGEsBlB2ZNxgMyZM5s9
uigEl28u7uXKleO6z5GWLVsGCxasVatWnq3UP5784sULLy8vLOWvv/4yRxYs
WIDDIFRZsmRJkiTJF3iy63EfPdkcb9u2rQnP7SlzBFmmTBkU3Zg2/5qHgaRP
n977PcbvCyPDNWrUcDtOb3To0IGJYfbEjh8/Hnddvny561nY7xYnZs74ATlR
cdcHp5i/GuTMmdOUYO06djgnQLFixcwYkcGyvh07dhBDv379eF2iRAmGwBoO
pgcKyqLP5GzUqBE5UWurzFWrVqGsrusaZhfljxo1itdr1qzhtWXCx44dY6WG
eN+/f5+3xYsXZ0L69jQ5bBxB7dy5s8O52sJU+SiZmF2THM6v6THP+Yg5nKst
Y+bmA8hk7tWrFzWyLrBKRqcJg1nnusOZ+WY63/oapqF///6s71hL+j0Q3zXy
ZCGEsBlB2ZP79u1r7bBFh8xW3tatWzucX+Ayu3DPnTvnn6Ju375tjOKTGE+O
ESPGoUOHzBHfPDlfvnzGb9evXx85cmTOwqwIbNasWX548u7du3v06GGOf64n
//PPP/nz50dyQocOnSBBAtdvQjVv3tz4s1F323iy9dd/+s0t6c6dOyxVjD/T
7czkiBEjHjlyxNw2N6rm/SwfQTvjxYs3Y8YM14OMJgsx7892uHDhgtmJcePG
jYEDB7purqhWrRoz4d69ewgkBaZMmZJgyGmMl6WNcc5r164xvhUqVGAikdnc
5p08eXLYsGE3b95suTprQMbabKqvV69eokSJrG9iIuQU2LBhQ7yXycOsSJUq
lW9PRyQbJZstH8xhZjJ95XBOM3rPJJm1Rvv27SnWeDIrCxS6du3aJsLHjx/z
oTB7vK1fzGHdSn6zgdmCeMwdeFTcqDv5qat69ep48vXr14nZ+kOMzZAnCyGE
zQiynowg1a9f39osYTy5WLFiRg4RhjBhwvjTkzdu3Bg7dmzE9ZM7mR3/enLU
qFGtrwd692SkAgvl4Lp16xwuP583b9483k6bNo3X1Gj9Vd3sfcUxkI0cOXJk
ypTJuKt5jAP+43Yn0PLkOXPmWAdv3bqVN2/e3LlzY8uoI0uGSpUqmb/RO5xO
ZWIw2z7XrFmDNJpHXpi60B6kjrZ8sgeCFHhm9OjRfTTehQsXInLmBuzly5d5
3ahRo9WrV5tlCMPHIOKTDqdF79+/H7n1rZZVq1ZRhZsnL1++3Ii3wzkiuK7Z
mos6Yoxm2XXw4MFo0aJZT3W2PHnlypUUOHLkyFq1al29etV4MtPAGDVlGrvG
zznI0KCOFFu8eHH03jz/ELvOmTMntknVWDfzLWPGjCQxiA7nt/yYfmTmNbXz
eurUqb61ztWTT58+zUxu06aNw3k3mNcs4uiln3/+mSOdO3cmMDyZOdO4cWM+
X+PGjatbty4fN+PJJLE6wHiNk/fp04fRMQ/EsDCejLpj/nwW+BTQxsWLF1MX
S0s+v5yFkJtpSR5a5J8vDnwXyJOFEMJmBFlP5gKdPHlyLtDmLRfWCBEiWKoz
f/58RNGfntyzZ0/jkNZXkPyAi7jJXKdOHXOjD/ulLlQE7UHbcNoGDRrwljzm
6Qpr1641z8tCVmfNmmWeYgGYhrkp/eeff6IfiD1HQocObXQaZU2VKtV/nM+L
YxRcf7bs5MmTZm8tPYBKXbp0iVPMSqFDhw4O51O2zDf1KlSoYMQYezG/WJc9
e/bx48ebh057eXlZto+ocKR79+7f0e3lbdu2TZw4Eccj8n79+llfgjOgdnSm
efgYXcRruqhEiRL0mMPpxpUrV0Y16TpMjxd+yBjeiFS7bQlgRFiXFSxYkBIo
CvG7cOECx/E6piKCx/Hy5ctbDzCxklD39OnTE3PNmjWpF202nowoTpgwweHc
yczIlilThn+NsqKdRYsWpaXWkGHatMio+7Nnz1KmTMnpMWPGNB9VvJrlQLx4
8dDjdOnSUTgTz7fW4cksl8wCk6VElChRzB6SK1euJEuWjOUbYTBFHc61GH2Y
JUuW4cOH0xAmGFVg7w7nLm48mSSabH2OaF2KFCncfgrTeDKzncA4iyabhaf5
M02zZs0SJEhglpCsBdKkSYNpm+WMDZAnCyGEzQiCnvzu3Tv8M3fu3MhGixYt
jECeOXNm5syZxvHatm1bsWJFBIZrOrryyQKRKC7uTZo0se6++gYXbpyqoJOS
JUvev3///Pnzpi5AgzGWO3fuYA7mSP369U1IuBk2whGSNm/eTH+aDCirw7kL
Ag8xDw1bvny5CePmzZtVqlQx2UqVKuW6iWLRokXmeKVKla5fv75u3TrzFrMy
6wIcm7abg506dTJn3b59e/r06eagCcNaZTic91cRpCRJkrg9YTjIQvCsAgq6
4OaxeC9CYppjvuRIn7g+JPDhw4d//PEHJw4bNsz1Wb7e2bdv39KlS70fZ6xx
XTOODIQ5SF0spkxIbmeR1Lt3b8LAcvHncuXKGSNl2jCIY8aMsZSSCVO6dOkN
GzZYz6+grho1alh7egmeWqz9zGZKYMXWZh50lLoKFCiA0LLg8uPXGwne2kG9
Z88eVqBWGEePHiUMJqcVBrOoevXqtWvX/vvvvwcPHkylRqGp9+DBgyRZO8Ad
zvvwZtHnCp+II0eOELxZsLC0nD17NtkokPFq166d+e6hYeHCha4Ffu/Ik4UQ
wmYEQU82cN337Qd8P/kYZOEjXL6zZ88ecL8JKL4ZSLsxW0w7cuTIWbJkCeyI
xP9DniyEEDYjyHqy8DiFCxf2/ghi8d1x6NCh+PHjz58//9WrV6NHjw4VKpTr
r6uIQESeLIQQNkOe/F/C5cuXa9eu7fZgDfE9cuDAgbhx4yZLlqx8+fJRokTp
3bu3jz9XLb498mQhhLAZ8uT/Ep4+fer3Hl3xHcFQnvqX72XD+X8D8mQhhLAZ
8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQh
hLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI
8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQh
hPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ8mQhhPAI8mQhhLAZ
n+vJr1+/fu7k48ePARTS48ePV65cGXDlCyFEQCBPFkIIm/G5ntywYcO4ceMm
SJDg4sWLARHPzZs3EydOHDFixBkzZgRE+UIIEUDIk4UQwmZ8ridv3bo1ePDg
IUOGPHv2bEDEc+/evdSpUxMSgQVE+UIIEUDIk4UQwmZ8riefOXMmRIgQAefJ
QMlr16598uRJAJUvhBABgTxZCCFsRhD0ZCGE+B6RJwshhM34Yk8+efLku3/5
8OGD95wctDJ4/1LeO58wZ+3cuXPdunXv3783OXkxc+bMefPmmYqOHz++ePFi
H8sUQohARJ4shBA248s8OViwYIkSJfrhX6pXr/7XX3+5Znv06FGNGjWsDAMG
DLh06ZKVumnTpjRp0vzgjX379qHEMWPGjBQpUr169UxmSo4WLVqYMGGyZcvW
uHHjOHHihAsXjsw9e/Y0ai2EEEEBebIQQtiML/bk2rVr73CyceNGzDZq1Ki7
du0yeZDkatWqhQ4dulevXmQYPXo0VWTNmvXZs2ek/vnnn7husmTJVq9ejRXj
wKTGjRv3xx9/PHTo0Js3bxo2bMiRokWLWpWOGjWKI1aBM2bMoLooUaIcP37c
4x0ihBBfhjxZCCFsxtfvT3716lW6dOkoBHM2eyF+//133np5eZ07d+7atWv7
9+9PkyYNljtt2jRSCxUqROqAAQPM6eXLl+dtmzZtrCqQYTdPXr58OUcSJkxI
XQ7nM5xJ5Ujbtm090QdCCOEB5MlCCGEzPPI9vlmzZlFI6tSpP3z48P79e6PN
wYIFC/svwYMH523Hjh3JXLx4cVL79u3rcO5GLlu2bLhw4VasWGGV9klPxr3T
pk0rTxZCBCnkyUIIYTM84slz58519eRUqVLxNnz48HXr1m3wL1R0+/ZtMm/e
vBlnjhEjxtixY/v06YNFo8QvXrywSvukJzv+vQstTxZCBB3kyUIIYTO+zJNh
zZo15sjr169z5sxpeTJHJkyYwNsECRJYWuvK/v378WRKyJcvHzJcq1atu3fv
umaQJwshvkfkyUIIYTM+15MvXboUI0YMTilSpMiVK1fevXs3evTosGHDhg8f
fvz48SbPli1beMvBMWPG3Lp1iyOHDx/+6aefnj9/7nDx5BIlSlSoUKFJkyan
T5++c+eOVYXx5Fy5cpn8MHXqVFdPPnbsWJw4ceTJQogghTxZCCFsxud6Mqxf
v75SpUqpUqVCXBs0aBA6dOioUaNOmDDBNc/y5csLFy6MLadJk6ZVq1aZMmVq
2rTpmzdvHP968n9cwJmzZs2KdZP6xx9/ZM+e3WxvbtOmzcePH3fv3h0zZkyO
RIwYcfXq1eRp3bq1OTFjxoxz5871aH8IIcQXIk8WQgib8QWe7HA+4+Lp06cj
R45EZTt27Hj16lXvPzXy4sWLJUuWtHGyd+9eI8kwevToSJEitWjRos2/YNHm
QXOk3rx5s0OHDuY4Rm3q6tevnzmyYcMGjgwdOtS8bdeuHVV7oBeEEOKrkScL
IYTN+DJP/hoKFSrkutMYzp07Fzly5EqVKn2zGIQQwuPIk4UQwmYEiieHCRNm
yJAh5tf0Lly40LVr11ChQrVu3fqbxSCEEB5HniyEEDbj23vyjBkz4sePHy1a
tKpVq9arVy9hwoRRo0atWbPm06dPv1kMQgjhceTJQghhM769J3/8+PHly5fr
16/v/S87d+58+/btNwtACCECAnmyEELYjG/vyUIIYUvkyUIIYTPkyUII4RHk
yUIIYTPkyUII4RHkyUIIYTPkyUII4RHkyUIIYTPkyUII4RHkyUIIYTPkyUII
4RHkyUIIYTPkyUII4RHkyUIIYTPkyUII4RHkyUIIYTPkyUII4RHkyUIIYTPk
yUII4RHkyUIIYTPkyUII4RHkyUIIYTPkyUII4RHkyUIIYTPkyUII4RHkyUII
YTPkyUII4RHkyUIIYTPkyUII4RHkyUIIYTOCviffv3//2LFjL168COxAvg9e
vnx5zBu3bt36gqLu3bvHuVz0Hz9+7PE4/3s4c+ZM06ZNFy9eHLhhzJ8/v2TJ
krt27QqU2i9dutSzZ8/y5cszqQIlgG+DPFkIIWxGUPbk9+/fT506tWjRotGi
RWvWrNmrV68CtK7Lly936dKlY8eOffv2/X6v5gcPHgwfPnywYMH4N66T2LFj
Z8yYcdSoUe/evTN56Mlffvll9+7dfhd15MgRzmV6LFy4MOAD9xcslz5+/OjP
zK9fv3748KHrETqhQ4cOHA+A0Hzmw4cPnTt3pg+TJ09u9f/XQ7vevHnjdx7m
MLPavCZzunTpCGPp0qWeiuGzmDx5MnMyXLhw169fD5QAvg3yZCGEsBlB2ZOn
TJkSI0aMuXPnzp8/P0SIEAFqa1zHq1SpsmTJkv3799evXz9BggQ7duwIuOoC
DsSsatWqjGnDhg2fOblz506pUqVChgy5c+dOk+fw4cMJEybs1KmT30W9ffsW
u4sXLx7CHPCBf5onT55UrFhx2bJl/slMP7Rr16548eKuBwcPHkzD6ZOACdBn
mLcMR+PGjQnJIwWyUihcuHDXrl39WDI8ffo0adKkzGrryPTp0zHV5cuXeySG
z+XQoUPUnj9/fnv/bUKeLIQQNiPIevLdu3ezZcs2aNAgZICLO0EizAFa18SJ
E83bffv2cU2PHz8+hhlANQYcDx48yJs3b/jw4U+fPm0dHDlyJB1YtmxZ68g/
//zz8uVLv4synpw7d+6AivUzWbFiRdiwYceMGeOfzASPKNIVbgevXbvm/zvS
HsF4MkswTxW4evXqMGHC4L1+5NmzZ0/kyJF79Ohh3r558yZTpkw5c+YMrP1L
xpN79eoVKLV/M+TJQghhM4KsJ1epUiVcuHDmz8QB7cmbNm2i/CxZsjx//py3
z549K168eIQIEW7evBlANQYce/fuRUgiRox4+/Zt66Dx5Fq1an1WUVevXmWx
8LlnBRzVq1ePFCkSixr/ZGZKI9Xz5s0L6Kj8BicfOnSoBz2ZAocMGfLJHRQd
OnQIESLEqVOnzNvXr18nSpSoQIECHonhC2jSpEno0KEnTZoUWAF8G+TJQghh
M4KmJ2Oq6dOnT5MmjflT9cyZMz/pyY8ePfriTcV37twpXbo0nvz06VOH8+Zb
hQoVXD35wYMHl33C9ZbsrVu3OPL48WNk26T6/fd9Ap4wYYLH98quXbsWT65f
v75VMrr7448/0pz9+/c7nFtbie3t27euZ9Fkq1FWkrHrnTt3vn///uzZs0iO
21lu0I1WIX5/c5ACr1y5QrYnT57s2bNn0aJF1kZik8QRjls70l+8eNGlS5eE
CROGDBmycuXK165ds4q6fv063WgqvX//vsN503j48OGZMmUi+KJFi7JwcDhn
FBn++ecftzDOnDnTuHHj3r17uyYx7hMnTrx06RJj1LZt2/bt2/tnqwYBt2jR
4sKFC1Rk/SWCjk2SJAmR5M2bt0GDBoyF6ym0a+vWrS1btqQua1cGL2bPnj1o
0CCzAxkxXrx48bFjx3jN7Prpp58YSgpkihKe9zBOnz5ds2bNlClTMg169uxp
DhJPvHjxYsWKRRJhuHag1eRff/2VpJMnT/qxj5oJ/8svv7Bu5bPWvHnz7t27
37hxwzUDx/m0UgtJrp8OBoIAXI/wmZo/fz45v9MNTj4iTxZCCJsRND15xowZ
XOVTpUqFGGzcuJHru9+ejAYUL178ax4pgDJZEvj333+HCBEiWrRoRvaQihw5
coT+n+Aq2bNnx4gczpt1iBmmnT9//kKFCpUtWzZSpEjkmTJlim/VIQxVqlSh
FmvPsKcgAPoK5zGbky9evEicUaJEwV5IvX37dr9+/WLEiOF6KaftPXr0SJw4
MTJD2IMHDzbHzUV/+/bt48ePjxw5MtFaSd45fvx46tSpES3MJ2zYsH7cusQD
x40bR4FhwoRh1KpVqxYqVCg0ElUmacyYMVGjRi1SpAgzs3Xr1mZQzp8/z2uC
KVeuHF1tfBjWr1/v5eXVoUMH2kjknOJwPiClf//+FI5UY7kYPgNUo0YNBBtV
Y3CtMEaPHk3PFCxYsGnTpiSZdcTRo0eTJUvG6REjRixRokTXrl2ZhzTKjzUC
HUhf4cMod7FixYgEiTVJDEGiRInoOpLok2zZslkKvWHDhooVK2bIkAGbZYYz
QB+dTJs2jWYyRti7w2mesWPHrl69usPp1ZRMPxAh/XD48GHvwSCu3bp1o8bc
uXNb95yHDBnCB4qF57Bhw5ildJfrnqJ9+/YRJMsQMzdcd+y4grczCgwWncbA
9erVCxtn0K3lDLbPYpP5Ty1Mp2bNmpktLqdOneJtkyZNLANnIZAzZ07mGznp
lgMHDvjWt98X8mQhhLAZQdCTuexiJkQVM2ZMrvhckc3rPXv2+HYKV2SswFNf
EcLiEN358+dzlb958ybS0qhRox9//JEwEGb0CRtEHa27efgw9oLm4QP4VYoU
KX777Te0xI+/MlPykiVLMmbMeO7cOY/EbIEFESfx8yJt2rQEg9ug+uZ2JUq5
YMGCuHHjYoAmP8f79OmTIEGCzZs30+Tw4cOXLFnS4bzdh4JSVN26devUqTN5
8mSS/NhfmidPHjQMkWMUkCLe+pYTKWJ8UVMKx4eRK1wrc+bMCOGECRNwbOJ5
+vQpDozoWjNz165d5B8xYoRVDhmQOlQT+0IjSaVMk4QE0gMMihEzSkPGpk6d
Sh6WYCYPI0hdffv2JXXdunUktWzZkvx//PEHY82gI4SINA5Mh9BjZk+Ojxw6
dIj52apVK4S8Y8eODD1NMEljx45FWRkCJJOk4MGDnzx50uHcEh8nThx0Fy1n
CJo3b87KC6VnaYZpM170ISNITvqcfkBlTYHGxCjKjzlw4cIFgm/RooV5y6IM
z+cshpi37du3d92ScfDgQeoimG3btjGleWEluYHcshikJymKQgh79erVFEXH
OpzLSdSXjjIbY3hNUSdOnOD1qlWrOIXTTTks1tBpZPvKlSucxbT5/fff/WjO
d4Q8WQghbEYQ9GQu6/Hjxycqcz92zJgxRlB9zMxFuXLlytGiRWvYsOGf/uCT
j6XasmULtVv7WrEj7IUXKFPRokVJRSrcNkvcv3+fKz4v8JBw4cINHDjw2bNn
+A+qaTLs378f+/IuA1/2WGM/IAB0y9wapaVIuAnetUZUE4nC3BzOLQoYXejQ
oRctWuRw2juOhLg6nLcxI0eOTM8j8+iTSfLt0XzLli3DOY2CokMUyHD4FiQu
jVhitkjjhg0bHM5boKxHkNt06dLR+Wa7CxpM7ZkyZTJfPatatSoyb+2EoYdx
Nhpinm5HaTTcbE5wOKWat7/88ot5i9FxIksDVg1mUKiLRYRVoPFkvI5i8Xw8
s1q1ajTf7OTx25MRYJZpnG7WcUaGjR86nDdySTJ7P1w9uUePHvSYOe5wrl+s
JMYI86QPmzRp4pbk+NfErBN9BGNnmWDFQIH0RqlSpcy2BzdPHjRoEAWSga5m
tdK7d2/f9gKZ3UdofKxYscxfUlikcC6rQqYHSx56jElu7iHjySSZL12OHDmS
pI0bN5pyzIKFGBjupEmTUojb4/u+X+TJQghhM4KsJ3PVNjemjCf7dm8WcTXb
NZGc9P7A74fL4UUIkvcNHohWz549q1Spsm/fPu+ebFGnTh2CcbNfdCV79uxG
+QLaB5YsWUJFP/74o2+bBN69e4d9BQsWDI13uMiw9+0f6HTIkCFJiho1KpLv
R6XIs7mJjW3ydvjw4bz2+/cssCw8MEaMGK6308eNG8eJ/fv3N6JlPBlLx5Of
PHmCwiVLlsxqF0qMPXp5eZkHd+DAP/zwg9W95ltjxuUMlIY6WnfRaRGF586d
29xwNp5s6nI49wkgxnw0qA49zps3b7du3Xx7qhs9GT58+AIFCiDY5G/QoIHl
yawvCNskMSuI0BgvK5GECROGCRPGbFd2TXI4d3Fg1EaGTVKZMmWMpZOENkeJ
EsVaEfgIE5UVgfXnlSNHjhAheuxw7kOmwJgxY168eNGkGk8eNWrU2rVrUVm/
t6CzjsiVK1eWLFnMigkZpp/5vDCRGJ2sWbOabIxXhgwZaCD/Y6Hf0qRJYyWZ
s0jiA7XWibWctAHyZCGEsBlB1pOLFi3qcN57LFasGLLhx63XVatWYYbdu3fH
Ij5+Cj/qRcsrVKgwf/5883bNmjXWd7uuXbuG1NFLXbp0SZQokZsn4wzIALXj
J7FixTI7P10fwHXgwIGwYcN6V2jPQgyIOqNpNcE7V65cIRLE78KFCxiR8WQc
xvXhGA6nj9WrVw9PHjhwIFpFk1E+fMb63QpXcCcWKenSpbt+/TqvCxUqhAXh
yX78EIbxZHO/1GCeQef6myZNmzYlgDlz5vB60aJFJKFelGk6dtiwYdh+586d
eb17925ec4RxIcIbN26kTp0amWTUcEUTxm+//UYJq1evphW4cePGjXlr7qLD
zz//7LrHY8OGDdYej8WLF1P4tGnTONFHVaYVZK5ZsyavkU/ahRjTn7SIfyNG
jGiSMNtQoULhq2fPnkVcKbNs2bLGfjFtzipdurTZycNZKH2OHDmYkCRxVrNm
zUiiQOYPSaZA357wdv78+aRJk44cOdLK06hRIwbdODlVUyCfetYURonxZFOX
OZ0+9OM5z3woiHzWrFkO5zZ+ZjufTfqcI3SgJcPMQPMAGZKIAWlnDWLtKseT
U6ZMae1VJs+3/OWXAEWeLIQQNiOIe/KKFSsQg1GjRvl9yuTJk1E1t6cZfBZY
EDU2b94creIKjkWUK1fOurHctm1bTAO3/OWXX6JFi+Z6sxRJbtiw4ezZs5Fh
bKdXr17YOB5Yv3591ycYVKtWzc2T9+/fj8y4PS7gayDyZMmSMZoLFizwLQ8t
wmcaNGiAKm/atAlPjho1KnpvUun5qVOn4jOnT5+mvfgM3ZIvXz7ysBipVKmS
jw+UNp5sdjWbDRjkHDJkiB8/CIL9hgsXzuiWgS4iKsuT0TnmQMuWLY3lmtu/
nIXBmmcCI2nBgwdn2UJvmzuiAwYMYPhOnTqFkeJyDNnJkydLlCjBEfNlOvJU
rFiRwaLM33//nbfmi5/UFS9evFatWlm3UgsXLkyTt2zZQuHZs2fHBpcvX47G
+7hpZ8aMGZincdeZM2eGCBECc+7du/e2bdvoLpYhJql27do0efr06bQU+yUb
wTucD7Kmn5lU1kwwdl2jRg1q5ywWHVh6rly5tm/fzvwhqVatWiwBfvrpJx8f
TLFjxw5zf/jgwYNt2rRBgNFg/NwEz0qKAs0jKcwGG3oPoTULJbydPnTbq+PK
ypUrKZzT6Sv+10E/m/HiU4D6Gk82SYkTJzbfiyR4Ror2pkqVytyFpi2Ys+lt
JHns2LGmENrL/4jM9xl9CyCII08WQgibEQQ9GY1BbzJkyDBx4kQEDOP65A/+
crWdNGmSH/dRPwkmxtUcO/rBSZIkSRASs3kVPUZjGjVqRBjmJ0hQC+tErJKz
fvzxx8GDB5Pk5eXFhb5s2bJ//vmna/luWzJevHhRpkwZet5TD8Wi0zp37oyw
USYy75tpDBw4kGYib+3atcOKcTaipZNHjBiBz6RNmxbbpKgTJ06QzfxgX4sW
LWLHjl2vXj3rW3JuID9FihTJnDnzkiVLihUrZvYz5MmTx4+tF0gayx83696z
Z0+MGDE6duw4b948pBRJth4jtnv3bpIYgrhx4/72228O58PuWBTgvX369MHM
qTR69OjYFwJJUtKkSVnmpEmTxjwBgwhRX/JEiRLFfJeNAgsWLEiPURflIMmu
jywjfgIwIoepMhlY5tAPPt5Of/z4MS7NuoM+xABN9zKBTfd269bNJNHJrAvM
0oke7tu3L21Bm+lwzsLbrVWVKZDph+rzLwXSHFOg8WQKLF++/Jo1a3zsW+PJ
uDTrPpYAhw8fZlrSmSZ4uosSkGHrm4aLFi3Copm9U6ZMocd44dvWCyI0G2z4
gPz8889ERQeaW9bMN6LlU8AcoC6SrB3UZscLZxUvXtyseogQi+7QoQPrFOYJ
w2qex0iofHzwbR/7+btAniyEEDYjCHqyw/k1qypVqnDZRTC+zUUTPfvxf4JH
mb8Um2fGmr2jz5496969u7kRZ0Cehw4dSv7Zs2evXLkSh+E1buBWvvetywsW
LMDrPOXJlIZymMgrVark28ri9evXPXr0aN26tetf7bE1zipVqtT27duNI5Ha
s2dP81UvHAatKlCgwMGDB32r/fbt22g2hQwfPhzx44Xfv4+MQrP88e5jeF2z
Zs2oa+3atW77CiiwdOnSdJfVtEOHDpETe+cg//Laek4aSYgxpxgBczj3ACPV
rispkpA9zlq3bp33uqxfu3v48CFrBOah625nN65fvz527FjknxebNm1CUPnX
NQlrNTdXLWg7vU2fk2RtSHArkCSahosi0kbvrbNWrVrlWzBPnjxZtmwZKxez
Bf358+cUYr5n6nAuGbp06dK+fXtrXYDisvqrXr06i7u//vrLjzUpnsxKCo9l
ycA89/5dQnqSoWeCnTlzxvU4qwA+zq7LIlrBYoR2ocquj6lh8rh11PeFPFkI
IWxG0PRkm3HhwoUkSZJ43588Y8YMO/3IgrA3GzdujBIlCgb+/e6LCGjkyUII
YTPkyd8ArpvBggULHTp09+7drbtqr169Sps2rd/PhRAi6GCePOP9byXCQp4s
hBA2Q578DThy5EjDhg2bNm167tw56+/a5tdJ/H4MlxBBhB07dsSLF4/lXteu
Xa1nygk35MlCCGEz5MmBxd27d133OQsRlLlx48ahf7HNz4J4HHmyEELYDHmy
EEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELY
DHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmy
EELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4
BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYDHmyEEJ4BHmyEELYjO/F
kz9+/Pjhw4dvU9fbt2/fvHnzberyOAT/2ifcsn108smiJkyYMGjQoFOnTgVY
vP+Pd+/e7dq1i4pu3LgRoBX5SNAf6/fv30+ZMoX+OXbsmD9P2bBhw9ChQwcP
HjzICa+fPn0aoEFaEO24ceOodPLkyZ+cYwEB83b58uXDhg179uzZN65aniyE
EDbje/Hk2bNnc+37BhWtXr26YMGCGTNmnDNnzr59+75BjZ5l0qRJ+fLlS+Sk
WbNm3bp1a9euXYoUKVauXGnluXTpUv/+/UeNGuV3Udu2bYsaNSrTY8GCBQEa
87x582LFikVF2LI5cvHixfnz59+6dStA64W9e/emS5du4cKFAV3R10CQMWPG
pH9mzpzpn/wrVqygP4cMGVK9evX/OMmUKdODBw8COMz/D6uecuXKUSm1f7O1
rSs0PEKECOHChfv2yy55shBC2IzvxZMLFSo0d+7cAK2C6/vQoUPz58+PoW3Y
sCFZsmTIxvr16wO00oCgVq1aIUKEaNOmzcuXLx3O+3sjRoyIFy+etdBYu3Yt
IjF58mS/y3n79m3y5MkjR468efPmAA347t27kSJForePHz9ujrBaIUKPd/6f
f/5ZunRp0y2GsWPHhgkThg7xbEVw/vz5XLlyjR8/3iOldenSJWLEiOvWrftk
ziNHjkSPHr1Tp06M++PHj3PmzMkHvGfPnl9cdePGjatVq+aH8T579qxEiRLU
aB1h4UOly5Yt++JKv4Y7d+5ky5ZNniyEEOLr+S48+cWLF3Xr1r127VqA1oLY
RIsWbe/evebt8OHDQ4YMmSdPHmoP0Ho9y+vXr8uWLYtT3b592zq4YsUKtDN3
7tzWEdTXNYOPGE92PSuAMJ5cvXp114NEiPB4tqKSJUvGiRPH9c/xyCSSHBB7
ErZs2cL8GTJkyNcX9fHjx3Tp0mXOnNk/mbHTUKFCWXeeR48eTRhM5i+reufO
nVj3r7/+6keeS5cu8cFp2LChdYTVB5q6cePGL6v0Kzl48GCwYMFYLb569eob
Vy1PFkIIm/FdePLKlStz5swZ0LW0atWKrqhatap5i015eXlxwQ2Im40Bx759
+0KECOHmyebyXbhw4c8qClONEiXKN7joswLCk+vVqxegtZw+fTpx4sR16tTB
/wO0IkOpUqVix47NEuDri2Ltkzp1an96MuuapEmTmrUAq4CiRYvGjRv3i3fq
4tt+3xnG4fngMOVOnDhhRZskSZICBQoEyuZk2LVr1/9l77yjbLj///8LK8rq
LXpfvRMlehBECUK0IBvtiF6CqEeUQ0QX0UM4iKgJIRG9Rhe9Ey2r97a4v8e5
75M593t3d+7ibmzm83z84dw75T2vdxnzeM2+Zy6nbb9+/f79Q8uThRDCYURz
T+ZSe+DAgbZt2xYtWjQycx1f5dKMEsSLF8+6AXjv3r00adJwwV2xYoVZcvr0
6clhOHTokGchaOqUKVOuXr1648aN77//PuwDdF6QAsydOxefeemwvdi2bRsx
YynWPdJr165hSiz89ddfXe7JruvXr/fai3b7/fffqY7nqpEjRzI2Nm/ebPai
XvZzXFnLNtOmTdu7d++yZct8hkqH/vjjjxy0SpUqsWPHtiZdUIUNGzZ4bkYT
Xb58+fbt2xTuFcbJkycp4dSpU54l379/n95kuQkDMZ49e3aHDh2oDrnPxo0b
zWa//fbbvn37vKIyBcL+/fs9C5wxYwZNREOxF2utQsKCkLNB7ty5Y8SIUb9+
fU9HPXz4sCn86NGjPtvHOlaLFi0CAgI4VT3XmlW0BiPNLKEuU6dORZKx1mbN
mrG2a9eub775JsPY828ijMlZs2ax1mtagimQEkyBDx484HP69OlpNA5tabAn
dApOGBgYSE0HDRp06dIlFj58+JC9smfPTmkzZ84Me1OXejEUWbtp0yb7Fli+
fPmcOXMogf+g2P7MmTOeazlDp0+fzvKff/7Zc3nNmjUJafHixdYSSiAStvRc
GBXIk4UQwmFEZ0/+5Zdf8ubNi+MRYaFChUqVKoWB2GzPdb9Ro0Yv/XIGfOzY
sWPWzcbRo0cjJyVKlMBzWNivXz/jDF7Url3bmMCtW7c+/vhjgsyfP3/VqlUb
NmyIseTJkwf9sDkoQhsrVixs5+ViDku9evWIqmXLlo8fP8aQaUOUKWvWrD17
9sR81q5dW7p06bfeeqtVq1bWLn///Xf16tXLlSv33nvv0dqWW5qxgas0adIk
efLkmLbN824ci0Ly5cuXK1cuyn/nnXfs48RCadtKlSqVKVOGktEqcwN8zZo1
tCEltGnTxuV+GcUXX3yB7NGYBQoUqFy5MkbdvHlzs6p3795vv/32+++/z7+I
kCmZ1MN0AWMGWaVYxIycJYGbatWqYbxsNm/evGLFiqHNAwYMsKI6fvw4+5Ys
WbJ8+fIc0UzCIePAVIkwUaJEdKhZlSxZMow63KqtWrWKtI6mozW+/vrr0NBQ
s5z0gUKoL12QM2dO+5dXoKCEyrGoMtWnNGsaA6u++eYbeoo6coJ8+umnVheM
GDGCLQsXLvy+GxPGV199ZeWPjEaakcSEtbVq1bJUmf8BKJDu4Fh4JkWRu5np
E0mTJmUIkfqFDRL9bteuHd2XKVOmdevWGRtnMDOk2YtDEGHBggVJMK1dcGkW
Ui/WMuRs/lgzadKkIkWKUBSdyMgsXrw4TWclyyRNnOxBQUGUQyIwceJEa8d3
3303bdq01ix0uoMSsmTJwpbp0qXzkmr/Ik8WQgiHEW09mQsoFzUcZuXKlfXr
1z979iwWinhwBQ93+7/++gs3Yxu/HP3KlSs5cuTgWm9eE3Hw4MFs2bLNnTuX
63XKlCkXLVqEJn377bdYx/nz580uiDRGd+bMGYSNJkWzBw4ciHXYP3sVHByM
M5w4ccIvYQMuwdFpuo4dO1I4UjRo0CD836xFeMaNG4cRURGzBI3EK5Bb7Gvp
0qWBgYFmoilelDBhQorCc7CvDh06YCwLFy4M96DXr19HkrFHWgO3pN3sPZmD
0p64NxU/cOBAjBgxunfvblZ16tQJn8STsSmX+z0nH330kcmVhg4deu/ePWpE
vR49etSjR484ceLQBegZMmmm4NJfdA3bsHDBggVUx+glosjgwYGtGNgFo6OD
rJSBLAztRN5IeU6dOsUqMiMGHkqPcjMUiYG9QkJCUK/48ePjnxFVkNHLxkbI
Dbt376bK+DZV2Ldvn0kNIpqVgVqjrARP1oAQ0lD0hTVznqFF4eYPH5MnT6bl
rR2Rf1ZZd01XrFjBVyuDoKkZvQxsKoj8M/DM8GYvVBMvZSEtwLHMm17oTVqe
jM+mKzdu3BgzZszPPvvMipwe5KDmqdujR48mTpy4a9euZi1azvik6ZBqjLd/
//6tW7cOt1jW0sv0HQ3FSU13r1+/Pl68eGYGCHGykGYxf80hS6KtzGOqrCL9
4WQ0Rk1rU02OuGPHDrNq9uzZNtV5ReTJQgjhMKKnJ2/dupWLIJdR9IZrJXbn
cl+1EyRIMH78+LDbnzt3ztw669KlCw52+vRpLtyfRkDLli0juhNo4FqPkqVI
kcKacbFt2zZjDl3dIMz4ktckBJzH3Dcznsy+XNzZ0sx/wEy4QPfs2RMxsN5+
5neQMQyTptuzZ0+4G+zatQuBwTemTZvmctvjl19+aazeVHz+/Pnmz+4IP63N
KvMcH6uwKetP/F6MHTuWLc3TXma2xpgxY2zixGmJwdxLRN4CAgKsm7pESEOx
1kjmw4cPMRwMHMlEWV3uW76EgQhhUGZiQ506dXLnzo3N4sYIPzmCyQuogtWD
ZlWpUqWsGHbu3GleIGYSmadPnzZq1IhITC5gPJnySZE4HAdlY+rFSGBtt27d
zKqIKkiugWOzl/n65MkTbDZRokTmrqzx5NixYzNuw919+fLlqN3777/vct84
pUPNZ5d71kTGjBmJhOwGI/3www89T176CP02xdK5zZs3z5Ahg5WFtW/fnh1x
Rc4CKjtq1CiXO7PgWGXLljXbkCxYN66N9dm/HZHGp7OsXS5dukSTFi9e3NSU
ZI2GstR0yJAhFIh7k5vQhhg450VEJdNBnC/Wo7V4MvuS5bn+eZ8GhZsJS3gy
X83/DD///DOfv//+e1OI+UpXNmnShC4oUqSI/bn/isiThRDCYURDT0bJWrRo
gQyYWRZj3bjc2hM3blzrr8yecFmMEycOFWGDZMmSJU2alK+xI4Bt7F+JhsWl
TJky7F+EEQ904ocffujdu7fn0/1ewQcHB2fKlMlrAioLUZ3Lly9zcceg9u7d
+0JtEkkWLFhAI2BHNhOe8ZP8+fObVxNfu3YNB8NkSEy8NsOpcDkEg7pYM4fD
5d69e2ZGihFOfJICjU+Gy8WLFwsUKICEm9dZoDe0tpV0oIUVKlRgA+vlyagy
MZQrV86zkKpVqxrlQ6UmTJhg/shOhsKhPW8aW5hVnn9zv3DhQr58+dAwY3TU
kcqifEYyjSfHihXL3LFEsz/44IOcOXOal6507tzZWhUWxknevHmpgrWE5sXA
GQBmZoLxZI4V0StcjE+aKdCMQzzWemHF5s2biZkGoeJr1qyh8a05FXR6mzZt
LON99uwZ6UOhQoWsYtFX9u3evXuvXr1IOswdV7IbjkVOGjYMVtFo+Gq4QZqa
1qpVK3HixFb3USM8uXHjxuZru3btaEbrXBg8eDDHIu01v3vi8xdeKlasaM2g
IJOi0b755hvCpouRbbJCsxmezCoz9YJMmc/Wf2hkRnytUqUKzTV9+nTPVwJG
BfJkIYRwGNHQk7mWcXHkEsnnmzdvBgUFmftymBtqEe5NPAzh22+/RYCHDh16
1heIkDVlNCxYXOnSpcOdxPjrr7+WKFECM7HxZEQoderUlStX9lqOOZir5+rV
q2lwn+8ufgloBHNT3eZnQZDDFClSWLmGmVxRrVq1sMbSunVrVBBVo0xcy+Yd
EXfv3n3rrbfwFvQPX8qQIQNCaKNASCPqYnmyeS+E9bAb2RBm1bJlS2t72grJ
tO4MG9iLVMiaUWCYOnUq1Q/Xk80q8ySjAeFkSd++fY0u7t+/n6jatm1rUowl
S5Zw0EaNGpmh8vfffyOrDRo0cLn/eEFyYa0KC45N4uDpyZs2beJY5v6ty53W
eR7LCzqF8c/25j4q4oesWk5uTCzcyTzmVrPlySdOnEiXLp2Zy23AkzmbPMO+
cuVKmjRpwr1pTO+wCg226Ur24pTERa3u69SpE+02bNgwl7sr0fKmTZtaRzSe
vGPHjogK9MLTk5HhzJkz8x8C/UXCUqRIEbMNZp41a9YsWbJYq0hSrHjYy6yK
5BFfEXmyEEI4jGjoyc+fP+d6ynXwxo0beFe+fPnOnz+PGHDRHzRoUETCxl6s
NXu99KHRSCTZ+qMtqoCwmdvaKE2lSpUwDT7jyaid9Vd1l3uCbpMmTXDgiRMn
Wpp34MAB6wE9pAUD58O0adNQC+t1EGyza9cuv7xBCxtBGOw9uUePHkhXcHBw
x44djx49ajy5Xr16Zi2asXPnTlT/9OnT2D5uj3rRIOaWcrgzXlz/eHKVKlVc
7lkTgYGB9evXJ9FYu3ZtuNuT6eDqxpMRrcSJE2NT/fr1M1NBPv/8c0Trs88+
a9GihZk+YZ5N87rj3aZNG883IbMlzWtk+IsvvjALr127ZoSNGmH75DhsQ/lm
Ui5jno2//PLLGjVqYLbGk3v27Olyz3EtX76856N2xEm9aD2X+8XIKDpD9OOP
Pw5X+eh0SiaYvXv3oqlImqcn87VYsWKkHhFNSmcAc2jjyQxIlJsuozRjvLNm
zYodO7Y1V/ny5cvWrWZ6jWzFTFICMkcKWbp0KXU0713x9GTCGDJkCGcTTW15
MoOcGpkBb2ZQkA7QGpxZ4b5tZsOGDew7duxYNib5OnnyJEHSOGbSvrnrTupK
IQwM1//1ZPOcoJlLEy5btmxJlCgRu7Al1SdPMX9X8vRkThzKZzMzHdqsYkv0
3lSZsU3iZj2uuGrVKitXWrx4McX69zcf5clCCOEwoqEnA1fPLFmyIE54Tt68
eb/77jskmSum/avh2OuTTz556Qsf0lWqVClaA0eq7+btt9/Gjc1aM2V0woQJ
Lrcn41Secye4+KIHeIgxnLZt22IyFStW9LpNh3Lkzp27TJkylhiXLVsWbV60
aNHLxWyBE86cOZMIObrns/9eIEXm7QTmJWOPHz9Gb2hb3G/37t0fffQRtn/r
1i1UFsOhwdkG5cCXcuTI4fmDa56gMRgRlUJl6TXzFGHatGm97gB7QvsQKo1j
/bAyyYWZ3c0qDk2nm7/d37t3DwMvWbKk12xwJB9PHjNmDHt17969cuXKhw8f
5nPBggXpAryX1qDvzA1nCmEhDslmuXLlMpMfjEZyoKZNm96+fZtaf/jhhyRl
tAOyx2aeL1ehlbBTI3XmTnvNmjXr1q0b7i+hkKdQneHDhzMAjB/SO9WqVevT
pw+BcZTChQt7veLMC2IjWUDkGGnkEXRZ/vz5R44caboMxyaJoLLjxo2rUKGC
NXi8phNzUhMGO+bJk8fckmX00uyYtnkilQSBheQCyZMnX7JkCQWaGUfmMUDj
yVSzVatWEf1MCcbLNqQe1atXN0/Y0XT0izkHCZIAGD9U2TyxSDKSLFkyskh2
ZCEb2/zCC3FSHTqRvcjaGGDmvXMu95OMadKkWbhw4eTJkwnY+qVO48nmTSPm
LTSchpxfAwYMoOUZ/MRpzQkndaIfOYpNR7wo8mQhhHAY0dOTYfbs2WgqtpAw
YUIE4/vvv4/M+5Mjs01E3LhxA8FL8H8xzw253I/IjRgxwtyYwirRHs+XFeC9
rGV3xJ4POdwYR7LA1ho2bNilSxeu+9ZfojEQLtavfmFF4/FAEzNqFNFdd+r4
/vvvoxxWNkGQwcHBSZMmRXExMeMteB0aY56xOn/+PJqKQtsojXnHNYpC3fHD
DBky0A42N8kJgwZEIzkilosFsT2yaq0qV66c9TspY8eOte7we/Ljjz/iSNSF
QqyXAZ48eRKNNAF4vsN5z549WbNmZbRbL0y+ePFisWLF6BHrpjQVHDVqFO2A
9nu9gXDVqlW4mYkQYzdvNovo5wIZhF988QUDwPPlzOz11VdfEViPHj283vYc
FrrPvMhi+vTpv/32W6NGjXBRS/AOHTrUsWNHhJNO8fxpb0YRY8kadeQvvXr1
CgoKsl4EzehlCSnMkCFDkEwzCNmMYyGWbMlotG63MlxpWALmX5uuJJn1/En0
lStXWq/gZhSNdGOdKeZY5CAci27lEBEVSxuSwnBC9evXz/xr/hxjIB6SkdFu
vKZIzZgxgxTA+kMAW6L9LCEXoO6e6cmgQYNoVT++utwlTxZCCMcRbT3Z5X7g
navb8ePHX8V+Iw+X1KtXr4b8XyK6jIa9xGMd1jvrrrvx2h4lixkzZv/+/cuW
LWu9AYC96tSpY6YHvGLw2IiJOaJX51mReBnvo0ePwu7lWUH80OePd6N2VpUp
ymYGuFcYtLDXu3m9Inzw4EG4A8BU2birJzdv3gz3Zb+E55U+sG/YB7siEzxq
bf9T148fPw73N1kILPJiZnXBw4cPvfaiInSZZ/B8btCgAWPJM/iwYdCSxBDW
e0lPwh02PlsjogJtiOhYnpALkD0VKVLElP9C/wOEPTfpr7DnMm3o80HCF0We
LIQQDiM6e/KRI0dSpkz5rz2DE6V07dr1jTfeMHMM4sePb81J+PPPP3Pnzu31
y2hCRJ5NmzZVrVp13rx58eLFC/e1Ff9FJk6cGG3/X7JBniyEEA4jmntyt27d
fN7c+0+wf//+lf/g+XO9nTp1GjNmjF+e4xP/m2zcuJHMKyAgoGPHjmF/JPq/
yL1790qUKMH/S3Xq1PlvpcnyZCGEcBjR2ZNv3bpl/0PVDsD+RxyEiAwrVqyY
M2eOMzJKl3u6yPfffz9lypSpU6f68acq/wXkyUII4TCisycLIcR/CHmyEEI4
DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmy
EEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4
BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmy
EEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyEEL4BXmyEEI4DHmyiIjnz59v27Zt
7dq1ISEhL7H7o0eP1q9ff/ToUb8H5lT++OMPWvvy5ct+LHPfvn2Uefr06Vcp
5MCBAxRy7NixSG7PgFnrwZ9//vkqR/8PIU8WQgiHIU92GN9+++3HH3/8wQcf
NGvWrIcbPtSpUwfVsba5ffv26NGj79+/b1/UunXrEidOHDdu3F9++eVFwzh3
7lzdunVjxIjRokWLF67D/x6kJHPmzEmQIAEn43fffeevYklSMmXKRJm9e/d+
6UJw7KCgIApp27atz42fPn06efLkChUqVKtWrWbNmm+88QY78uGljx6WGzdu
MHofPHjgxzL9hTxZCCEchjzZYTx79uyjjz7CT7Cap27WrFmDJ2fPnt26qTh3
7tx48eL9/vvv9kU9evQoS5YsJUqUwOJ8Hjc0NHTcuHFbt261ltSvXz927NhL
ly59ler8J6AlO3TocObMmZcuYf78+fHjx8dmixYtSu/4LzRXpUqVEiZMuGHD
hlcphLSLdGnFihU+t2SMYfvBwcGMwxMnTgQGBvLfCwPy5Y5LIdOnT1++fLnn
QjJBxtXmzZtfrswoRZ4shBAOQ57sMEJCQooUKYKfeGrbqFGj6GVLLR4/fjxv
3jzM1r4oNsOT33nnncgcd+3atbFixZo6daq1pEGDBijTy83Z+G8xfPhwmnfb
tm0vXUKnTp1ixox5+PDhu3fv0ux+jA1PTpMmjc+/HdhDnpU4ceLr16/73JL/
T+LEiXP8+HGX23Jbt25NvXbv3v1yx92/fz+l9e3b13Phxo0bx48f73P0vhbk
yUII4TDkyQ5j+/btb7zxRvz48f/++29roZcnR5IZM2agvkuWLInMxr/++iuH
+B/0ZLS2RYsWuGjkp+968ddff6VMmZLm8q8hw4YNG8iYRowYEZm/CEQEelyi
RInixYvj8D43bt68OWZ7/vx587Vjx4548pEjR17u0Ag2g9nLk6Mz8mQhhHAY
0dmTHz16dO3atX/5oIcOHTI+cPHixbNnz9pvTIR//vnns2fP/pXQIsWiRYtQ
C7r1yZMnZsmtW7cKFCiQJEmSffv2udz1OnfunNde9+/f3+3Gc9XIkSMtuw53
LwPV379/f9WqVdl44MCBpjVoxrfeeoswdu3aRbF37twJuyOdG9EqL27evMmW
Bw8efPr06aVLl6zlSLiZTIJh7tmzx0T48OFDNuZruNrJNqam9+7dsxYSA0us
+6Ws4ojW2hMnTphVJgzPVRzrt99+ixcvHqLLB/tamIbyqjLHWrp0aUBAQLp0
6bZs2RLRvocPHza2SfpDCeaGrSeMVVMvz1vHK1asoFNmzpzpuSUSy2YnT560
jzY0NHTv3r1sSe5DIWPHjvVcGzaM27dv//TTT6lTp37zzTd/+eUX1pI6ZciQ
gWHgNSPl6NGjrL1y5YrnwsuXL5v4Ga5mCUOoUaNGHJo0xJTA6Ua3klZ4hcoJ
a/b1XEVqcODAARMhVWZHdrev8qsjTxZCCIcRbT15+/btH3zwQYkSJSZPnowa
DR06lKt2RBvfuHGjZcuW8+fPf5UjcqXu3LlzpkyZqlSpEhwcXLJkyWzZsg0f
Ptxml/79+8eNG9ePD169OmXKlKFDrbBpGXQXSW7VqpXLPX20dOnSOXLkwDmt
XfCHtm3bJk2aNEGCBEFBQUY20Ayk9+23375w4QIl5M2b11rlBaZnnvOKFStW
9+7dzR/Et27diq7j55kzZ06ePPknn3ziuQuqOX369EqVKqVNmxYLsp8VgIDV
rl07RYoUdEeDBg3oF3OrnMDeeecd+ot+pxA8M1euXOhQz549KZYqDxgwwEoW
XG6XHjx4MHXH5fDSjh07muUc/dNPP40TJ061atWMSrVv375+/fo4OZ9JEyiW
AzVr1oyFhFG3bl1CMvuir/Hjx6em2CBB2tQCL23SpEmyZMmIrXr16ps2bTLL
d+zYwRCi9QIDA8MdwHTEsmXLqA4d1LRp07Jly/KBw5GAWNt89dVX2bNnT5Mm
Dau6dOliLZ83b17GjBktJaY12DJPnjy0AF1jM1GEThw2bBgHJVq8l+aaNm2a
tQpnLly4cKpUqShq3bp1ZjndQddQERqEvRhm7777rtfTf/R7hw4dWEv8FSpU
sFIVkpfixYtTIMfCjZ+54dxn95gxYyLbZmr0oEGDYsSIkTt3bs9XgpCq0Ps0
LMelp8xdfXafPXt2ajd0LpFQl169evn9jr0X8mQhhHAY0daTMROu+1z0EydO
HC9ePL5GNCMRkcBUMYRwLS6SXLt2DRVHSH744QcaJH369Bwa/6latarNXnXq
1OH6u3jx4pc+rn9BD0qVKkX8mNhIN4guardw4UJjCBjgjz/+mDJlSjYwu+BO
LERFdu7c2bVrV6q8f/9+l7tBcA8qyEUfO0W/0WDPl2Z4MmnSJA6KAll9hJGi
NDVq1Lh69epPP/2EF1lpDv2FMSZKlGjWrFmYErZsk2hgpHgpanT8+PFDhw7h
UaQwlECxdA2uSzlZsmTZvXt3SEgINUV36bgHDx7QmygW2ZYpB+nt0aMHvoeG
UTUKQSDNO+tmzpw5YsQIwiDIu3fvor70PmkXjcmB6tWrh23SLIgferZmzRo+
jxs3zqoL/hw7duwjR47Y3K4kPSlYsCAmjLwRW8WKFdnLODwlkA9SAqvCnR1x
584dTgTjnJwLS5cu/eOPP9C/du3ame2pBXkKTUpb0aQkDpYrIsOFChWyivry
yy9pk5o1a9ICjHOGSrjRUuzXX3/NwOZ0IFqGUNasWa3a4eeMBHSdbAV9pWtM
QuFy5xQ0zueff85ebD9+/HjGgJWPIMkcmoRrypQpf/75J0kZA8PlFmyUmPan
wCJFiiD8pkBOK6rMyDQ383FpuoANqIL1ssEtW7bQoVR/3759ZBlkHB9++CHL
yaxpVbqJEtq0acMwGzNmDDu+4vOMPpEnCyGEw4i2now7cd18+PAhkoZu2dz7
wnMwkCpVqmAac31x4sSJcAu5ePHi2rVr+bBkyRIapFatWlxqaRwjjUgmqmlK
QB6siRb4Bju+yuRP/7Jy5UqMi9bAl87/g2eEuMTAgQMRBqTR5a4Xkow9mpt+
rG3cuLFJNxDCuG4+++wztOfKlStTp06NKFWZPn06jcbRrSU4GLZpDMdr6vK0
adNIfOjTOXPmDBgwIFWqVKblw6Vbt26EZ8QD28STzY1xImGEID+sxRhdbp/E
/1FK87Ze1JeDWu/fwHWxO5zK3MNcsGABa+lTPq9fvx7zzJ8//3vvvYfdmUTJ
rHK53w1CY9IOjC6XWwVZSwJi1t66dat8+fK0uf0UHQZn/PjxKcp0BAei1tbd
VNQO28f8w92Xxmcc4pYcl/qyBL2kHbJly0YjMJ7zuDGlUU0269evHwfCltOm
TUtGYMrBM9mFtU2bNuV8r1y5ckTz1el6c3ed4WH2ql+/vhnzjCWTiGGhVAdr
tVYBGQ0NZb2vgyQrYcKE1ltWEGYsmoSXDUaNGlWuXLmLbiiQ1jB/I+jbty/J
minw559/5kDIttmdTIRV9LXlyfznYCZmmDe34OEky4ULFyZj4jMncvfu3cl9
zFOE33zzDVvajDS/IE8WQgiHEW092eU2BCyuSZMmNnfqDh06hI/9vwhIkCAB
a7k04xVmCdd3Lq82BzWe7PVuriFDhuBCixYtws248vqc2/m6IEKCr1ChQkRC
S0vSnqlTpz516hRfcTNMJkWKFGFvFLdu3dq0WNWqVb2mknqB1aA3SZIkwTbN
EkQLLbRksnr16lmzZrUe6DOilSVLFkyJo3jOAPHi/v376DR9Z6andunShRRg
z5491gaeMmw82Tiz1yoi7N27N18xdpf7fql5Q4Ulwxg+X2fMmPHkyZMyZcpg
rZ43HrFcS2s/+uijdOnSWc+pkUbhfs2bN7f5gz4WR2vQAqZTbty48fbbb1sF
3r59u2zZsli6NS83XNBFCjGZCOkM0SLbHLRXr14mcrOZ8WRWPX369Ntvv+Xz
6tWrPVdh1DQ7bm9N/PCCxqG+1qxms5f1LOfy5cv5So+ULl2achhvnrO1K1as
aL1bg3rRktZbMqgsAylGjBglSpRgR84jMx7Gjh1LgZxfYZNNVnH+mi4zkMFR
PmZu/kPA8/F5ijVHNJ7MQc30b05zeopzweX+awLObK2KOuTJQgjhMKKtJyPJ
3bp169Gjh88f88JpkT0ul2jPkv/L+vXrEWnkZ9WqVWaJ/UtuEaratWsHBQVZ
ImTo379/ixYtuNajgnjR0KFDX72Cfofga9WqRW/azNM+e/Yswv/pp5+ar6hI
QEBAvXr1vDZDSPBYVuFauXLlQnRtXsN19+5dcgfkylry448/EsYPP/zgcvtS
jhw50BVLhPBkhDYy70Cg6zErNr5w4YLL/UJmxMmSdsQS4aQ0zNPlvk0dN25c
I/xeq4xC49hGDtHLzJkzszGjwhTVsGFDmsXMTsmUKRMSaMWAg+FX6CUDkpoW
KlQI47WmPZtpGD179rSphblBXbx4cTOd4JdffjG+an4pg5D4Onr0aJsSaDq2
L1iwoMt9I/39999nl8WLF9O2yZMnt2TYrKJev/32G7sgn1TZejbQGK/POUKM
oty5c9M+5qHICRMmUKAl28aTOSvDPrtKQ5UsWTJfvnwmDyXRYEvreVKyGxoK
y/WcWkwhjC42mzVrVtgwWFWkSBHPhWQ9KHq/fv3M12bNmrEveZ/5ylhlrTW2
L126RDLCmHG5J4dj7NaqqEOeLIQQDiN6ejLX1g4dOnTq1InLJZ+xU/tbuKhy
kiRJXvqHHszNN5yHaz0WhNK43Po3ePBgc1k3DxaxBCPiQNZf89k+qu9QRR40
ieAzZsxo84IytCdmzJiohblDSCNjL5YnUxc8ipoePHgQQa1YsSImhjSijlev
Xv3555/DLXPRokXx4sX74IMPaH8yCPQPgWEX86qB7777jkP89NNPS5cuNbcB
0Vc0zOgTLY9UR3Qz1nhy165dXe4/u5O/fPjhh3im0aqQkBC02fyGBVpIXdjY
ePKMGTNQJsIgEdi3bx8dlyFDBsvkkT0SK2pn1J1/sbv8+fNTcQyTVSVKlJg+
fbrp5V9//ZX4zVNshMrnjh07or7Lli1jCdkZMTBytm3bNmXKlHBrYTyZfV1u
RW/VqhVd8P3335u1kfFk2i1nzpzGk+mR9OnTo82cEfRXunTpLE8mVIKvXLky
NWIzUgM+f/PNN+Y9J16eHO5LM1z/eLKZ1Uz5DKeyZcuSN5lJGsaTLa0lc7QS
qBUrVtA41lRz48nDhw/v27cvPbV//356hMzXanOGhMk7PAtk4JkepFmSJk2K
J5Py9O7d29xsr1u3LmcfA8l0R+vWrWPFimXue5M9FS5cGKW3pi4zFInH/I3D
vJ6aGKwb44RNj0TmTXcvhDxZCCEcRjT0ZC5hqJGZgYm+Nm/evECBAuFe0y1u
3rxZpkyZsHelIsnGjRtjx46NVyBdXE+LFSuGZvD5448/tp5Rwh/GjBnToEGD
ZMmSWRMMGjdujIBF9aTHSLJnz54UKVKgoBHNwQYznzNOnDjvv/++y62a5cuX
RzAuXbqEa9WpUwcz+fvvv7FEHKN79+4u9ws0zAN9nu9G9oTcgY27dOlCu40b
N878Oon1jJiZulzfjfFkZIk4d+3adfjwYT5jfTt37gy35IsXLyKEuOjevXvx
WI5So0aNNGnSmPbH2/HzUaNGudyTbxMlSoTgsQtfW7ZsST9+8cUXhGHmaRBY
3rx58T1Mj6PTcdZUE5yNwhFO1JFONy/uwEtNBjRgwID/989vSRvjJa0gBnO7
FfdGTYnh3XffjeghR4pNlSoVjUkG0a5dOwonPGsq0YgRI4jcumEbLgxsqmMi
bNq0qefrShiThITer1u3jj4ilTh06JDLrdNUk5OIzjXHopEZ4T169CAMqsOW
6H3YY9Ean376KaPaHCsgIIAtaUYzT5g60l9myvqcOXOwXOs3zc10YuscNJ5c
s2ZNkg5GFOdRw4YNUd8LFy7g6kOGDCFa0kyalG7FdcmbKBCxN08ErF+/HiUm
jGHDhiHqZnYHu9DjtWvXNiJqfu+PvINOHzhwIKsmT55s3egeNGgQJZu3gpgc
igCsH81ZuHAhUl2yZEnrBPcL8mQhhHAY0dCTV65cyTWOyz2xcaVDujynpEbE
tWvXXvqSx/W6TZs2SMV7771XvXp1hARxQgyMdAGWbu6bPXz4kA3M/VW+Ij9E
2Llz55c7rh/BE5AxM6O4ePHinu9D8wTPyZ49O6pjvQhiyZIlqBR2jTB/8803
5u3EO3bsICMwKojwoIUYUUQTaJFPNqabWrRocePGDXqBD9brwlA4/DlBggTW
JAcUixZLnTo1cWLXZqZ0RNDyHLpgwYK4WceOHemjPn36GPFDfT/44AMzzRUT
47P1zNexY8fYhUOgW2YJgRFV0aJFka6vv/7aq31WrFhBOoCk4XXV3Vj3XVmF
1hpP27Rpk1k7ZcoUM9hoRhqTJo1Ikg1kUgytfPnyVatWjc+er25GI80TeTa7
o3+mW4ODg3FFz2NRL7SWhI7eHz58uJmg4nKndcgwnYIiWhvT2iYMsiQ6KKLX
8d29e7dTp04ca/To0fzPQH3JVa3HDLdu3UrmQiHkCPSp9fcUI/yWe2PyjChy
k4kTJ5olR44cqVu3LplIpUqVrALNsagaW1KgNWsaXef0J34yO+s05P8BcgQy
F/MHCBptwoQJpDwkKQRJRuY5G2T+/Pl9+/Y1k0AmTZpkOs56xzXV56v5o4Af
kScLIYTDiIaebMF1/Pfff3/pnzl70WMhhEZ+du3axfXamk9rHvk3DobjoTpc
vs0PoLAXZhUdPBkJWf0PmzdvtnkFx4kTJw4fPuy5BNVkL8/f7/MCMfP5kys2
N7GvX7/u9boS7AWh8gojImh/M0edvfDeiFKAiPbyBNGypMsLhM3zF0wiD7Ww
qbsFwTPAvIIn9UA47d/RzRgzP4dn87PRBL9x48awc4bDBsYAJoxX/NFnNJWO
8Hy61kwnJuHyOpbl7RYMs7BTlUiKSR/CPq4bNn6yqrDBR6b9/x3kyUII4TCi
sydHE5CZWrVq5c2bNzg4uEaNGpkyZTJvmnK5p9e2a9fOumkpRCSZMWNGy5Yt
MeQ333zT/IhGRCD2SZMmtd53Hd04efIkpwCmGhQUZC/8/wvIk4UQwmHIkyPD
zZs3BwwY0MvNjh07rOVHjx5t1KjRv/B7uMJhIMlvvPFG3Lhxy5UrZzNfiIFX
qVIltsyZM6fPW/qvhSZNmhBewoQJ8+TJYz+F5n8BebIQQjgMefKrcOHChXAf
hhLCnjNnzjRt2hShspnu4nLPUmjcuHEDN/ZToF8Xhw8fJlUcM2aM/Uu2/0eQ
JwshhMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQJwsh
hF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQ
JwshhF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+QJwsh
hMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+QJwshhMOQJwshhF+Q
JwshhMP4r3jy06dPT5061a5duzZt2vz5559Pnjxh4YMHD153XOLFuHnz5pw5
c27cuPG6A4mQx48fDxkyZMOGDQ8fPnzdsfiHe/fuLVq0aOLEiZxEryUAztZr
166dOXOmc+fOnMV8Nuev85AnCyGEw4j+nvz8+fNjx459/vnnGTNm7NChA5fa
oKAgwh46dOiAAQOi9LhRV/gzN1FX/isSRbFt3749S5YsceLEyZ8/f/Q0pdDQ
0C5dusSMGTMwMBCxjNJj0cjTp09fsGBBVBRORazP7du3p81jx469e/fuqDiW
Pfv37+dszZkzZ7du3QgjQYIEiRIlWrFixcuVFvbEOXr06OjRo9FvfwT7qsiT
hRDCYURzT8amevXqlTp16saNG585c8YsXLduHUsIu2PHjlF03NWrV0+bNi2K
Cod+/frh+VFX/qsQEhLSokWL06dP+7fY69evZ8qUqWrVqogoo+513du0Z8qU
KQRZt27dkiVLXrlyJUqP9fjxY1K/MmXK+L1kLLRo0aI3b940Xw8ePBg3btwa
NWo8evTI78eyB13H0jlbOWfp8UmTJhFJ8uTJd+zY8XIFDh48eODAgZ5L+L+L
/wqWLl3qj3hfFXmyEEI4jOjsyQ8fPuzevXusWLEaNWp069Ytz1WfffYZy7/6
6quoOO6RI0feeuutqPPYs2fPpk2bFl2MovJfERIEZGbJkiX+LXbPnj3x48eP
trV2ueeE5MmTp0GDBnz2e5oQlufPn//xxx/79u3ze8l4fqJEia5du2a+Xr58
OTAwkJPI7wfyCadtsmTJatasab5yRqdPn75cuXIvV9r58+czZMjQrl07z4Wk
Mxs2bLAq+3qRJwshhMOIzp68fft2ZBhvuXPnjtcqVDZlypTWHTP/gr288cYb
UefJW7dujREjRrQ1xgIFCuTNm9fv005atWr15ptv/gv++dIcP34cnzSe/N/l
6NGjuGhwcPDjx4/NkjFjxpD4/PTTT/9+MNOnT+fQc+fONV8XLVoUL168yZMn
v1xpO3fuDAgI8PLkaIU8WQghHEa09eRTp07lypUrVapU4d4pOnbsWLNmzay/
Iz958uSBG8sNXO6pjCwxT2PxL5/D/t05NDTU7GhWPX36lM/9+/enTd577727
d++63Pf9WMghTIFgJn+yi1W+2Szsk1/37t0bOXIk6mKmGfDvoUOHcubMSfkl
SpT4+++/bVrAlB+2XmExEZqnGs1nz+mpVvXBc24nZVrlGytmr23btpGApEiR
YsuWLZ4lsA1py9mzZz1LMBGyl1V+uLMp2OXcuXOFChWKGTPmhAkTLANn44MH
D44dO9breUyrka3wIqq4Oa7nlp56b/rr0qVLGzdutBaaoULdCZ5VGzZsMDOl
//rrr6JFi9IvuXPnPn/+vGcdkT2axbNJzREfu7EiNK3x1I1ZaI29iRMnet43
tvrL6lZiIHuilSj56tWrq1evDtvj7HXlypUhQ4ZcvnzZqystdu/e3bRpU2pR
o0aN27dvm4WffPJJnDhxOGW8wvBsRobo3r177SfD2LQ2O+7fv3/8+PGep8OF
CxeKFy9OytmmTZu1a9f26dOnXLlyxOY56cI6p7x62WtE8S+pcZ48edj97bff
puPMZmE73eUe2CEhIb///rvnHHjTKfRRuP9X+At5shBCOIxo68lr1qwhsOHD
h4d7Y9Nc9cxnvOL999+vXr36Rx99VKZMGUtyMIo0adIg25MmTWJtvnz5ypYt
62kXSGxwcHCnTp2aN29esGBBVAFXadKkyZtvvhk/fvwWLVqYyR7z5s1Lly5d
/fr1e/ToUatWLcps2bLl/fv3EWk+582b19zunjp1Kldwz4svVciSJUvWrFm5
vvfr149D79mzp2HDhtQLb2ncuPGsWbMiqj7K9M4777CxOQofbNpq7ty5RJg+
ffrFixdziLRp07Zu3doYy82bN7/99lvCoDRMlRTAtACmUaFCBZZXq1aN8tmG
hatWraIlCa9SpUpffPGFVZdly5ZlyJCB2hHziBEjPCNk348//jhHjhw1a9bk
c7gD6cSJEzQmvoQn07zs6HKrZvfu3ZMlS0a+kD17dkvLly5dyrGoArvwL2Vm
zJgRiQ1b7G+//ZY5c2Y2YEsCqFixIo2ATZm1VHPAgAGUwKigppinaQ3Tg1Wq
VClZsiSVTZIkCWGwipFmIvzwww9Pnjzpcrvr/PnzaTScE4UmcgYMy8meGjVq
RCEUW6dOHQYVAWP7FGjGRvv27Tmt2IWoaFjGHgfNli3bgQMHTGzkSqZqbdu2
NQU2aNAgceLEZCjUhQDKly9ftWpVBrZnfRkt9BeHZkSx78qVK70ahJNi4MCB
yZMnpwcRVDNz5saNG5wUVI12JoygoCArDJfbMymW1ICsk1OAMRzRGCPXoAqm
tWlSKsVnY914LxUpUKAArVG4cGFzYp45cwY9juGmdu3aHTp04AwKCAigy6y/
KaDuvXr1Mn30wQcfLF++3CwneeFYVKFIkSKMQ+rFgRh71Itzk3NhxowZbPbL
L79kypSJMFB0K05Of+pLG+Lk9K/JsulKTnMOxBhmYeXKlWmH0qVLeyZEfkGe
LIQQDiPaejLXdALz+c4BI8mlSpXiksc1MWfOnDgean327FkMB1PCENq1a8fX
77//Hjv98ccfzY7ILW7A1RNh+/333wMDA80fprELjosNGj/HAbi+161bl3Ja
tWq1c+fOVKlS4b3YBUbEFRktMTptfMm6ZY3FoW19+/Y9deoUq5A9swpho3zL
V8OFaIsVK4bYIzmTJ0/GDbiyR7Tx9u3bqSm5ALVDDxBFIsTzzc1qYuZwOB5y
snDhQiwF+0WSCYkqT5kyhZqyQdOmTU1pGAhfPR0M906aNClVPnjw4K+//mpN
XaY0moXAcMuuXbvit+xIAOE+LIab4Us0uHFvHL5Lly5IDmoUEhKCX9FWFy9e
ZBXL165dyxHRzt27d6NYVN96hNOTzz77DIlCkxIlSkSmQJrDXnSKy+1FGGPs
2LG/++473BgTph1Y/ueff9Kw+Buhsurw4cM4p1l15coVJAo9M+1GhIyNWLFi
ETND5dNPP+Uz44RVLCcNQbCRfDII0jFagAJnzpyJq6OCHI7dsTjGDOVTCwT7
3XffZXCamUJkZ0SOfpv0By2nNFSTQvBPhvGwYcP4TM9alaXwhAkTciykceTI
kaylX8IdD+glGZN1x3Xv3r2EQb34QBi4PZmjNdu/d+/eZiYDed+0adNIdvgQ
brHdunWjXog6tSDCOXPmMN44O9atW8d444jkmHSlZwnHjx+ncE4fMyQIKV68
eOiuWUtFKJOKMHSvX78+ePBgRinL6X0GQ8+ePWkW2hO5NeK9fv16NsaczV95
GOdUhJZkIWelKZN8imFDDBTISUTeQRLncudHdPro0aPZmA0YTqRFfKb7wq3s
SyNPFkIIhxFtPZkLIpdL++msqCYeFRQUdOHCBbOkcOHCXD1ZzqWQqyfugcce
OnSIVfPnz8e4rKmSmBt+VaBAAa71e/bs4XJvlhtPtjbDw7n4NmrUiGuuuRHK
xidOnEDLb9++jeqgDVy4t23bhjVhxcau9+3b99Zbb5lVfN2yZQuKZVYZT7aZ
oknwffr0sbZBXBESK56wECHBY27Y2s8//8wS7AstR2YIg7Ap6pNPPiFBwENQ
LPzkq6++YuHXX3/tcs9vIUEwLzTGZ/AorNt61QPx06RIMhbKVzzZaAB1uXz5
MmZbrVo1dBctYRfKMU0UFlobz0T/zFckFoPq1auX+eo5dRn/wd5RXKPu+/fv
x6XDnXpBSATAIGEMuNyJD5UlHpf7DQ9kAYSKJtGYVMrcr2YbBkaPHj0SJEiA
N7IEVTZ3I/kXn0TPTOFmbnyVKlVMD9J6RGimLu/atYt9U6RIQYLmcv+VHyWm
7hwiderUmKRpzM6dO2O/jBZzFFahamYmAIWzCxF26NCBr4jlqlWrxo8fT8Dm
vreXJ1MgokuOw1CkhKpVq9IjtH/YNqGC+fPnRwWtGRRYPU09atQol/vuMXkN
J4UJgwYnsyN/QYDJjIoWLUouGdEwO3bsGFZJu9EmLve0CkLFt8lxCJVab9y4
kcyF/MuaemE8mYXmKy2MJxOP+UoKTJOa/IJW4hTDkOk4rJsz2pg8pxX5psko
jSePGzfO7M7ZR8w0IOmDuUNOFvDOO++QIf7xxx8ud6bD2KDrXe4/XtAFpHWc
SiYdxvMJhiNGVN+XQ54shBAOIzp7sjHesKu4ZON7XKnxw8SJExcrVswsR/OQ
BM+9ypUrlz59enM7iwIRV88ZmOhZ3Lhx0Uus0syZpMxmzZohflzirc0wNy73
Yd9BRxhsae54L1682NOuuRZHdDMcbUCZ8IGIKo7fUikUwmgSMom/2b8Vgfpi
wjjM2bNnXW5PNkaKYxAGRjdmzJhvv/3W3LBFJwgACTRK5gmrsBSjnQZ0gqPP
mzfPfDWeTLsZ0UJjsKzhw4fbxGYYNGgQEmtmzNIFyBXRmju3BE+bez7i9/nn
n1Os5x/TI8LcWTUO/MMPP9CbxpNbtmxJ2KVKlZroxsiqISQkBLOqX7++V1Fe
nswGfLWkzswboZGtQmhVr1kKmzdvJhhCMl/fe+89GtNM1TAdYWTV8Omnn5IL
mP5yuaWOnAv7Jf9iEA4YMIAGQcjNWg7E0c370BBIhjQ6Gm6DkAyy5aJFi6wl
iDHdbcLYtGkTaxkMZpW51UxH4HWTJk0ys01sYAhZJm9BV9LsZF6UsGDBAs8T
lialcOtvE7QeW1pTaDihKI2Tlx1nz55t/tDAxiwcO3Zs2KOziiHkeSIwnsk1
rBvUly5dIjGx3q1x8+ZNMzfGfCUwTn/+E6B50Wb6t3z58vb1fQnkyUII4TCi
sydzXfN6Hs3lVlmky0yfGDdunLnUmlVIAtKL0pg7t3hXtmzZGjRoQCEsKVSo
EB5iFYitIQ+U0759e5yHw3ElZWFQUFDx4sVdHr8zgtOaqQVekfz+++8cHXlg
y27dur311luIjdnrnXfeMavC1suE8dxNuBXHkxMlSsTlnmDu3r1btWpVryfL
wnL06FEMBAM3ZWKJCK3rHz2zbsEZ7ty5g7/hD2HblryDQxs/pyhkOG/evJRA
w5oN+vfvj1lNnz7dfMUM+WruS9uDviI5ZiI3KQmKiEFhmy73vVaCjxMnjplc
wTaoHce1Zg7YYCYVo+t8poP4PHjwYJdba/FMSg67y+XLlzl02PnedFa8ePEW
LlxovtarV4/NLKkzj8KZm+rQp08fhoRXsmOCMRZ67tw5Ri8OafSP1qZhrb8p
0MUlSpRgmF2/ft3sSwbBIKxevbrLPQMkefLkdevWtTpo8uTJlqCOHj2aJMK6
Fe8FJzIxLF261BpglSpVoiiT1+BvpGBr1641q4wn026RfLfJN998w/Zr1qzx
XEgdq1SpEu5sDQyWw1l1bNq0KVrr6cm0oWcK43JPXgo7Yq1V2bNn56SwoqWz
6DKiMktIrwivVq1aZu2IESNoqIoVK5qvNGaOHDlMtku0adOmZZXfX+oiTxZC
CIcRbT2Zq6rnNAkLHKBdu3bm/tjPP/8cP35848lYbs+ePZENa7KimUFhqsZe
eM6MGTPGjh2LiWEsXDTNLAWXe7YGXsRF88SJE6lTpw4ODn7w4EH37t3N9AO+
JkmSJOwPflmezCXY2DVLjEMiw56ejE+amSFIQpYsWcyMzb59+4b7eJrx5A8/
/NDlvocWK1YsJG3q1KkbNmyIqK0OHTqEEhiTp8WQQKNYxpOnTJliNrtx48bF
ixeXLVuGrrz33ntmIbUmbDNVgAbENPbv309zkUHgJOi65cm4X6ZMmWrXrm3N
bjXziu3f2uFyix8tXK5cOTN9AtvEUixPpnC6BqsxMWPL9LuZZmyP+eESDPzh
w4fkEeQpfDUTP4wnW7OaaR/rPiR1NBNrvUpD9ijBzLJwuT05YcKE5kk6Asb3
WrdubSLEsqi4mQXhWULJkiUzZMhgxswvv/xCu5nHzWhz85zjH3/8Yd74TTC0
M15HimFumxMPnc4SlztbQf9IBr///nt60PV/PdmYmOfUZQucvKgbzg5K/uGH
HxgzFDVz5kwTBp7JQN26dat5GNN4cu/evc3u1CvceeAGzhpqUb58ea85MDSF
NZED27emSZhVlieTs1BBUjmG1p9//un6x5Ot5y6PHz++e/fut99+29OTGWkm
Q+T0IXLip68HDBhg/vTQrFkzMiyypC+++IKvHTp0YF/jyZxf/AfC4DQ5lMud
QTAkzEQL1DogIICTi3Yw0TKGOS9e/bE+ebIQQjiMaOvJN2/exCcRzmPHjpkl
XMSHDBlSpkwZ67Ye17h33303T548uPGXX36ZJk0az9/DnTBhAkK4atUql/td
AVSzV69e77//Pi60fv16PA1p4crIvlydUVmX+9UWsWPHRiw7d+7M5djcDKxR
o4b1sJ4nxpMpc9SoUVyv8+bNiwsZNUJWsQJW7dq1C0tBC00Yy5cvx1twdWyt
W7duYd8j53K7Qa5cuagX+yJv5h1fyI+JMFyMJzdu3JhdSpcubeTK5Z4HSxiI
EMu/++67smXLsgrPKVKkSIkSJXa5IXis0syIMJ5sXhNhHtZbs2YNmcjQoUO3
bNlCK2E+xqgNHMs8GGjflWa2hucsBZSeYgmGgcexiMGSK3qZxozML5Kj2XRi
ypQpFy1ahMTiUdbvMmNHdD3tz1DhKJUqVbJWUVm6OKwQenkye+F4dDFN1KRJ
k3z58llGR8aEcXFErxLwZHIBM7EHT6ajzVRY/JZgGGx4HaPU9Y8n01+5c+c2
N6W7dOlCD5qJ9CRQmPzgwYNLlSplRH3x4sW0CXaHQjM2kiZNGu68HeQwY8aM
nDI0eNWqVRlInA6EYd4jwULCaNOmDTmIySU5sxjYn376KZZIWkTw1gSbsFAa
G/PfhddyM0MY9SUkEjQGiRnVtCRSTb1MckFHsDst8M4775gkZc+ePaSfCxcu
pIXR18qVK9NrCxYsoNlJUVk4e/ZsRqw5o+lrLJ00hD7t1KmTcXVKoyvbt29v
HtajQMYDu7AvUTEyLUl2ud2Yks1UFnIQBiRjrEGDBmbgIcksYd9XfFmcPFkI
IRxGtPVkl/vSXK9ePYyOCyJ6gyEHBwd7vdf3r7/+wtbSpUsXdhV2Z/6Q7XK7
DVdwFMKynenTp3Pl5epcq1Yta8rl8+fPUXFKM69xMwubN2+O13m+i9Vw+fJl
8zz+Rx991KNHDz4UK1bMetsDypE+fXqKQsCwJmuvMWPGsBBJDlugBcqRP39+
sxk2xQebB6xMQ02aNClr1qxs6TXZA2M3YSBO1kzREydOIN4spAUQe0sO8eqc
OXNWqFDB8zcpyBrSufnggw88JRlq1649cOBAmxd3GMJ6MkdEPk2x1oReA5kL
GYfXK9HCBfOJFSsWcksheKy5S2mgF+bMmUN+QY/TNcY/DTSp9YY3C/YlycK4
rKkORGhGiHlpiefcXVYx2LymH7jcb2ix0jQjftYqOoVy2rVrZ4YHzcjGOK3V
ziRBTZs2NbnYlStXsmfPznDybLERI0ZQQurUqRHsiH4JhY7o378/OxYoUMCI
NEFafzhwuR+doxAc0rJB0rds2bKR33ESmdkaEbW2eULQc96+tZx4GDOkqxzd
+rPLhg0bvGZQmDezeb6rDYs2Y4B8wbrDj7Hjwywku/FMe9mR3Tt27GgFz3jO
lCmTeUOIKZCTrmDBguxLNuH1JwMyZWt6OUbNESnNTE9yudMivvbp0+cVf05d
niyEEA4jOnuyy33t27hxI9bKJT7sz2cYrF+78FqONni+o+yRG+ur9VsPXr5q
fvjA83LJdTmiq6f5mQnrJ0g87w+H/S2JiMoPF/M7C2xsftYhMhMpzS5eW0YU
htePpHgW4rVlRA1lCrGXZFPNzz//PGXKlNZTaQbr5yrClhDubXYviArtMZOQ
w62Iy6MNPRdSi7BDBeOKESNG2GQk3BJM8GEP59kaXmPPtKFnp5tfu4iozLBd
aYYN6h4vXjybtxx7jUOfYbj++amOcN/m5wXFhjsOrV/u8Gyo33//PWnSpFu3
bvXaLOxvf4TtPpsRGzZ4r2EZ0cBmR88CvXo2kmelT+TJQgjhMKK5J4v/Lvfu
3WvZsuXkyZMzZMjQrFkz/xZ+5MiRBAkSRPRq5UhChPPmzWPwY/K5c+f2uskc
Tdi9e/fcuXPNxJjg4OA4ceJE9PK96AD++cMPP2zZsqVy5crmsbvXHdG/ijxZ
CCEchjxZRBHmiTxGV9KkSc0rbf3I0qVL33jjjYCAgLDzHyLP5cuXM2fObCKM
6Gc7XjtdunShpjNnzmzcuHGaNGkGDhxoM2PntXPp0qXAwMBkyZKlTZvWZraz
U5EnCyGEw5AniyjiwYMHCxYsaNOmjecf3/2F+YXxXLlyWVNMX46DBw8uWbIk
KiL0FwcOHOjVq9ekSZOIc+XKldH8Du2jR4+I8+2337b5ZRwHI08WQgiHIU8W
UYrfX1HrWXI0l0Z/EXVtGEX8j/RLWOTJQgjhMOTJQgjhF+TJQgjhMOTJQgjh
F+TJQgjhMOTJQgjhF+TJQgjhMOTJQgjhF+TJQgjhMOTJPgkNDX3swX/uoaqX
5tmzZ4//L687IiGiNfJkIYRwGPJke0JCQqpUqZLRg2XLlr3uoP4lNmzYkCdP
Hs+6z58//3UHJUT0RZ4shBAOQ55sz++//077FChQYP369dvdXLt27XUH9e+x
b98+qrxy5coyZcrEihWLlOF1RyRE9EWeLIQQDkOebI/x5G+//fZ1B/KauXv3
7ltvvSVPFsIGebIQQjgMebI98mSDPFkIn8iThRDCYciT7ZEnG+TJQvhEniyE
EA5DnmyPPNkgTxbCJ/JkIYRwGPJke+TJBnmyED6RJwshhMOQJ9sjTzbIk4Xw
iTxZCCEchjzZHod58tOnT588ecK/1meDzx3lyUL4RJ4shBAOQ55sj5M8ed26
dbVr186cOXP9+vV//PHHatWqZf6HGTNm2O8rTxbCJ/JkIYRwGPJke6KhJ+/Z
s+fOnTsvutesWbPSpk37TgT89NNP9rvLk4XwiTxZCCEchjzZnujmyaGhoUFB
QZs2bXqhva5fv54xY8ZvvvnmpY8rTxbCJ/JkIYRwGPJke6KbJ2/YsKFMmTIX
Llx4ob1GjBiRP3/+F93LE3myED6RJwshhMOQJ9sT3Tx59OjRH3744Qvtcu3a
tbRp0w4fPvxVjitPFsIn8mQhhHAY8mR7opUnP3nypHPnzi866aJ///5BQUGX
L19+lUPLk4XwiTxZCCEchjzZnpfw5Fu3bh38h7///tssDA0NPXz4sFl48uRJ
z+1tVnly7ty5Pn36vPnmm+3bt3/w4EEkg2GvLFmyDBs2zGu5FVgkkScL4RN5
shBCOAx5sj0v5MnPnz+fN29etWrV3nnnnS+//DIgIKBr164u95uKv/rqq8SJ
E1etWrVnz57ZsmXr3Lnz9evXWXXmzJlmzZo1b9586tSpuXPnzps3L4V4Ffvo
0aMBAwbkz58/rpuUKVOyOwsjExJhZMqUyfP9GDdv3uzWrVvBggX79et35cqV
ZcuWRab35clC+ESeLIQQDkOebM8LefK5c+cSJUrUtGnT+/fvh4SEFClSBCNl
+Y4dO5InT46RPnz4EGfma6xYsXr06MGq7du3p0+fHnfl8/Lly8N6Mj5MH6HW
u3btCg4O/uyzz27fvl2uXDlU+dmzZz7jwb29XnPRv3//AgUKdOnSJXv27ESL
vR8+fNhn1eTJQvhEniyEEA5DnmzPC3lyhw4dAgMDDx48aL5evXr12rVrfKhT
p07GjBmtO8BPnjxp2LAh5ozH4sk4c7t27RYvXrx69epJkyZ5lfnVV18FBASs
WbPmzp07NWvWnDJlCguHDRtGgY8fP7aPZ9SoUcjwrVu3PBcuWLDg1KlTfMCf
CxcuPHbs2NDQUJ9VkycL4RN5shBCOAx5sj0v5MmNGzfGk8M+MVe2bFlPT4Y2
bdqgxydPnsR++ZwmTRqOkiRJEiTWc8eQkJAsWbJUq1bt3r17hw4dwlRv377N
8jJlyliejGBT/sSJE71uL1+5ciUoKCiidyZTTpMmTS5duhSZernkyUJEAnmy
EEI4DHmyPVHhyaGhoTiq8WRc9/79+/v27Zs7d26BAgUSJ068Zs0aa8dz587F
jh07ODiYz3hy9uzZ8dUHDx4UK1aMjZ88ecJyLDpu3LjJkiX766+/PA86evTo
fPnyhWvCy5YtGzBgwC+//BL5djCe3KBBg8jvIsT/GvJkIYRwGPJke17Ik7//
/nuUddasWdaSjRs3Xr9+netmokSJVq1aZRbu378fSS5TpszNmzd37NjRokWL
p0+fsnzlypUca/LkydbuqG/8+PGbNm36/PnzkSNHTpw4Edlu3bo11k0hZhts
eezYsTFixOjSpYu1IyWnS5cOVQ4b5OLFi8uVK3f+/HmzmaeW22A8eciQIZHZ
WIj/TeTJQgjhMOTJ9ryQJ6PERYoUQYBXr16Nf7JXpUqVQkJCTp8+nTVr1uTJ
k2PCP//8MxuULFly7ty5LvdzfCxHre/fvz9s2LDEiROvW7fOKvDZs2dTp05l
A1YVKFDgk08+adWqFUUNGjTI87iHDh3Ck9n37NmzZsngwYNz5MhhZNiTZcuW
JUmSJDAwcPjw4Rz0o48+mjNnTmSqpnkXQvhEniyEEA5DnmzPi74/+dKlS1Om
TKldu3adOnVq1aplvQ8Zgx0yZEj9+vVr1KjRuHHjq1evmuVHjhypWLFi5cqV
O3XqxKrFixd7Ffj8+fMZM2YUKlSIMHLmzDlw4ECs22ubR48effjhh2+88UbH
jh1NDJkyZRo6dKjXZufOnWvduvWOHTsmT54cP358bBkJ9/nSDIM8WQifyJOF
EMJhyJPtiSa/x7d69eoMGTJYt4vDsnnz5njx4uHb169f79atW6tWrezfhrFh
w4b169dHPgB5shA+kScLIYTDkCfbE008uW3btn369LHZ4OHDh8HBwQEBAaVK
lUqePPnOnTv9G4A8WQifyJOFEMJhyJPtiSaeXKRIEZ+vp7h3717WrFmJtnHj
xubBQD9iPHngwIH+LVYIJyFPFkIIhyFPtieaePK5c+fu37/vc7PJkycnSZJk
06ZNfg/AeHKTJk38XrIQjkGeLIQQDkOebE808eRIcvXq1d27d0dFyZp3IYRP
5MlCCOEw5Mn2/Lc8OeownvzRRx+97kCEiL7Ik4UQwmHIk+2RJxvw5FSpUu3a
tet1ByJE9EWeLIQQDkOebI882WA8eebMma87ECGiL/JkIYRwGPJke+TJBs1P
FsIn8mQhhHAY8mR7tm7dGhgYKE+WJwvhE3myEEI4DHmyPUePHs2YMaM8WZ4s
hE/kyUII4TDkyfZo3oVBniyET+TJQgjhMOTJ9siTDfJkIXwiTxZCCIchT7ZH
nmwwnvzpp5++7kCEiL7Ik4UQwmHIk+2RJxuMJ3/xxRevOxAhoi/yZCGEcBjy
ZHvkyQbaIUGCBMOHD3/dgQgRfZEnCyGEw5An2yNPNly8eDFFihSzZs163YEI
EX2RJwshhMOQJ9sjTzboOT4hfCJPFkIIhxENPfnXX38lqrpu2rRp89NPP1mr
QkNDe/bsyfIGDRps27btXwjGMZ587ty5k+Fx6tQpWtXn7t99912cOHGi1TgR
IrohTxZCCIcRDT352bNnBw4cSJcuXfLkyZFhvnquRdiCgoJmzZrltTyKcIYn
r127lsZEdJN7kCRJklixYiVMmHDatGk+S1izZg1b/vHHH/9CtEL8R5EnCyGE
w4iGnmwoUqRIzJgxsWLPhaGhoe3atevdu/e/FoZfPDkkJGTKlCn79u179XgO
Hjx4586dF91r5MiRWbJkGTJkyFUPKIrenz17dmQKNPMu6tat+1JRC/E/gTxZ
CCEcRnT2ZAKbOHGi58KxY8dmzpz51KlT/1oYfvHk/v37++XqefPmzdy5c588
efJF9woKCurTp8+rHHrv3r2JEyfW/GQhbJAnCyGEw/gPefLVq1cLFiy4YcOG
fzMMv3jygQMHypcvf+LEiVcMhhZInjz5i3ryiBEj0qdPf+HChVc5dM+ePWkH
ebIQNsiThRDCYURbTx4+fLinJ4eGhuJ7LVq0ePDggc99nz9/vmzZsgkTJrx6
GNFqfvKUKVNq1qz5QvMujh07ljt37n79+r3ioeXJQvhEniyEEA4j2nrymjVr
CGz8+PHm644dO4KCgm7fvh2Zfa9cuZIqVaqxY8e+ehgv4cnPnj17/Pgxru65
8OnTp15fzRL8/8mTJ5Epli1btmzZpUuXyEcCderUoSmuXbv2QnuFhbwjMDBw
2LBhr1iOEA5GniyEEA4jmntytmzZcOOLFy/WqlXL8wVxNmzevLlBgwaxYsVa
uHBh2LV79uzZu3cvH9atW7d8+XKfL814UU8+cOBAjx49MmfO/OWXX+KW5pVr
HCs4OJhVZptNmzY1bNiwadOmCxYsePfddwsVKsSHR48e2RT722+/VatWLUGC
BNWrV9+6dWskgwkJCaHw4cOHe0r7n3/++eOPP966dSuShRjIUxInTrx///4X
2kuI/ynkyUII4TCiuScnS5bsxo0bY8eOjfwvwdWsWfP/uUmaNOk7YUiVKlXq
1Kn5kDBhwtixY5cvX97+XusLeTJeiti3bdsWlZ07d27KlCnNDfBmzZp5Xj27
d+9OGG+88Ubz5s3ZsmXLllj9gAEDwi3z+PHjVapUKVWqFMbLZsWKFUubNi0G
Hpl4pkyZkiVLlsuXL1tLtm/fnjFjRoKpX7/+okWLqH4ki+rZsycBy5OFsEGe
LIQQDiPaevKVK1eKFCmSOHHiCRMmvPvuu1evXo3kjkuWLEmUKFHMmDHHjRv3
oy/Y+OHDhzalvZAn//XXX/Hjxx84cOCZM2f+/vvv9u3b3717l+V//PEHkul5
9WzTpg3Sa57IO3fuXJw4cYKDg8MWiCTnyZOnQoUKt27d2rRpU8eOHR8/foxR
kz5s3rzZPpi1a9fSesOHD/dc2KFDh88++4yKY91vvvlm7969I/MjIy55shCR
QJ4shBAOI9p6suufO8OBgYHTp09/oR2XLl2aJEmSMWPGvHoML+TJd+7cqVGj
RkBAAApar149TNUsf2lP/vjjj2PHjo3W8rlWrVqTJ0/mw6JFiwhp3rx5Lvek
5f1uvHZ88uRJ/fr1s2fPfvr0ac/lT58+ffbsGXvh8F988UXkf6ulX79+MWLE
kCcLYYM8WQghHEb09+RWrVq96E/vPX/+HFX+5JNPXj2GF52ffOPGjU6dOiVP
nhwxTpUqlXmL3ct58pUrV4oXL166dGkzeaNJkybr16+nar169SKk+fPno7vd
unUjI8iRI8eRI0c89928eXOiRInCfWfyzp07P/vsMyT58ePHkW+HVatWJUiQ
QJ4shA3yZCGEcBjR3JOLFi360r8q4jkv96V5IU/miAMHDsQ/T5w4gajHiBHD
vJ7i5Tz56NGjqVOnJk2gwO3bt5coUQJJpjXSpElTr169W7duPXz4cOTIkSab
6N69u/VKDZY3bNiwdu3aYZ8NxLTLlSvXt29fVt27dy/yL1XWvAshfCJPFkII
hxGdPXn37t1//fXX643hRecnJ0mSxPw+9fXr18uWLWuumF6ejPfWr18/MvMu
OnfuHBgYiJ3Onj07T548mHPhwoWzZ8++Z88ea5utW7cmSJAgRYoU1kvzOFzC
hAk3btzoVRqSjGOj7gfdtGzZcurUqZFsh9WrV+t+shD2yJOFEMJhRGdPjg68
kCdfvHgxXbp0RYsWbd26daNGjXLlyoW7YsXoLoWUKlXq0qVLbDZo0KAYboYP
H3769OnGjRvHjBkT+w07ofru3bsYNeUkT54cE0a869SpE/aVbvXq1cO0TSeG
hobWrVu3QYMGXj/IQhhlypShEMTbHJ0jHj58OJLt0KtXL91PFsIeebIQQjgM
ebI9L+TJz58/v3PnzsaNG7t27cq10vxw3pEjRz7//POubpYsWcKSadOmma8z
Z848d+5c138wj+l5gSrjvThqmzZtsO5wX7O8Z8+egIAA81qMP/74A6levXq1
1zYo8bhx4whp8eLFVatWbdasmbnvHUk070IIn8iThRDCYciT7YkOv1v93Xff
lSpVyuYHu588edKoUaOYMWNOnDixdOnSNWrUsH/bG+4dyR8BtDCerHEihA3y
ZCGEcBjyZHuiiSdXrlzZfptdu3YFBgYSavz48cPeTH51xo8f/+abby5dutTv
JQvhGOTJQgjhMOTJ9kQHT164cOHcuXPtt3n8+HFwcDChVq1aNSpiuHDhQooU
KTTvQggb5MlCCOEw5Mn2RAdPjuTro7dv354uXbqwr7nwC71799bvjAhhjzxZ
CCEchjzZnujgyZHn6tWrLzrxOJLoOT4hfCJPFkIIhyFPtue/5clRhzxZCJ/I
k4UQwmHIk+2RJxvkyUL4RJ4shBAOQ55sjzzZIE8WwifyZCGEcBjyZHvkyQZ5
shA+kScLIYTDkCfbI082yJOF8Ik8WQghHIY82R55skGeLIRP5MlCCOEw5Mn2
yJMN8mQhfCJPFkIIhyFPtkeebJAnC+ETebIQQjgMebI98mSDPFkIn8iThRDC
YciT7ZEnG+TJQvhEniyEEA5DnmyPPNkgTxbCJ/JkIYRwGPJke6Lak58+fXrz
9fH48eNIxilPFsIn8mQhhHAY8mR7otqTd+7cmSxZshSvidmzZ0cyTnmyED6R
JwshhMOQJ9sTpZ58+fLl8uXLV6xY8eDBg0dfB7du3YpkqPJkIXwiTxZCCIch
T7YnSj15/PjxuXLl+vvvv6OicP8iTxbCJ/JkIYRwGPJke6LOk2/dupU5c+bR
o0ebrw8ePLh06dKMGTPu37/v92O9OvJkIXwiTxZCCIchT7Yn6jx5zJgxuXLl
Onv2LJ83b97crFmzwMDAWLFiTZ8+3e/HenXkyUL4RJ4shBAOQ55sTxR58o0b
NzJmzDho0CDz9fbt2+fPn2/SpAnHmjx5sn+P5RfkyUL4RJ4shBAOQ55sTxR5
8uDBg7NmzXrx4kXPhatXr5YnC/HfRZ4shBAOQ55sT1R48vnz54OCglBlr+VR
6sn37t07ceKEmeYB165de6Hd5clC+ESeLIQQDkOebE9UePKwYcPSpUt38+ZN
r+VR58nPnj0LDg6OEydOqlSpOnbs2Llz51atWr1QCfJkIXwiTxZCCIchT7bn
pT35xo0bU6dO3bZtm9fyCxcu5MuXb8yYMWF3iYwnP3/+/EUjgdDQ0Pfee2/I
kCETJkwoUKBAzJgxwwZmjzxZCJ/Ik4UQwmHIk+15OU++du1ajRo1EMs6dep4
vedt/Pjx2bJlu379eti9fHry9u3bixQp0qBBgxUrVrRr1+6nn37iA8o9atQo
PvTu3ZsSIto3JCSEf9euXYswU86jR49eqEbyZCF8Ik8WQgiHIU+25+U8GQ2m
SVOkSBEQELBx40bP5Tlz5gz3ZrIrEp48ePDggrZ069bNJqo1a9ZUq1bt5MmT
L1QXgzxZCJ/Ik4UQwmHIk+15lfnJ3bt3xy3r1q1rLZkwYUKePHkuXLgQ7vZR
Nz/5/v37VKRKlSqnT5/m65UrV54+ffpCJciThfCJPFkIIRyGPNmeV/Hky5cv
J02aNG/evOfPn+frnTt3MmbMOHTo0Ii2X7lyZVR48oMHDxo2bBgnTpxVq1Y9
fvyYo6RNm/bQoUMvVIg8WQifyJOFEMJhyJPteRVPfv78+YABA9h9/PjxfB0+
fHi2bNmsN7N58vTp02XLlhUqVIiNW7Vq9eOPP967d+9VQ/+HtWvXBgYG5s+f
P1WqVJkyZUqWLNngwYOfPHnyQoXIk4XwiTxZCCEchjzZnld8L9z58+fTpUsX
P378QYMGZcmSBW0Od7Ply5dXqFCh9D+UL1/e6ydIXoWJEydu2LDh0qVL8+fP
p/CvvvoqNDT0RQuRJwvhE3myEEI4DHmyPa/oyc+fPx84cOD/c9OsWbMXfctE
9EGeLIRP5MlCCOEw5Mn2vPrvjJw4cSJLlixJkiTZsmWLHwP7l5EnC+ETebIQ
QjgMebI9fvk9vhEjRuCZLzHbIfogTxbCJ/JkIYRwGPJke6Lid6v/i8iThfCJ
PFkIIRyGPNkeebJBniyET+TJQgjhMOTJ9siTDfJkIXwiTxZCCIchT7ZHnmyQ
JwvhE3myEEI4DHmyPcaTW7VqtfAfzI/r/S/w/PnzVatWmVrXrl1bniyEPfJk
IYRwGPJke4wnezJ37tzXHdS/xLx58+LEiWNVXJ4shD3yZCGEcBjyZHtCQkLm
/1/OnTv3uoP6lzh27JhnxX/44Ydbt2697qCEiL7Ik4UQwmHIk4UQwi/Ik4UQ
wmHIk4UQwi/Ik4UQwmHIk4UQwi/Ik4UQwmHIk4UQwi/Ik4UQwmHIk4UQwi/I
k4UQwmHIk4UQwi/Ik4UQwmHIk4UQwi/Ik4UQwmHIk4UQwi/Ik4UQwmHIk4UQ
wi/Ik4UQwmH8Jzz50aNHU6ZM6du375AhQ/j39OnToaGh169fX7NmzesO7V/i
2bNn33333dChQ+/evfu6Y3kZHj9+/PTp09cdxWvmyZMn9+/fHzNmzOHDh193
LHZwuk2bNm348OEE/Lpj+Y8hTxZCCIcR/T350KFD+fPnT5s2bYcOHU6ePNm+
ffucOXO2aNEic+bMqOPrju5f4sSJE1mzZo0XL96iRYtedywvQ5MmTbp37052
87oD8QOkKpwv27dvf9EdlyxZkiVLloCAgM6dO0dFYH6BjKx8+fKxY8dOkyYN
Vh92g9WrVy9cuDDyWc+xY8fWrVvnzxCjMfJkIYRwGNHck/fu3ZsjRw6s+OjR
o9bCn3/+OXny5MmSJbt582ZUHPTgwYNFixaNOgk/ffp0uXLlDhw4YLPN2rVr
ixQp8uuvv1pLqlevniJFitu3b0dRVDZs3ry5QoUKN27ciMzGZ86cqVy58v79
+60lx48fJ6kpUaLEgwcPoizGV4VM5L333otMhKdOnSJhGT58+IseAgXt378/
p9tvv/32UjH+S0yePJkgS5cu/ejRo7BrK1WqVKZMmXBXhYWcIl++fDVr1vR3
jK4jR45Uq1YtkmH8a8iThRDCYURnT96zZ09QUFBwcPC9e/e8VnHlxZ/v3LkT
Fcdt27ZtrFixJk2aFBWFw+effx4QEDBkyBCbbTg6/TJv3jzz9f79+6h1rly5
Xsu8i4YNGyZIkCAkJCQyG3/99ddEvmXLFs+F27dvP3fuXNRE5x+6dOny1ltv
RaZ56YtVq1a9xJyE58+f0+nx48f3apzoxvLly+nBmTNnhrt227Zt58+fj2RR
oaGhtNWOHTv+P3tvHSXF1T3Q/nAIAwwwuHtwCRBsCO5uwYLLQgMECM7C8rBA
0OC+YNDg7hAguHsguLtrv73qvNxVr0eYGRqY1Hf2H6zpknvPlab2qb5d7bno
/j8oNmnSpGEt81JPVhRFcRhh1pPPnDmTOnVqLoUB3jTGk8eNG/cp6sV/ChQo
kDx58hcvXnyK8jGHkiVL+vj4PHz4MIhjSBCSJUt2/Phx2bJx48Zw4cJ9OnUP
gosXLxJMMD0ZFRw4cKB/Tw7j0OHFihULpieHmkePHsWPH79s2bKfroqPhxFs
2rRphAgRTI4WNilevHiSJEnUkxVFUZRPSpj15AEDBhDYiBEjAtw7adKkHTt2
yN/v3r1bt27dmDFjxo4da3e58+fPs/HUqVMvX76cNm0af//999/2QjgRnRtj
ceHCBbYcO3asdevWESNGjBMnzu+//y7rM+/evTt16lT+PnfuHEfOmDEDrUIn
EAlemgUGN27csC8OcVk3HomTYxYsWMDxLkv+O3ToEClSpOjRo48cOTLARRTb
tm0bNWpUvHjxOKxr164E6bIWhdIbtWvXlmivXr3qdhaCJ3X532UHOZ88efLj
x4+xXw6eMmWK+eSainbu3MnGpUuXyhZinjNnTqdOnVD0KFGiDB48+N69e7Lr
7du3M2fO5GCa/Ndff4murFq1imO8vb0JdejQoXIkqs9hVOfW8wwf25ctW2bf
vmjRIoolVWEg2Dt37lzpt8DYv3//mjVrCOb+/fvjx4/ftGnTOwvSCl76z0TM
LpIvs8L2xIkT7du3p7fJBTZv3iwbKfDQoUMcw8QgEpOw0L1nz561R8XQSIHs
4sjDhw8HFi1Henl5ZcqUSQq0F0IH7tq1S8baZXk7YxFEw4GxYPj8f9Ry5cqV
WbNmud3ufmshPcAEM81kJjAf7POQA4gwUaJEv/76K+8OE5KJyr5FiqUh7GKq
uH1kQB8SoV1lzfFv/8V/uyjf7LXXZQ+DutKnTx8rVizaYj/LdCkv5W+ZDwGW
H2DhH4l6sqIoisMIs578zTff4C2rV68O+jDstGzZsgkSJKhQoUKuXLmKFy9+
8+ZNlyXJZcqUiRs3Llf8SpUqVatWjatq4cKFzcURsUE7CxUqVLly5QIFCnz3
3Xfswj3KlStHh1AOgs3F9M6dO507d8acuS43aNCAEmRJxh9//JE0aVLq/frr
r2X5R/Xq1evXr28u/YjrDz/8kC5dujx58kSNGhVv5MKNkNSoUYPys2fPjocE
+L02xCx37twcU7duXSP2mLOcRbQU6LbgE9tMZ8FeGhuYKuMt9EOECBHSpElD
XxUtWpR2yTWdXbVq1aI3OJ0eMzeuKZmUgapxp4EDB7569cplPbyiS5cuKVKk
oDpC5Q9JT7DWlClTcnDixIl//vlnl7VyplixYjFjxuRf4zCB1bV27dpo0aLR
vXR13rx58+fPj5wvXLgwsKHH2RgCJkmGDBmyZMnCNIgfPz5l0jmMJluqVKli
X1N9+/Zt2cUx7OUsWf69fv36fPnyEXbOnDkxTLbMnj07derUlMYxdBR/0Ldo
M06ePHlyWmfWri9ZsqRIkSKZM2fmeHZRSIsWLQJbkkHGwQHMGU5JmDAhE0C2
Uyw9SVdwrnTvTz/9RLfb13i7QTaRKlUqBoWqTa5BDw8bNixHjhx0Bf/u3r1b
tiOTWbNmpS0kkszhOnXqUDt6TCZYs2ZNuoJZYT61EU8mzowZM9JwYpbtTHIG
haiqVq0qW1auXJnBom3btmz09fWlGy9fvix7eSvR20w2apS79IQh3d6xY0fe
3aVLl6YKt9R1+/btBENvSMD87dbwFy9e9OnTR+YkQ0OPkQ2RyXIkx5s1WiSY
7dq142Debsw0/jeQ0zmY5tNAAuadLv9XeBD1ZEVRFIcRNj0ZdcF/uIx+8J7P
uHHjokePjgAgCcgDbRHvGjNmDJdvpChy5MhTp05lC1dVe4F79+6NHTu23LXj
b66nInIIMAXibHJYhw4dKBaRxt/OnTt3/PhxfIYCkQQ/Pz/cQFZQ7Nixw9vb
e+7cuXIWUtGoUSMux8eOHduyZYuXlxcliD7JneGJEycG0aiRI0dyjLlhDmgP
CioCvHjxYszT3BJEk0gHqOvo0aOEhxUE9jUxxKl3795kB+HChaMQFAXlw9Zw
JJqPlMqS1PHjx9MDNFDOokC0ypgGDB48GPOnIfz9/fff25dkNG/eHPeWXYAt
9+rVK1u2bGiPdC91kVDQh3IDn+Gjc1atWsW40GMtW7Yktq+++opQL168iPlg
y4F9to6rL126lNiwL44n6ejWrRv9Ri5z/fp1ymfXrl27zPFoMx5OdyGiSCZn
Yc6ya8qUKexavny5vKRSaUi8ePFwaWSYWYSC0kviuqK4f/31FzkLdQ0ZMoSN
RMuM4t/Avl4qd+YJAJcjiUubNq30GwkRfU5d5cuX5yXyRp+QxQS4/F5u8idJ
kmT06NEMN9NPzqL5w4cPZ0DpE/wQAU6WLNmlS5fovYYNG7IR6aVY9JjwOIuA
0XXSzF9++YW/aYuUTycw+uz6559/sFCsnoTRZWVqdCA5Ee8jl7U8iQgZL86V
JGLFihX8zZtFysGKv/32W4wXVZYSaD4tlXRvz549Bw4cIHW1P/qDpIZpzFnM
TJJTjpw0aVJgPckkYdrIS/77GjBgAOpLXadPnz579iwTjFYz0MRMOfxv4LLW
vTD5GUqmJT1DOoYqe/ausnqyoiiKwwibnjxr1iyi4ooZ4FWMy5+sFsBhMMYS
JUrIdvFkkeEzZ86gGXhy5syZ5WD/noy05MyZs0GDBhimbGQv4ke9pi5EAuvj
+ovYiLccPHhQCtm4caO5f4hK8bfxZCyUl7///ru8JE6z8KBp06ZIDuEF1vYn
T55gemib+fbT9u3b48SJgwlIhLVq1UqTJo0pEIWWvqpfvz7GYir1z507d/bv
38/xlC8uh94Q/LRp0ygB7ZR2Ea1RFIwLFUTR5U6yy1p4gGDgZsge51aqVAk3
u3v3ruxFLwnV3FSkY8k4sMeCBQuKJy9atIjCERV5uWDBAl4ib/yNmOGQDAoN
YcgkjDZt2gT2NDmCJ6nB/cSCCLV06dI4+bVr11zW3U52GU/eunUriQzO77Lm
D54sf7ss80TjkTdT8po1a0hDECqa47LcfuHChZzF0ONm+LOkOVRELXRaz549
CZW6kMPAno2Mk1NLsWLFyKroHySZxEQWKlAsf5Ds1KlTx2U9HgRTxegCLIcu
ol0VKlRwWW5MB0rGhDaTyiGucljHjh2ZtASDfC6yoExs3GXdU8WTmQbMbV7a
PZmuGDp0KEmQ5Gj2Xfv27eONwARDoV3WPFxswQEotMt6Co3dk0kBmMC8+3h7
yroOxqtfv34cI5+G0AlMjHr16snxzCWkmj6RFJVQCSPAxSdU/fXXX3/zzTdm
y+rVq6kLxy5ZsiR1YeCMkaz8IUvFmWVQyC8Y0x49esiHPrlz5+Z/D88+e0Q9
WVEUxWGEZU+eP39+gHt79eol6zFGjBjBYfiqbBdPxqzMYmAET+6RImzoHBJl
PBnf+/HHH2PEiMGlk8vuuXPnXNb6SUzAGJRw5MgRLrudO3d2CwObwjewCKqj
UuzXfFCeN29e2eU/eMwceQhi2S3OGStWLJzBHDN9+nTaJXfPsEEkOV++fOZ4
hCdevHioWp8+fTC3oBf00kxUpEmTJmYLfkLzKd/Pz0+2dO3aNXz48Mgzfy9d
upS/GzdubNaTIEWorPTGnj176BlsSnahgkg1vWqvEaWkBLk7Tecz33iJtrks
K8N2eGmWMZAL8HLkyJGuf71rypQpQTRn2LBhIqgu6x6+/VtyuAqiKE85RnHl
TqaEgQRiaHSXHImmJkiQAGuyl4y607TWrVvbNxI/cyN16tT2W9wIIaUhaUE/
BeLvv/82Hnv48GH6EHE1CQV9TrSytpnMi6old/CPrNu3f9bgsm5BkwYilua2
f7t27cST5WX//v2N8Yonm+UT7OJINNhl3XHFKulDeZvYz5I+YXSY9qbe3r17
kxbJdzY7dOjAXvv/JBMmTPjqq68webPF/h3Pn376iWaaFJX0MGnSpL6+vlRN
lkQyGNjNXkaTTM3+FnBZy+ApTeYehsybXeQcT86QIQOzl7OyZMlCL5m0ixFn
FILIK0OBerKiKIrDCJuejAZw/eVS6P9CeeHCBbYfOnTowYMHKVKkIHj5Lg+X
wo4dOyZMmJBdcuQff/xhmiYKPWfOHFQWM0Rp1q5dyynYMipIXWJQeAUlmM/f
hXr16tnvkRqKFCmCHRGhPJ7CfhcaGZZdbqcgS8Rcv379INq+adMmDAqjkJcE
ydWfqESi8EZ8oFWrVjRTlBhPDlq87eBp2Nro0aPNFnoD8UaczHLW7Nmzoxay
plRu/6LQtFECQKLwMbltiKBiGuYre8eOHcOU7AnFs2fPUJrvvvtObulTF5KJ
G8sXJJH25MmTY+nmKRMFCxZMlizZvXv3aA7K5O3tjZUF9qBpymzQoAElSI6D
fZFf9OjRw2XlGqQtFSpUkNvgotA0RBYkE7Cxa5elf7y06xzUqFHDy8vLvtrE
Zak7WVX16tXtX0CTZRLff/990D1PT6Kj4snkBfQbuZWZIUxduu7EiRP8TVZi
bjW7QSaCARKt26+cMBkokHGRs/755x9ZASK31jkL+yVnlMXAvLnoKBlu2UVS
JouCRKHlZjX+bz+LA/i/gl41X2l0WfkgM1++E5cxY0ZE1P69QlScETTf/STF
q127thTIiJcpU4YIr1+/LnvJv+gf+sFl3cCPGzduYE9dZu4xh3l32zc2bNiQ
RsmHLMWKFTOPwiCVplLCk7NMNsSRqVKlYjYG8diZUKCerCiK4jDCpidDzZo1
UUq3r6SdPXuWy6v8XDVX565duxpPPn36NJd4+aDcZd36K168OLKKMnGB5oKe
J08eTA8HePToEVdSHODgwYMuy3PYK9ogX5ejQF4i1VIUpwT4GDcjw/PmzUNR
JkyY0L59e7m5bfdkAkCixNBmzJghd4aJBFs2CmFHVBZDQ9c7dOhAvUhyyZIl
Xdbn7DizrOjIlSuXSKDdk/fu3WsEO0BwBqTO/vUlyixRogQloEwEjELjGHK/
l13kAjFjxly9enW3bt3klzWwOxwMd71z5065cuXQNppGKnHjxo0WLVqQUJBr
IPNykxkdSpAgQenSpQl72bJlFMigFChQQAaoZ8+eHG//hUE8maHhMPQJe69S
pUqfPn3kK4H+QeRixIhRq1YteYmfo5oi1WgkuQYnNm3alNmClpPFiCffv38f
PZM+7NSpE2GIJ7PrwIEDcheXZIrAaDhttNc4f/58WWZQqlQpyqEzMUxZyUz/
MK/atm1rnsDgRpcuXVBZBpcTmYp4IJPZ7DWezMZ48eLR9gCfwseEkS/ZiSfz
FmCiypNYmCTGk9evX49pm/yFoaE3ZFGHy7rxa241kyx89dVXJBfI+datW+2e
TN4hu+QsdhEzu8hc5NMcJgxuzODSh7xPebeSXPTr10/u0PLmYp4w2RhlvJ0t
jCkF1q1b12W9kSXdmzVrltzKxmOJWT5CQvuRXrcPJgzjxo2jBzZv3sxsl089
XNbic6qjb+ki3hriyURITi23r/FqahdP5s0yYMAAHN58huIp1JMVRVEcRpj1
ZBQFJcapjh49es6CS9t3331n/w1cNmbLlo0rb//+/TkSbzE2i0LI93RclpJh
1OgHL2UJ8ciRIxG8BQsWjBkzpmjRouZeotx08vX1RR3l5p7L8uR27dr5XyU7
adIk5AQrQGI5Sz7VFXeVXTgA13HMEPeTD+WXLFmCDOTPn59KRQ/8g5mgEJRZ
sWJFznr69ClFieRQOC7KeHG5x1rFjSdOnMgBVSzQ3cB+HkKgi5InT26WEwvy
oAl5jEb8+PFFkl2WTqA9GCNamCpVKjkLw0Ew0qVLR6OSJUuGgPE33csurANV
o5NxY8lBxJMpk41yr4+6xMOHDx/OLrskM9DsElPiYLyLMaUW9DXAtmCSqCyu
JS/xZAIT+WSSEBhhV6pUSe6pMsSRI0fG3qWN0oeyFFY8WeqSsHfu3MmWZs2a
mVXZgngyiQntJflixP/PAsVFgxHmX3/9NbAb+5cvX2YGkjExTMwBJrP9pjTZ
DVMIBZVvxmHdgY0g6RjTY+HChahy1apV0Wa5nf7TTz/R+Vg6kkzXEaF57Aae
jK/i8C4r92nUqBFjKrfK5SySI6LCYx8/fkwSweSkHFydws39XvFkZhqDLvdy
eSsRqvzNfyB0b6FChegc6UMklko5gLrkjjQpDKbKW8n1ryczG3n/Sor68uVL
ziWd4SUzynz7zz/iyYMHDyYbNU/h452FJ+/fv19+TJCpRXUjRowg3ZYDZM0M
Q0bVlMAc8Lgku9STFUVRHEeY9WSXdScWG0yaNKmPj0/27Nm5mvtf8YsksB3d
RRvs6xzQFTTVLBnlmjtq1KjZs2ebY1C1sWPHcqL9t6Hl81mOtF+jly9fHthH
/8uWLaOEzZs3+z+LXWMt5KteJirsgiODeOTXs2fPcCGOkeARmylTppi7i4cO
HWIXwmb3saVLl7KRugK8QW0HEwvQz9HIURZuX2vCpmS7/ayNGzeyhXZdvXqV
zidTkE/bqZ2X7DIPIkDVsFC2yNMtTF3S8+axGPZd5i4rc5ITg/h17+fPn5OP
mMwIuTUr1dlVr169ggULiiS7/n1MBJJMPH/++ac4rew6fvw4Dom/mRUFyCFV
i+/ZITa2k4mI4lJg+fLl2YKPkUfIsuogYKYxmfPmzUvT3HQaSyQDQkSx5XDh
wvXt2zewQpgPHTt25EhkEt8z6xxISdBOtpOsmQgFeY63rNeVJxOuWLHCfhbp
p/FhJhgJJj5pf7a2y8rRSBzIRFB6s/6f5osDy6cD7KUnTUZJGGSj5sEpzFLS
BAmDUStbtizRmhvCLutNSr3oLv8jkasG9jvpuHHatGk5curUqaaZDx48oED+
oyDfYUTkyXukRfJdRYHJTOdwDJLstszGU6gnK4qiOIyw7MmCfJYa4E9yKEpg
vHjxwv+P65nv3yHwdpN8YxGKWkyB9h8uCQIO8x8V/owuynOAUVYEz229hxso
K+8I/wuBaDLbP/hj7m4/NMlLtx8roeQA325oM+XbO8r+fUa6lL32O/DIs/0R
edi1vWrsnePd1vBT7969e/1/g9KNACOUAqV7aRH/b/i/t0/ncEyAuzyCerKi
KIrDCPuerCjOpnr16rFixbp9+/bEiRMTJUr0wV8hdB6HDx9es2aNWPSyZcui
Ro0qz5r7z6GerCiK4jDUkxXly9KuXbtIkSIVLlw4ceLE5tuj/1N069YtYsSI
9MPixYuTJk06aNCg0N3e/+KoJyuKojgM9WRF+bI8fvx41qxZM2bMMOur/9d4
9uxZkyZNypYtO3PmzCVLlvx3b6erJyuKojgM9WRFUb44b968cXu6yH8R9WRF
URSHoZ6sKIriEdSTFUVRHIZ6sqIoikdQT1YURXEY6smKoigeQT1ZURTFYagn
K4qieAT1ZEVRFIehnqwoiuIR1JMVRVEchnqyoiiKR1BPVhRFcRjqyYqiKB5B
PVlRFMVhqCcriqJ4BPVkRVEUh6GerCiK4hHUkxVFURyGerKiKIpHUE9WFEVx
GOrJiqIoHkE9WVEUxWGoJyuKongE9WRFURSHoZ6sKIriEdSTFUVRHIZ6sqIo
ikdQT1YURXEY6snCs2fPli1bVqBAgY0bN37pWP57XLt2bf369bNmzSpUqNDK
lStfvHjxpSMKcxw5coQuOnny5BcPY8uWLW/evPmyYTgV9WRFURSH8V/05HXr
1rVs2fL9+/ceLPPp06fly5ePECHCihUrPFhsENy/f//169fBPJjwzp8/b99y
7NixGjVqnD59+hOEFjIuX75MflGuXLnVq1eXKVMmfPjwvXr1Cl1Rz58/P3fu
nGfDA6bK7du3g3/8rVu3PBvAxYsXfX19w4ULx7z1bMkhYsyYMenSpYsSJcrH
v9+Zug0bNmTQq1Sp0rlz5y5duvA/STmLmTNneiRaA8M3f/78HTt2eLbYT4F6
sqIoisP4L3pyiRIlELN37955tthWrVpFjBjxU3iaf/DekiVLDh06NJjHM0xZ
smSxpwZLlixJkSLFqlWrPk2AweXu3bu5c+eOFi3aiRMneLlmzRqiWrBgQehK
27BhQ9q0aYOfPgSTefPmEeS1a9eCc/D+/ftz5Mhx8OBBz8bAvIoUKZIHPfnO
nTutW7cO+p1LMkWNu3fvlpfMn6pVq3p7e3PuR9b+4MGDJEmS5MyZ08/P7+3b
t5RMJ/M/CRv//PPPjyzcjRcvXiRPnrxChQqeLfZToJ6sKIriMP6LnoxkPnny
xOPFYhTffPPNxytEcFi+fHn06NFHjhwZnINRUPQjW7Zsdk/m78ePH3+yAIPL
xYsXo0SJ8sMPP5i0hahCfau/ePHiqVKl8qwnP3r0iGLJgI4fPx6c4/G9cOHC
kYZ4MAaYMWMG2cSsWbM8VeCZM2cQb5K7II5ZsWIF726qNluqVKkSJ04cspuP
rP3XX3/NmDHj2bNn5eWbN29ILui3yZMnf2TJ/qHw/v37m7rCMurJiqIoDuO/
6MmfgvPnz8eOHfvHH3/8PNXh5EiO21KKwJg+fTpj5EHF8iArV66kIU2bNv34
oq5du/b111973JMvXLgQOXLk77//PjjFcsw3FuRiHowBqlevHitWLA9mYc2b
N48ZMya2HNgBZC6+vr7e3t5btmyRLfv27SM769Onz8d/FjNkyJBffvlF/sZj
e/ToIZ0cFnK3L4h6sqIoisMIs57MBXfFihXfffdd9+7dza0knKdixYqbNm0y
h82dO3fevHn37t1jV4UKFZo0afLw4cN//vlnxIgRhQsXti82lgJHjx7NXtrL
3mnTppk7nydPnowSJcqwYcPM8ew6ePBg7dq1a9SocfPmzcDipLSRI0euWrXq
r7/+at++fYkSJQ4fPiy73r59u3///qlTp9avX//QoUNSF1uoOlGiROHChcuT
J8+RI0dMUUuWLGEXEVKULP949epVv3790qdPzxhlyZJl+fLlLmthMweYWkxd
e/furVq1KnXZd7148WKvxY0bNxYsWFClSpU9e/a4fY2LGBo0aFC5cmX7rosX
L9KHbAlijNasWRM/fnxiS5gwYWGLcuXKmcEieOolVKpetmxZ+fLl7buwNQZ3
6dKljx49olK5P0lRUaNGZRQC+6LZ5cuX/7JB+RTlf5fRUYa1WbNmdDUdvnXr
VlOO9KEp5Pnz5y5rdmE4BIB/zp49214vu+TgD/pzgGE8efKkaNGiXl5e69at
YztNtp/CWMvxdullSrPFPj1Onz4tBcquIkWKRIwYsWPHjgF+a/LSpUu7d+8m
6aDSSZMmydzbvn07PcwpUp1bGC5LrQ8cOBDgLjeuXr0qPf/y5cuff/6ZXIl3
Cm+9oM+yt+sfC7OdLIntz549o0BGxOz6+++/0Xu3HOfo0aMcbN5TYQf1ZEVR
FIcRZj158eLFmTNnJrCGDRsmS5bs1KlTXGFLlSpVt25drAyDlW/3ZMiQAbHB
0CpVqjRhwoScOXNiX99++22dOnV69OhhXy3ZtGlTzo0QIQJ2OmPGjAEDBqAQ
5uP1Xr16+fj4mAs9ddWrVw8JxN/QNuxXVMoNdK5Ro0be3t6YWLp06caMGYMw
pEmThqs8u4YPH04JY8eOlbr++OMPTkG5KZDjy5Yti+Sb75dhkrgc9li9enWC
5F+X9RSOmTNnUj5tZNf58+cxGbw9duzYFIhkmjCGDh0aN25cNLV///4xYsSg
NNe/DsNLCixQoACXbypFAo3204fEQB/639WiRQuCRDKDGKONGzfmy5eP2H7/
/XfKyZ49OxUNHDjQ9a/hp0iRApfLnz8/04wwsmbNSntlV6tWrRhcDkDRMT0/
Pz/6ilSFgBcuXEjk/qtDswsWLEiBBEZdOD+9LU7CLvII4qeiaNGiMU+khA0b
NjAZwocPTwZhPPnBgwdkW0Q+atQoSiDmY8eOsR31YtrwduAUUipxMGLr27cv
c4ZQ48WL165du8B6g3YRTKZMmagrW7ZsBDl9+nTZtWPHDopl1Bg7OoE5Y84i
E0mePHnixInp6pQpU5pvq02cOJHj6TQ6lkjIfZgesoICFSceCmQLWViATssb
hAnPMfQqc5s0ymV9iiFh0Ba2k1TaT8HDaT6zl70EE5w76jS5W7dujEjNmjU/
qNZM3VmzZpUsWZLyEyRIQPbXunVrl3UPn3eZr68vb8DSpUuT7TJeX3/99fXr
10nWUqdOTfkmgaUrmB78DyDDQQrg8e8pfAzqyYqiKA4jbHryoUOHcON58+Zh
p+PHj8d+cYOrV68OGTJEXHfNmjWIUOPGjbloJk2alIupKC56w0WWU1BH5Idd
pmko1ogRIzi3TZs2vNy7dy8mYz475uqMdci1nmsx4oducRXGFriI43IBmtuZ
M2fwCjyEPsSmOB3bRAtv3bo1cuTIWLFiia8iYNSFvMmy6hMnThBG165dTTkr
V67EXvBqqqaliLFZ50kAWAHFirbRLpwEeaaZBCbH0C6pi714F3XhG9S1ZcuW
vHnz0ktUh3dRwsmTJ+PEiWNk+O7du8gGEkI///333/S5edQDPUxvf3CdwPff
f0+BYvsESWn37993WR/xI4Rz5sz56quvsHc8jZlGG8kg6HPGi6oxHIwU0XJZ
ssRG3FWMLkDQSwSbKmQC4FHoJep46dIl6kIpyZs4HROLHj269DzQXWQQN27c
MP3JWKPHO3fuJFRmReTIkeVLiC5rOQFDaX+0QocOHehqeo/+REqLFSsWWHh4
OIFh748fP16+fDnlTJs2TXZt2rSJQWFKMECLFi3CEg8cOOCy7ovie0w8gqEH
MmbMmCtXLo7BP0leyH0opFatWrg6SRZhmLvcmzdvZpf94w//MIc5ZtWqVcYk
6W26grqYzBRownBZiQZpKRPv2rVrZGc0k3dfEIWbdklOF5zvCzBpeU/98MMP
1E6ewt+SOZICMMPXrVvHUBIws4V0iTcRuSrCWb58eQaLpFUKYaYRNrknhTAf
mHvB/Hrm50E9WVEUxWGETU/+888/uaBzEUybNi12IR/CcrnnKpkkSRJfX1+x
Vi7oWAfxT5gwQU4sUqRIunTp5KrNVdjeNJQP/eayLouQ7Z6MROXIkQMtERfl
MOyOvVy+qQ7PDOzeGlaGcxIhFW3fvt1lre7A2FG47NmzlyhRQj4TF09G3sTW
Zs2aRevQfimEVlSuXJkDZL1E586dMTezdHnXrl3YixQuUAXyQAogRkpd2bJl
wx5F8sWTvby8CAzdoseaN2+OaaDBLmtRKz5pPJk+iRkzZtSoURFUJBPlCNEH
2ZyOevXu3VvOKlOmTPz48WWFKtZH1bSFYBAzttAtNJ9BXLt2bcSIEVOmTEk6
Q6IhH9+LJxcoUCCI6h48eEAJVMEocxaV0hAKHD16tOQpEgY5Ai+7dOnisrQq
T548ZhdQO+3F06iRlAR1x8FkmQeDxd8EZjqf8OhnSmvWrFnTpk2R2CCeg0G9
9C0Cz98DBgygZDNqpEj4MD1AGBggBU6fPp3ICdJ8z45dmCojJbaPVWKh7P3t
t9/kLPYyVaRAppypKzDwZII3KYDcmyWvEW0m4+D9ZTICkgvqYtqPGzeue/fu
LVq0CPADFDsXLlzgXcP8QXGDPtJlLXQpVKgQPS/xkE3QP5iwy1oiwqDwB29V
Yli8eDH5qazGJ886d+4cURlP7tmzJ5Nn8ODBpJb8t4DM6/1kRVEU5dMRNj3Z
Zd1iRd7CWcgdYBg7diwOaV91vHTpUnv8mAwKJFI0fPhwLuL2xcw0Fuc8deqU
6//vyRs3bqQQvEIOE63NmDHj1q1b8aKgP1BGsdq3b1+sWDG7S8utPLcC8Rwx
WyzXx8fHFIsn4A+VKlUSqXb7il+3bt2MQgu0CA2mRrG79evXy1IBkSjx5KxZ
s0pd6DEKXb9+fcSSGosWLWp2uSzPHzVqVLRo0SiBjjXrBIIJDk9d8nS73bt3
09vonN2v8EAOOHr0qP0sTKlgwYLhw4enUnxJZIk4EyVK9MEHylEUftW2bVv7
RuyaJqCX8hJfpS1IuMtKuKiFmWAORnepGhV0/fsVP3IH2XXr1i3kE5M0ByNs
nE5vT5w4kZmAagYWGKNAHpQmTRoGhemXJUsWEiWzl5lsdjENxJMZEeQ5Z86c
8lGI7CIAkUaX9dW/ZMmSkQfJLqTUXiApZBA/F8JsZKCZaWaLPLdNFhrhlpky
ZaJqs5f5g44yPYoXL073fvD+MPOT03k3mSEjKahbt25gx9N7zIQMGTKQW9Fe
JoDxZIHeIIZvvvnGbZEz85/B5R0kL0+ePMk0E6UnXQoLzw+3o56sKIriMMKg
JyMGI0eOfPnyJdd6Lu5YCjblsoy0VatWcn9SpJTLfeXKldOnTy/3Zjdv3hwr
ViyxaAyQ7Xnz5n39+rXRQhQ6bty4ciGm4Qik/D5avXr16IQ+ffrIqgPRWrMk
I2ju3r2LLVSrVs2+UW5pGk8W9cW1XNanzPHjx0fCURHkEKsUT27cuLHLWnqa
MmVK2nvz5k123b59myMpHx+4cuWKRL548WJ5/MXZs2dppniyFO6y1hVTl1m2
cfz4cbSwU6dOLktladeQIUMQ5lcWpAxURL+NGzeOritZsmSIHrhHkoJnTpky
xWX9+Ivc2Ccq8Tc6Ey+iTPszEGjyP//8Q9NWrVrVrl07ThEtRGX5G63lXDNe
/uncuTPNkeXEBjw5derU8lWvAwcOMKxoqmQNf/zxB70xbdo0uk5uXOPJUaJE
EePt3bs3swvBk3Uj9BUviUpWobj+9eTffvvtg12BpXOkyDDxp0uXznjyjh07
cEJZts0u/DZVqlQMNNkZyufr6yuH0Q9IcqlSpUyZRoZl1+jRo4lTngdI4bQ6
iDUqDDG5mN2TSYhwyw0bNvD36tWrKZBZavbiqMQczN/poxVIO+2tWbOm2Th1
6tQyZcoEdgruzfHyAzTbtm3jb5Jf+7fzSBJJClBf+1n8J8AbPEmSJPIJiHxI
wUxjDtOHpsCwg3qyoiiKwwiDnoy94ELyATcCHCdOHPmFL0SRC33OnDkRs5Ur
V7psMiwnImlIkXwKvGvXLk5ETlDuMWPGuKzP0FFQ8WSMMXny5D/99JN8aJsr
Vy7cFVWQ24y4FiolywlwEhy1X79+Aa5PdlnPxSUqt8cjiLuKJxMJAoDgiYQg
KuwaP348Po/G3Lhxw3gyB+DqqCyui7qTDrCLSBo2bEhIeBFWT8D169enQGyZ
JqANW7ZsMRJOXYkSJUKtTbT0AJ3Zs2dPl3V3l6ppY61atU6cODFixIiIESMS
mMvKQapXr26EEG1m+4MHD4IeKRyPLpW6OnbsSOFURGyE7bJu/WHR9kfG4TmI
X6FCheSlfO1x06ZN8jgITsegEGaTX7jBcKBb0aJFc/v1Z+PJREJ1ESJEMMNR
sGBBhAppJPWQ5ycbT8aE0VpMdcmSJT/88IN9F2OEiNInTDxKk+9LUjjh0WkB
xoaQ05kUSBgILYPI/Fm4cCFyLrsYL5clq/SJpGAUmCJFCvFkLFEW4pKzmDLF
kymQcZFb0MWLFydDxMkpnwLxVUQxwJ8anDt3LtMSdyVtGTBgANPY1OWyFrRT
F73EZBBZtXsy/wZxY18+g+D0woULmwU8mDzvrCB+871ChQpGa3/88Uf+xnW7
du1KCXQXc4C+Iknhb2Y4/x3Jo134T4DZy7zt0aMHk2ro0KFly5aVDGjfvn0M
zaBBgyQkuiKwd+jnRD1ZURTFYYRBT162bBn2gqdx0axcuXLr1q3FBPBbFAuT
yZw5szgP10ecUG6WcnFv0KABuiXXei6mXPdxP/6VFQ6y2jNGjBhcbdEqLtbm
kWLt27fnup80aVK57lMsJunt7c1VOGvWrMiP3IULkDZt2mBubk9CxsmxWVwX
w8HTOnToYG6dsYvaK1asWKpUqcuXL7usu3MFLDiMonAq2vj1118jcuzKnz8/
DsNL+Sk3LKJRo0ZEiyTTUagj7S1TpkydOnWoi41uP4iGn5ACSAd269YN60Cf
EG/KuXDhAjZYrFgx+hljoViz/BUbQVo++BPeYqHSjQSDvBE/HSvrXpo0aYL/
o2rmeCpljGg+NeLDiRMn7tu3L/HLrxNyeo0aNexhuIEpxYoViwPclqQSfIIE
CUiIaBcWSkeZkWXC4G8oGaFev37dZd32jB49OvXS24iWrHgR3WrWrBmdzy6C
kd+wQ1+zZMnCFCJgpgS1y7cO/cP4Mkw+Pj7UlTBhQtpSrVo1OoemsYtUjt4Y
NmwYcfbv31+mKNOMGYIJo3z0BvPN7BKYEhQ4ePBgRpACeS8wn2kaEstLrL5q
1aqTJ08OcIEuOSBjjV6WLl1669at8pN2crcWn6QtGTJk4I1Ts2ZNmZkcTy2k
ZhRIMiLvqQAhxYtiQfpAl9IKkWQaG8RPgZDBSTynTp2SW8HMMRp469Yt5J8R
kcU/hEH/03WyJEM8mTc1R/JmYXvs2LGZzOLqBC8fVRA22+nhL67K6smKoigO
Iwx6sjz6qbLF7Nmz7Rpw48YNRMv+UN+LFy+aBbFcNK9cuWJ2oXlc8eUDdJd1
9xJJnj59+owZMzBJ+zJa/sayuMqbb3tRERdiAtiyZYv9Ka/+4ULPif5/w4It
hw4dQl8xBLcn3B44cABBEkkW7t69yxCQGmDRuAFnmTW9165dQ7kJw9jjkydP
cFH7D8ZdvXqVSzPR9uzZ016s1DVv3jzziLM+ffpMnDjR3Aakc1AmTmzXrp19
dQTCJo8jC6Lh69atw23Kly9vEhN8lXaZIThx4gRd7WZxBE9WQo3US2xGaO/c
udO4cWN2BfFDFVSEpJkBNdAutBaJqlKlyrZt2+yavX37durC/UyTiWfKlCls
pA/lrF9++UXCINmR3pAvHgqMfpcuXdjIkUy8AB9WbK9L2tWiRQv+9vPzkz4k
KpnPDJNpsvQGPY/x1q5dm3G377KfRYRSoCy2l7N4KV8GDDAYpgGziGPkHi+z
kVpMAkX+1bx581atWplF8rSLyUM2QWJFLhDEl/iYQiQOJHoUSBgy6OnTp5dc
IzAw2AEDBqCy/IczadIkaZd8CNK7d+/K/0LWQLFm3TJnMRXJnuQ7BUeOHCGp
yZQp03fffcebxQRP1pwoUSJUOYgVO58H9WRFURSHEQY9+RORK1eujBkzhqlv
x/9HuXTpEmYuTxox355THIA89/uDh124cMH+Pnr79m0Q33AMEf6TIDeoiyzG
bYG6y3qARqdOnYK5vvrToZ6sKIriMP5HPHnVqlXylLn/8d/V9QjNmzfPnDlz
4cKFc+fOHfTNdkX5DOzZsydv3rxuq9a/COrJiqIoDuN/wZOfP3+eIUOGaNGi
ffXVV+anH5RQ07p1azoze/bsH7z7pyifgaJFi7Zt2zYs/Ia1erKiKIrD+F/w
ZJe13viqRXB+jVcJmgcPHtCT9offKsoX5Pbt20GsG/+cqCcriqI4jP8RT1YU
RfnUqCcriqI4DPVkRVEUj6CerCiK4jDUkxVFUTyCerKiKIrDUE9WFEXxCOrJ
iqIoDkM9WVEUxSOoJyuKojgM9WRFURSPoJ6sKIriMNSTFUVRPIJ6sqIoisNQ
T1YURfEI6smKoigOQz1ZURTFI6gnK4qiOAz1ZEVRFI+gnqwoiuIw1JMVRVE8
gnqyoiiKw1BPVhRF8QjqyYqiKA5DPVlRFMUjqCcriqI4DPVkRVEUj6CerCiK
4jD+W578/v37GzdufOkoFEVRAkA9WVEUxWH8hzx53rx5DRs2zJEjx6VLl750
LGGIvn37NmnS5Mcff3zx4sVHFvXq1asOHTo08UenTp0eP37skWgNT58+9XiZ
/znu3r3L8HXr1u3du3dfOhbFA6gnK4qiOIyw7Mm3b98eN27cy5cv5eWtW7cK
FCgQIUKEQ4cOfdnAAsTPz+/UqVPBPBhL3LFjR+gqOnv2rD1T+O2331KnTh0v
XrxHjx6FrkDDhg0bYsSIESlSpJo1a3bp0qVz587ly5dnesSNG3f79u0fWbgd
Qi1btmzRokURxZCee/jw4Zs3b3owmC8FbtymTZuIESOmTZv2zZs3Xzocd5ii
TK2VK1d+fFG07v3798E/3u3gPXv2DBs27D8x6OrJiqIoDiMse3KDBg0wtAcP
HsjLGzduJEyYsHr16q9fv/6ygfnn2rVrGTNmnDt3bjCP79atG2YbihvjKESf
Pn3KlStntpA+5MyZE+d8/vx5SEtz4+eff06VKtWuXbvk1vTJkydpFNPj999/
/8iS3SADqlu37vDhw0M6lM+ePcuQIQPnejaeLwWJVfLkyatVqxYG7ydfv349
ZsyYH698NK1EiRLBn0LLli1jHtonxsCBA5mE+/bt+8hIPgPqyYqiKA4jLHty
xYoV7Z585cqVaNGiNWzY8IsGFTBLliyhG4PpyRcvXkyUKFHt2rXNrfLg8+bN
m7Rp0+bLl89sWb9+PVVPnDgxpEW58erVq0aNGvXr189U9OOPP1JyhQoVQnHX
9xOBuseOHbtMmTJfOhDP4OfnRw8vXrz4SwcSAJgqasqs+MhySCFTpEiRK1eu
YB5fpUoVhvjevXtmy9WrV8ndnj59+pGRfAbUkxVFURxGmPXk7du3I5Pe3t5Y
pWw5evRozJgx161b90XjCgBMHqWnG8eNGxec43fs2BE+fPiOHTuGoi78Aeuw
e/L8+fMjR44c/FvZgfHs2bN27drduXPHZTnSL7/8EilSpLJly4YdSX779m3z
5s3pZ8d48u+//x5mPdlTjB8/njaOHDkyOAefOHEiceLELVu2DIOfGQUH9WRF
URSHEQY9+c2bN1xVkyVLRmBRo0bt1q2bbG/YsCHmhsv179+fjbt377af9fTp
U9net2/frVu3ysZ3797NmjWrR48e169fHzVqFLv69OkT9DreAwcOdOnSZeDA
gbdv36ZA/h4+fLgsmMTTxo4d27t37549e9JjsvH58+fVq1cPFy5chAgRkidP
vm3bNimHvRgsVXft2pVC0E5Od1lqlC5dOpqWP3/+hQsXmnr//PNPDuvVq1dg
EWKwxFOiRAnqSpMmzfHjx2X7N998Ezdu3E6dOvXr12/GjBlun+C/ePHCz8+P
MAj7zJkzQfe8OXfo0KE0J3r06OfPnw/6FJq5dOlSyv/555+J3yy6Nj2PwB8+
fJhdhCf3z8kmeLl+/XpTCPJPl3ax2Lt3b4AVXblyhcyCjICuS5s27d9//212
0S45l67+4FIWYiDV4uAxY8ZMnz7djFeAkKxxJPHTCv6wd6/s+vXXX2/cuLF6
9WqZDPy7ZMkSOvzJkyd0HQfQOW6rbZkGsoshix07dqpUqc6ePWv2Ml5MLfbO
nDnT1MU74uDBg9RFsSRlgwYNYh5SDvOE2TJp0qQPLrlBOzmXt8C+ffvsCkoS
tGbNmicW06ZN27Rpk2ynQLa43UyWMEaMGGG/tXvt2rUtW7bQq+RZUo45ixnL
rGDGMmQ//vijfQ02zXzyLyZ4SmCIObh8+fLyKRI9wAH+7ySbutx28ZKN0lgI
xec1H4l6sqIoisMIg57ssq6w2bJlI7AhQ4ZwvXNZF3TEMmLEiMOGDbt161ap
UqWaNm1qrshcH+vWrZshQwauUDt37sQ9RDVRCF9fX86KFy8el2x28TfyFli9
uEeuXLny5MmDJSZOnLhevXooaKZMmbheYzuYXpIkSRA8/IrteIXLUiO8hVA5
8ebNm1zBpag5c+ZwzPjx42vVqsXeFClSyFX7r7/+IgXA/ydOnPjw4UM5GElO
mjRplSpVFi1alDlzZmw5wNhOnjwZM2ZMSlu+fLlxgBw5cqBbpA+oIz2A/plT
rl69SvPjxIlDP0ydOrVkyZLB6XzOypo1a7Ro0SZPnvzBdbOLFy/28fHBnchi
CCx16tQyXjSc3pswYQK1Ex674seP//jx44sXLxYsWJABSpgwody7xojKlSvH
cDOgFSpUoOoAv9TGRhSaRIk2MiuM7F24cIEeKFas2A8//EDMNWvWDCLa+/fv
42AFChSgLjqcUSAJCuxg+USDyImf+cas4HhZZ8supke1atWojqnFQKPxbGf4
GCDCSJAgAc2vU6cOuzBne7FMURKlJk2a5M6dm8IZILOLQugcTuFcetWs6SXj
IAamLsUyiM2bN2ceotnff/89rabT6AG7bLuBiDZu3JhzSeg4kre8TB7SkzJl
ynh5ebEre/bsdCxt2bBhw+XLlytVqlSoUCG77+3Zs6dFixYMU40aNYhfslRy
hMKFC8eIEaNixYoMHP8yrKSEcgrvU2ZFlChRaCYF4tiynbOKFi3KbK9atSpV
I9IyvmRn0uEMEPkFG5m0FMhILVu2zERy4sSJLFmy8DbBvXlbmV2bN29mXlFg
o0aNSCRLWXzmT0PUkxVFURxG2PRkl3WbFOkSlYJ9+/aFCxeuffv2IlFuS5d/
+umn8OHDc8Fdt27dlClTMGq50TR69OijR4+iN1ymX7x4cerUKQSYy2tglaKF
KB92R11yB2z16tVoCV7Rt29frvjz5893WbezuKDL9d1lPXGCPpRdwsyZM5EH
TqFAWbpMsbILOcmbNy8RGqPetm0b0kWNhw8fxiXwh8DWb9AbsWLFol5zLpKA
leEbLss00AP7kgwsiKpRKSQK9w7O0m4kGVXDncgCPijJCxYs8Pb2pvNxeHqe
ugYOHChntW7dmiyAFiF4aA8Dh9QhbAsXLmSAvvvuO/oHj+LIY8eOMXYIJwNE
IkCQcuPdPyhx5MiRGQ6z5fz58zksSIuQcFScYnft2hVYwHgsgyhruYmKrrPf
0nejq0XatGnTp0+PYPv5+aFhmy2Qt+TJk//zzz9Hjhxh4JBe8fYOHTrs2LGD
JiOZ5AvkTfQkDTdlUh2zkdSJvwcPHkyP/fHHH7ILO2XskFU6ga7AAKNHj75x
40ZmMgoqN1qZNnLDnCO/+uorkhH6atWqVeyaMWNGgK2gWxo0aIBjM5/pf8Kj
B2QVOhODcaETOB0vZRd/k4cWL16ckhFyk1ESG/5JSGR5jBozBINle+XKlQmM
9xQjyFRkfvJGQ2vNsymYA7xPGW5z4xdJLlKkCEVRjizJqF27tomWZER2yUsm
NjkRPUbiIFt4gzAiDPTatWuvXbtGJ5AiMfqMBfbepk0bCiSxpQ/79+//+b/9
p56sKIriMMKmJyPAXOy4nprPrFesWIEjYbAuS1PZlTFjRnkALxKYJEkSrtQ4
RpYsWbhuctE0Re3fv5/rLMLD31u3bqUQc78rMLisx4sX7/Tp02YLl10EDLPC
l1yBeLL9yWk5c+YUj3L5+4rfhg0b3L52V6dOHblp2bJly6JFiw4aNCgwURRP
rl69utkyffp0TExWOyAnyZIlM568fv16YqbklClT4t7UYtKKwECHaCMForKy
ZefOnUGso8YG6U9RJlID6po8ebLskjUeXbp0QSPtLkqQeJ0sHZHvaoknA93O
bAxiVQyqj+/17NlTXuJg9DOV0gkuSwjRJ14GtoKdmeDj44PvyR1vWkoiFsQ6
WCQc96M3smfP7rI+OJBG1ahRg2jlnj910Zaff/7ZtJochz5p3LgxL3E8HNJ4
MtOGSo3Jiyfv2bPHZSVoAwYM4OXYsWNd1ncq0UVZusxkwMzJwkxLXZYnm6fJ
kdEE4cmHDh0iQt4g8gM9586dixQpUqtWrVxW7kmfYOP0PJ1JeJs2baJqptOc
OXM4jIkthXTr1o1CmNJly5bFopml8kSU3bt3y2c0FSpUwITpMSSZmWY+7Bgz
ZgzvPrk5LH04cuRI+ZzI9e/SZbPYY8uWLUxvX19fk6CRXZJ5Ye/kC9ItCLM4
ucta8oEniwxL8PJOlPvw0p/qyYqiKMrHEDY9efbs2bK6wGzh0owEylJGtIGr
trnpunfvXl6iQNevX39vYS+qfv36mACXVP6uVKmS/S50YKANKIF9cWPr1q2J
p1q1avIS8eMCXblyZZe15ANzQNjMDwViQWa1BnBlT5UqlVnoizPgFbNmzTKF
4xVRokTh0u8/eDfQV5zBKDfaULFiRbOaQgzELCQQfUqfPv2JEyeC8/RaQm3f
vj2nyN1pl7XSg9h+/fXXAI8/ePBgwoQJaZp0FDKJjNmfIC3PB2Zojh49aj+x
U6dO2KMIoctaC1GuXDmGj412FfRPzZo1zV1ol/WxPi/pOnEh8WQcFd0K8PRF
ixZRPskIeokfIsyBrfEwTJo0iVMwLrOFcaTJMWPGvH37Ni9Lly7N3yZFosko
KCKH/POySZMmjPWCBQtkL+8ypBHVlGgRwjx58kg5ZAcSvKyXtnuynCtFzZs3
z2X5LQcj5zJhyA15awS2+Byfp5zu3bvLSwSV8MSTXZap4sPNmjVzO4tJlThx
YnMTmCnBODJMdAh5n306HT58mMB4g7isL6hymLkLTW80b96cYTWzArvmnUWN
a9as4SVz1e7J9I/9BjuQaTKB48SJI+9fMmLO5e2M7bv+9WQmADG4rOUlpUqV
Yh7K/wM02ez6bKgnK4qiOIyw6ckzZszggrtq1apnz56hnVz1cNeUKVPKXay+
ffty6Vy3bp0s8UUbuBb37t3bnG6XH0yvWLFiaMnly5czZ84cL148PMpu4G4g
QmnSpKlbt679pq58nms8GUWhxr/++stlLZz29vaWXfgSZ+HABC+ejPBQ2rff
foucy/rMfPnyff3117glL2V9MhF6eXkZzQ5itQPWgScQ4dWrV/EiGoXsycMf
6Bk0EgXCBqdOnUoh4snGOujDwG5TC3PmzME60AzzgBESELrrzz//DPB40U6k
kTZSXVYLTIlIqIghoBzahcXRNJxWvnhIGAUKFEACMUPO+vvvv0eMGMEI0j8N
GjSg3xijAO/xIj/EFitWLMRSGiKejMJJj61fv57qENcAm0m9jAIBy91veSAb
TWZ2BfYlOMKQkDZs2GA27ty5kxNxY1kRVKJECZIFBkJioMlYXLZs2W7evMkB
1EheY/qTBIFz5dnXOB7R1q5dm2iJjd6gq03wu3fvjh07NkopKQYH0C10r/QM
iRLlyLJnjmemffPNN4ENLsZLSGYRb5UqVbBHGi4vGzVqhLqLdhouXLiAneLe
cuPdZXkyPc8QyEv7FKUJFCj/gdA0GkVdcgATlRlFCslIyRZ6m3YVLFiQaJn8
qHjq1KmxX5mc/F9Eb/PelATT9e9qqy5dukjrOBIn510goi5PeiEAOZgpxH8L
5MIua3UHFdWqVUu6N8Ce+RSoJyuKojiMMOjJiBZKgE0hG1zHJ0+ejKjgG6NH
j5YDcuXKlTFjxm7dujVu3Bgfw9O4ONavXx/5RKJ+//33hg0bilGjGaiULLTY
tGkTLUWnW7RoYZdqNxBL/09C5gKNGokM42OoUZ8+feRbhMaTcY/vv/+eeLCm
TBbE0LlzZ8w2Xbp0XM3l3iDagPNg1MWLF5dlnISHhIgnIxI4ufETO8hGjhw5
KG3btm20F2EbMmQI2iC342RJBqI1ZsyYChUqEMbmzZvZMnToUJclWsOHD+/f
v39grcbt6Sh0C0eSLWg83YiEB/bQAFwubty4eDK5DL2BseB1FStWxF6KFClC
dtCyZUvCa9q0KZHTP/LROSOSJEmS+PHjN2nShB5r166dWa2B+ZMKBfaDFOg6
R/bo0QOpozQOFk9mnty7d48YMECkK4jfaqQ68WRsU75DN3LkSOKUO7r+YRxx
VxI0u0ifPn2a+OV+8tixY/FAJsNvv/0mTUD7GSAmGH/L0mWkbtCgQXJXc8qU
KSileLKsqGdWVK9enYxPPJmJTbF0OD2fNGlS80QXisVaGX2XdauZw3x8fCRN
mzdvHj1Pwti2bdsAf7i8Y8eOGOOBAwdclnbizPnz5zcTTDyZFNJ+ysqVK+kc
piWzV9wYT2aSyzoZ/JZRM3XZdzGlUV8Ck/XPorWtW7dmbpMjuCx9TZQoEV0q
AypfACRn4U1HgbSRzIKhHDx4sKz2R3R549Nvw4YNMwXyBpEwmGb8R2G+wCgF
yt1s3qR0db169ThXJp5s5E0R2PTwCOrJiqIoDiMMejJShyxhI4UKFRoxYsTb
t2+xynz58q1du1YOWLhwIXu5KJtno3FpxpG4yBYsWBCHlE9pXda6Yqxg5syZ
LuvCipakTZu2S5cuARqFgIVSjps7yZfxKcrX1xcxGzhwoLnnSbFZsmTBGJFk
c9aCBQsQBuIn7PTp09PD/C2nVK5cGbkqUaIEscnB2LLcc6ZwqkC6Ars3SL14
AjYrCz7xNPpBbgYSBvqNPhGG+fIjuYN0Y40aNdq3by/LuQOEY+TmsO+/oH8o
n/lMPEAQQsqnz+UmOSUQ29OnT3FRjIXsIE+ePMgPB2As5raerMfm+Pv37+/Z
swfL4khq5DB78G4QPF5EhIQq5sOgyLMjsmfPTkUUGPQPmj948ECe1UBdBEyE
lOb2vDK3GnFXbN9tO8rn5eXVt29f2k4mgqZSoKQ5CC3ayTC5rJXApANJLGSi
0jMoLvNnyZIl8kwVyqc5pFqMOOOOE5LmYLwEZn/sIRpMj02aNMllPdcuRYoU
hQsXll0YJmdxPPMnwFmNRhIG4j1hwgTqIoeSR3NIhIxygwYN3J7/hnDSLnIW
pqWscqGXmAwoN+NFckohUhf+L88klD7kLUlvcJYsmEe/aXtVC1mjTkWMMqki
Kk4iQKPixInDMatXr5Zd9A//I5HuyTJ16kJ36TF622Vl0Iwgx69YsYI/qMue
VWHvdKl8raBnz56kITScjhKHp8/pKPKjIGbIx6OerCiK4jDCoCcL69atW7Vq
VWB7MWe3D4uPHj06b968oO8XcfHFKz74EwaBrWlEMKjC/iVB4cyZM2x3U2t8
m0szdbmdhRXz0u25xEeOHJlnYQw/QHCkRYsW7dy5U14iJ5xo9mIIAYbBRvNI
rsDAPOf5Y/78+R/8ETScipAQGESRU8xjjSnw0qVLREiHm8dZC5iwn5+fWbPK
XqnOtCuIujjM7QHLyJicbl8aHRhkE1RNFkO7NmzYwFn2b2u6IcGbZ/cZnjx5
Qs9QDn27ZcsWCjEThmIZdHMHnvSNvfaFK4y7nwVZEurIXnO3E9BF2es2AzmL
I+XTh3fv3i1fvtyev3AWe80HAf5BbufMmYMqu2U9JA7U5bZ6XOA/hKxZs5ov
wdHkGTNmZMyYsUyZMvavSTLZqNrc0aUWzuJfcweetpO+MUPMKbwR0HV8lSrm
zp1LvmC+aMAuVLlXr15mrTWZFI7drFkz84CXAwcOkPHh8PLsOHtGyfxp0qSJ
JIMEwP9s5KTmPwTKpNLx48cH1kseQT1ZURTFYYRZT1YUxYMEvTrdjffv3/v/
xWq2BJ1jBnaW2xYKMRv5w75+mF1uy4nJVtwiJ1MgEwkwEvuRskjeLZJPvVZZ
PVlRFMVhqCcriqJ4BPVkRVEUh6GerCiK4hHUkxVFURyGerKiKIpHUE9WFEVx
GOrJiqIoHkE9WVEUxWGoJyuKongE9WRFURSHoZ6sKIriEdSTFUVRHIZ6sqIo
ikdQT1YURXEY6smKx7l58+ZViwB/gFtRnIp6sqIoisNQT1Y8y/bt2xMmTBjN
okyZMr1795bfPlb+E/z555+9bcjvTSvBRD1ZURTFYagnK55l+PDh/2dRqFCh
+hZXrlz50kEpweLFixdVq1b9Pxt16tT50kH9l1BPVhRFcRjqyYpnEU+eOnXq
/fv3v3QsSoi5c+fOfou1a9dGixZNPTlEqCcriqI4DPVkxbOIJ//5559fOhDl
o7h+/Xr06NHVk0OEerKiKIrDUE9WPIt6sjMQT06fPv2lS5e+dCz/GdSTFUVR
HIZ6suJZ1JOdgXgyQ/nXX3996Vj+M6gnK4qiOAz1ZMWzqCc7A/XkUKCerCiK
4jDUkxXPop7sDF69etW8eXP15BChnqwoiuIw1JMVz6Ke7AweP35csmRJ9eQQ
oZ6sKIriMNSTFc+inuwM3r9/37t3b/XkEKGerCiK4jDUkxXPop7sDG7dupUo
USL15BChnqwoiuIw1JMVzxKWPfnYsWNt27b99ttvmzdv/vjx489Q45UrV7Zv
3x7quk6ePNm5c2cCbtiw4YMHD0Idxvv379HdI0eOBP8U/R5fKFBPVhRFcRjq
yYpnCbOefOjQoQQJEqROnXr27Nnx48dn5n+GSocMGUJv9O7dOxTnnjp1KnHi
xI0bN+7atWvkyJH9/PxCF8P58+dr1qxJk7Nnz96iRYtg/k7iy5cvGzRooJ4c
ItSTFUVRHIZ6suJZwqwnt27dOkKECDNmzHj16lWqVKkKFSr0GSrds2dPuXLl
rl27FtIT37x506lTJx8fn/379799+zZTpkzffPNNKAKg6qxZs0aPHn3u3LmX
Ll3Kli0b8Tx79iw45/7yyy/qySFCPVlRFMVhqCcrniVsevLJkyeTJEmSOXPm
Fy9efE5PhmBKqRtLliyJGDFivXr13r179/79eyLPkSNHKMo5dOhQuHDhOnbs
SCG8HDp0qJeX19q1a4NzrnpySFFPVhRFcRjqyYpnCYOe/Pbt286dOxPVrFmz
XNaTgT+nJ4eC169f582bl4AXL17My0uXLiVPnjx0njxv3jw8uUePHvLy3Llz
kSJFatWqVXDOVU8OKerJiqIoDkM9WfEsHvHku3fvNmjQoFKlSrVr1y5VqtSg
QYNk+8WLF6tVq9bOgj94KdsRS6SuTp06zGeOr1Wr1osXL0xpjx8/jh8/PlGt
W7cOZx41alS0aNE87skbNmyoUKFCp06dypUrR3hPnjx58OABTSCezZs3c8C7
d++mTp3Ky0aNGnXv3r2Uhexy4+rVq4kSJULmz549y8uJEycSfOg8WZ6BrJ78
eVBPVhRFcRjqyYpn+XhPRpJLly6dNWvWZcuWrV271sfHp0mTJmy/cOFCzpw5
cdH7FuXLl+elqPKRI0dixYq1Zs0aDHPAgAEJEyZEU02B169fp5AoUaLg3u3b
t+cPIvSsJ+/duxcV//nnn1++fNmhQ4eIESOizbh6s2bNIkSI4Ovr67JkvmPH
juzCVNu2bTt9+nSOTJYs2YEDB9xKk2//AblAmzZtChQoEGr7Uk/+nKgnK4qi
OAz1ZMWzfLwnY5vhw4fHFeXlli1bbt68+f79+zp16sSIEQMTlu1XrlzhZe7c
ua9duzZ58uTo0aP36dOHvy9fvjxw4MBXr16ZArt37x4uXLiyZcs+ffoU2fby
8iLCXr16fUwz3Zg/fz5l4rS48bNnz6pUqYKRsp0akydPLp7sspZ8ZMyYMVu2
bG/evHFZC0Ly5MmzYMECt9IGDx5MaT/88MP+/fv9/PyiRYtGh2zatCkUgQXo
yS1atAjOuerJIUU9WVEUxWGoJyue5SM9Gfv18fFBC48ePWrffuDAAUwYMb59
+7ZsefToUb58+ahr165dbMycOTN/J06cmI3IsP3czp07U+D27dtd1s9nUEiy
ZMlkSYOn2L17d9y4cSNGjJgiRYpatWotW7ZMtiPGKVOmNJ7s/xt5RIsqI8xm
y8uXLzFk2rJnzx5e0joCLlq0qH0lSfAJ0JO9vb1F44NGPTmkqCcriqI4DPVk
xbN8pCffuHEDsfTvyRRIsXZPvn//fsaMGcWTXdaX3UaNGiW2jHk+f/7cnCue
fOzYMf7u168foti1a9dQNi9wjh8/3qpVK7xXRHTv3r2u4Hly2rRp5faycPPm
TbnjLZ7csWNHgl+zZk3oomrevLl/T65WrVpwrFs9OaSoJyuKojgM9WTFs3z8
uosuXbpghlu3bjVbnj17du3atfz580ePHv306dOyUe4Ms+XgwYOnTp1iDr97
9w7J/PXXX6NGjTp9+nRzuvHk169f16pVK378+FeuXAl1eAGCq8uPiWC8PXv2
jBw58vr1612h8mT5gY/s2bNfv36d5pALxIoVKzi3fwNEngtnPBnpjRgxoq5P
/kSoJyuKojgM9WTFs3y8J2/YsCFu3LjY49GjR5HGhw8fNm3adN++fbNmzYoW
LVquXLn++ecfhHPKlCkI5MyZMzmldu3a3t7esnSZI/Fn0VRh3bp1MWPGxPcG
DhyIJPPy45vpxvz585MkSULV/P3ixQvkVgJ48uSJfX2ymycfPnw4UaJEbp7s
stYnI/a4N84fO3bsP/74I9SB0YdIO5mCPD+5Zs2a9KFZFhI06skhRT1ZURTF
YagnK57FI8+Fk8dcZMqUqXz58okTJ8YbMUl5rlr06NHz58+PwnHAtGnT2CiV
YoPlypXjAPZWqFABwTal8TflcDxFBfMnNkLKggULMNs0adJMnjy5ZcuWqVOn
PnnyJMLcpEmTCBEipE+fHrd//fr1nDlziCFZsmRz58599epVp06d6CvU/ciR
I/bSVq1ahdjXrVs3QYIESLIobuh4+/btiBEjaPuSJUuuX79OllG8ePGnT58G
51z15JCinqwoiuIw1JMVz+Kp3xk5e/bsUQtZLyEbMUb8U7bzhxFIDuCwo/9y
//59t9LYwnbPfnfPzsOHD4/akKfV4ahjx44tU6bMypUrHz16hNKfOHGiYcOG
jRs3Jng8uUGDBmUs/N8xPn36NNnBmTNnPj42whgzZkzt2rVbt25dv379W7du
BfNE9eSQop6sKIriMNSTFc8SBn+PTwkd6skhRT1ZURTFYagnK55FPdkxqCeH
FPVkRVEUh6GerHgW9WTHoJ4cUtSTFUVRHIZ6suJZ1JMdg3pySFFPVhRFcRjq
yYpnUU92DOrJIUU9WVEUxWGoJyueRT3ZMagnhxT1ZEVRFIehnqx4FvVkx6Ce
HFLUkxVFURyGerLiWdSTHYN6ckhRT1YURXEY6smKZ1FPdgzqySFFPVlRFMVh
qCcrnkU92TGoJ4cU9WRFURSHoZ6seBb1ZMegnhxS1JMVRVEchnqy4lnUkx2D
enJIUU9WFEVxGOrJimdRT3YM6skhRT1ZURTFYagnK55FPdkxqCeHFPVkRVEU
h6GerHgW9WTHoJ4cUtSTFUVRHIZ6suJZ1JMdg3pySFFPVhRFcRjqySHizp07
S5Yseffu3ZcO5HPz5s2bQ4cOBedI9WTHoJ4cUtSTFUVRHEZY9uSLFy/myZPn
G4sDBw74P+Dy5culS5dmb7Fixc6dO/ep40GSa9euPWvWrPfv38uWZ8+ebdmy
ZfPmzceOHbMfef/+/Xr16vXo0aNgwYINGzZ8+PCh2y5i7tix44sXL9hy4sSJ
zf/i5iQvX77s2rUrB69evZqXZ86c4ZhRo0axpVevXv369Tt16tSnaOmRI0c2
27h16xapwYQJE5gn9+7dC/pc9WTHoJ4cUtSTFUVRHEZY9uSnT5/OnTvXy8uL
CLFNt71PnjzJly8fu9KlS7d8+fKzZ89+0mAQxUqVKlWoUMFsQZI7dOjwtUXu
3LnbtGnz6NEj2YVRlytXjth8fHymT59ud0t2cXCaNGkWLVpECWwhBahRowYH
58iRA+u2V4pI16xZ09vbe/HixSQFadOmbdKkSbdu3Ti4c+fOLVq0YO+rV688
3tg9e/aQgFBLjBgxRo8efe3aNZeVleTNm/f7778P+tz/riczNCYDUlzqySFH
PVlRFMVhhGVPhqtXr2KJRJgnTx63XTNnzowSJcpnuypt2rQpXrx4dv1DjHv0
6PH27VsUGlGPFCkS1oq9y94TJ05EiBAhZ86c2Je9nNOnT6P3R48etW/s379/
+PDhS5Ys6VYpgsrGpUuXyomtW7d++fIlzkyr582bR1316tX74A3e0IGEU0v9
+vXtG+mEhAkTBu3AX8STr1y50qVLl9u3b4fudBKc3377zdfXlx5mynk2to/k
/v37NI3J9pHz/OHDhxT1+vXr4J+inhxS1JMVRVEcRhj35J9++ilcuHD+PRk5
LFKkyP9ZbNu27VOHgZ3WrVu3QoUKWLFsOXXqVNKkSbt37y4v0Y/8+fPjuiNG
jJAtJ0+exJOR5/Pnz9uLQolRULfycekECRL49+QmTZpwvNzkxMbl1rHxZJd1
w9nDTbVAqAoVKhQ5cuTjx4/bt79586ZEiRKTJk0K4twv4smNGjVinrRv3z4U
59KxBQsWTJw4MV0aI0YMivJ4eKHmwYMHzLps2bLxL/MtdMtsnj59Om7cuLRp
0/r4+JAIBHOduUs9OeSoJyuKojiMsOzJXN+rVKlSunRpLy8vN0/GiEaOHBkz
ZsyECRO6udyn4O7du97e3tWqVTNbNm3aFCtWrEyZMpnv9BUuXJieRC3kZYCe
fPny5fr168tyCzu0NFGiRG6efOTIEWr0f4/U7smfCLoU58+QIcPNmzfddpG5
ZM6cmYADO/eLeDIBV61aFRsM6YkkPmQiyZIlW79+/a1bt/DkDy4s+Zy0bNky
d+7cFy5cWLVqFb06ffr0UBTSuXPnqFGjbt26de3atUyzNGnSoN/BOVE9OaSo
JyuKojiMsOzJp06dih8//p07d9KnT48Sb9y4UbavWLGidu3aaCQbEekPlvP+
/XsEA8ELdSR4so+PD5ph37hv3z67QuDJkSNHnjp1qrxEhitVqmT35JcvXxYq
VGjRokX+yxdPjhMnjinw4cOHDRs2XLdunf+DP4MnUy+eHGCPHTt2jK44c+ZM
YOf+t9Yn0xC6vWzZsvwd1jx5zZo18eLFIx/k71B7MtOPqUV2xvTjJXMYZx42
bFhwzlVPDinqyYqiKA4jjHsy4T1//hxPJsg5c+a4LP/EZK5cudK6dWs2NmjQ
4IPl3Lx5M2HChJMnTw51JJMmTYoePXoQj9TYv39/ggQJsmTJIjYitGrVyu7J
fn5+NWrUuH//vv/TaVSGDBloDjokWzCiUqVK+T9y586dxYsXly82mkUgHgdv
xJP79evnfxeezK7OnTsHdu7n8eTHjx97pBwaEi5cuJkzZ7rCnifny5ePSSUf
l4Tak7dt20YDe/ToIS+Zw8xJ3jXBmTzqySFFPVlRFMVhhGVPHjdu3IQJE7ig
Z86c2Xgy/w4dOtRlfdEsYsSIJ06cCLqQe/fulS5dGrXbvXv3iw/x5s2bAAsR
4w3Mk1+/fo20p0iRAlt2OytChAiymvfu3btVq1ZF7wOLk8Noo3xlj0iqVKkS
YHWvXr0aMWJEr169AnxQnoGGBN3SIB7swC4U3cfHJ8BvCH5xTz506BAeUr58
+f/HQp65t3jx4oEDB5osY+XKlQP/hdkyZMiQQYMGyVM77HBu4cKFaQ6NotWX
Ll3y8vIKtSczNAsWLJBK586da3r4yJEjJpgVK1bYe96+Sx79Zzh58mSyZMnS
pk0rc5KJETpPlueuuHlylChRTp8+/cFz1ZNDinqyoiiKwwjLnlyxYsXx48e7
rEdbiCcjohgaXnr+/PlYsWLhyR98HBwGK98ETJAgQbIPUadOHfPACjtBeDJ2
1L59+1SpUvnXCc6iXlnVTNizZs0K4gdKUCAOLlCgABL7448/Dh48+IP9ExjP
nj1r0KBB0C0NYsS3bdsWNWrUePHiBXjP9st6MtLYtm3bjh07knHQRdGjR794
8aLLMjqiat68uRw2ZswYxoswEH78c+zYsbSodu3abqVduHAhcuTITA+KIuwk
SZLwd+g8GccuWLAg1dWrV+/bb7+luu3bt7P96NGjuC6ZGttr1qxJ9jF//nw5
hV3Fixdne6VKlQi+ZcuW9gL9/Pxk0jJtmPmSKobCk0uWLOnfk0nf8PAPnque
HFLUkxVFURxGmPXkffv25ciR48aNG65/b6alTp26SJEihw8fdllLMrjWozT2
dQ4BMnDgwOTJk+M/s2fP3vshqDTAAoPwZNQ9U6ZMu3fv9r/ryJEjXl5eePKK
FSuqV68e9CO5xJPRof79+//www8fbFcQoO5oar9+/TDD7yyKFi06dOjQBQsW
oPS8xHKDWGC8bt06IsmbN6//7xu6vrQnk8XEjx+fzrx//z7OPHr0aJkhYrzG
k9nVoUMHwti1a5fLWqTBWbII2c7GjRsZ1sSJEy9fvnzZsmWJEiWiad26dQtp
VIysr68viZs8euXWrVvMTObSvXv30qdPX6JECfnaI1lS7969vb29ZW05cl6s
WDFiY6y7d++O/9sLLFSoEPEXLlx4z549NJOMgLm0Zs2akMamnvw5UU9WFEVx
GGHWkzdt2oR7yA1Y8eSIESOaBxogM8F/DtjBgwfjxo27fv36UAcTmCcj7cWL
F0ew5eXNmzfty4/v3r2LO6Fh+fPnD2LFhSCeHDNmTJwWxQp1qB8Pk4FIAnv4
m2c9edCgQVWD5KeffrL/kArqnjFjRrnxTjZx4sQJWZbg5skwbNiwD3qy/LyL
nPXPP/+kTJkyQYIE/pdnfBDEOEmSJJit23bC++qrr+w3qIkzWbJkJID8PXHi
RKY0aUuzZs2wVvtPOtLkFClSRIsWTb7Iyb9MDDkrpKgnf07UkxVFURxG2PTk
169ft2nTxnxCvWrVKowiXbp0z58/d1nP8ipTpgxhB9OT5cN6pCvU8axYsQJR
cfPkI0eOpEmTBs/x8/N7+PDh8ePHs2TJIk8nEMST0RJZUB00eAuuhcBMmzYt
1HF+PBhatmzZgvZkguzZs2dgJYTIky9evDgqSNx+EBzIShhNb2/vKFGi4Maj
R492fYQnR40addmyZfyNDZJ5denSJThh+w+JRMy/JyPAxGD35Pfv32fOnFmM
l2nZsWNHLy8v6kWnJ0+ebJbliCebAukHyunTp08oYhs7dqz/7/Fh4EF8oGBQ
Tw4p6smKoigOIwx68v79+1u1aoUFIcbyZX+0uVq1alu3buXvs2fP/vzzz1zo
sbUSJUoE8y4x4vExT0jAeBGh2bNn2zcWLlxYVj4jOT4+Pphb8uTJ5Wtl5iw2
VqxYMbCvB7qBPjVq1OgT/XRIcNizZ0+LFi3oWBrVtGnTABeKHD16FOe8detW
YIV80nUXT58+rV+//s2bN+/du4cBMklq1arl+teTidkcGUxPJv2RJ1RXqVIl
evToCxYsCEVUzK6UKVMWLFjQvhElnjhxIlIqEQonTpxIlChRzpw5XVZP3rlz
5+DBg8x2chOmtPlunXiyr6+vy/qtQOYV5YfuR0YOHTrELDWLScSTGzduHMRS
eYN6ckhRT1YURXEYYdCT8ZaT/2J+EMGIGSJ60sYH1zN4BEQrb9689t8ZcVlu
1qVLFyxo1KhReAh+6HbDGRWZPn26LKgODu3atfuyKy7mzp07bty4ChZ169aV
u/duNGzYkAQhwF3Cp16fnCBBArHZZ8+eVa1a1e7JceLEkSHAM5s3b/5BT+7V
q5eXl9f27dsnTZqUOHFi3gVBPAYkCMiDypQpQ7pksjbmMNnc/fv3UWJU3M/P
z2V9DtKxY0ciWbt2LRE2a9bMfCDCdkz48uXLpsDSpUuLJyOradKkCfXEkJUe
SZIkkYXcK1asiBgxImYenHPVk0OKerKiKIrDCIOeHDahi/AN/8sA/qdAOIsX
L75kyZIgjvmknoyfEwA5S8mSJb/77jtGRL4617179/AWMkCDBw+Wu+I1a9Yk
w+rXrx8W7ePj4/aL4S9evMBUU6RIgSTPmjXrYwKjlsqVK5NBjB49esKECcQm
BZ4/fx5V9vb2/u2334iciuTXau7du5c2bdqECRMuW7Zs48aN/O32tOp169Yh
tzSzWLFibs8bDCl0TrRo0dasWYO9Uxp1Bf1QQYN6ckhRT1YURXEY6snB5M2b
N7ly5WrTps2XDuRLsmjRogIFCgR90/Uz/M7I1atXp1uYu6xbtmzh5YwZM+QD
CGqXA9hy/PhxlFVeylJkO69fv/bz89uwYYNHAiOMGRb2Ai9evCiR8K/c3xaO
Hj0q24E3oP8nnKxcuZIDPviE8A9CckE5GTNmrFSpUtasWYOf66knhxT1ZEVR
FIehnhx8Dh48WLhwYfTmSwfyZaDhJUqU+KBl/bd+t/p/h2fPnj19+jSIBTP+
UU8OKerJiqIoDkM9OUTs27evV69en+4Ho8MyW7duPXLkyAcPU092DOrJIUU9
WVEUxWGoJyueRT3ZMagnhxT1ZEVRFIehnqx4FvVkx6CeHFLUkxVFURyGerLi
WdSTHYN6ckhRT1YURXEY6smKZ1FPdgzqySFFPVlRFMVhqCcrnkU92TGoJ4cU
9WRFURSHoZ6seBb1ZMegnhxS1JMVRVEchnqy4lnUkx2DenJIUU9WFEVxGOrJ
imdRT3YM6skhRT1ZURTFYagnK55FPdkxqCeHFPVkRVEUh6GerHgW9WTHoJ4c
UtSTFUVRHIZ6suJZ1JMdg3pySFFPVhRFcRjqyYpnUU92DOrJIUU9WVEUxWGo
JyueRT3ZMagnhxT1ZEVRFIehnqx4FvVkx6CeHFLUkxVFURyGerLiWdSTHYN6
ckhRT1YURXEY6smKZ1FPdgzqySFFPVlRFMVhqCcrnkU92TGoJ4cU9WRFURSH
oZ6seBb1ZMegnhxS1JMVRVEchnqy4lk+syffv3//h/+3vXuP16Hc/z9++8qp
SEhy1lYSUkKH3XYopxJJB2clOmijlByK3U46yO6wdZLILiSEFKkoW6WTY8op
5ZikhNjUwmL93o/1+ZnHmLnXve57rbnXWqbX8w8Pa+65Z677mmuu6z1zz8zd
tWvDhg1HjBixcePGnFlpNq1du/bLdN9//31OrnfLli0JzU9OThQ5GQBChpyM
YOVkTt69e3fr1q0vuuiiSZMmderUqXr16t98800OrDc7FixYULly5Zo1a3br
1q1q1apLlixJ9hp37tw5fvx41U+NGjUWL14c/xvJyYkiJwNAyJCTEayczMkj
RowoUKDAwoUL09JPLJcuXbply5aHDx/OgVVnzcGDB88999x69eqlpKQcOHDg
1ltvPeOMM1atWpXUlb7//vtKbqeddpq2y4wZM+J/Izk5UeRkAAgZcjKClWM5
eceOHeXKlWvdurXCp/7cu3evomChQoUWLFiQ7FVn2cSJE0844YRp06bZn5Mn
T1ZdTZ8+PQdWPXr0aHJyspGTASBkyMkIVo7l5J9//rlYsWLt2rWzPy0na9Xv
v/9+sledNampqQMGDFAJ586da1MsJzdq1EgvJXvtr7/+Ojk52cjJABAy5GQE
a9y4cQUKFHjzzTeTvSJPTt63b1/NmjXzck7es2dP6dKl/Tn5zDPPPHToULLX
Tk7OAeRkAAgZcjKCpTRYuXLlJ598Mtkr8uTklJSUVq1akZMzQk7OAeRkAAgZ
cjKC9cknn5QoUSJXrrs4/fTT83JO/uOPP1q3bk1ODjFyMgCEDDkZwVq7dm2Z
MmVyPicfOXLEUkqezclpR2+mIyeHFTkZAEKGnIxg2X18U6ZMSfaKLCc3bdp0
3759+vPw4cP//Oc/j8ec3LhxY+7jCwdyMgCEDDkZwfrss89Klix55ZVXJntF
KSkpXbt2VevVGtOOPu+idu3a27ZtS/aqs2zixIkFChR444037M+cfC4cOTkH
kJMBIGTIyQjWyJEj8+XLN2/evBxY18cff1y6dOmhQ4f+8ccfb7311imnnPLU
U0/lwHqz7ODBg0ry9erVS01NPXDgwC233FKpUqXVq1cne706pujRo4f29KlT
p8b/LnJyosjJABAy5GQEy667yIHzyWbu3Lnly5evUKFCyZIlR4wYkQMX+mbT
Rx99pGx89913KyRXrVp12LBhyV7j559/3r179/z582u7nH322ZMnT1ZEj+eN
5OREkZMBIGTIyQiWYljhwoVz4Ppkx5o1axYvXrxs2bK8H5LNunXr5s+fP3z4
8PXr1+fA6jZu3LjYZfny5XFeDk1OThQ5GQBChpyMYB08ePAvf/lLDjzvAslG
Tk4UORkAQoacjGBZTu7fv39uFwTZRU5OFDkZAEKGnIxgLV269NRTT7300ktz
uyDILnJyosjJABAy5GQEy+7je/PNN3O7IMgucnKiyMkAEDLkZATLcvJNN92U
2wVBdpGTE0VOBoCQIScjWCtWrChduvTDDz+c2wVBdpGTE0VOBoCQIScjWHYf
X8OGDXPgt5iRVOTkRJGTASBkyMkIluXkQoUKDRo06PV0CxYsyO1CIQFz5syx
Dde+fXtyckLIyQAQMuRkBOvQoUOXX3555KgyZcr069cvtwuFeM2YMaNIkSIR
F3Jy/MjJABAy5GQE7scff5x+1NKlS3O7OEjAhg0bph9r165duV2o4wY5GQBC
hpwMAIEgJwNAyJCTASAQ5GQACBlyMgAEgpwMACFDTgaAQJCTASBkyMkAEAhy
MgCEDDkZAAJBTgaAkCEnA0AgyMkAEDLkZAAIBDkZAELmT5KTt2zZsn379twu
BYAwIycDQMj8GXLyrFmzSpQoUbVq1eXLl+d2WQCEFjkZAELmz5CTp06detJJ
J+lj1q9f//Dhw7ldHADhRE4GgJD5M+TkQ4cOde/eXR/znHPOIScDSBJyMgCE
zJ8hJysb33///eRkAElFTgaAkMnLOXnPnj070u3du9eZuHPnTpv4Rzr7/4ED
B/xv37Vrl726e/fuNm3akJMBJBU5GQBCJm/m5CNHjkycOLF+/fqlSpUqUaLE
hRdeuHnzZk1XMK5Vq1bx4sVPPvnkjh07tm/fvmTJkvqzW7duX375pXsJixcv
PuOMM/SqltC6dWvNT04GkFTkZAAImTyYkxVlhw0bVqhQoWuuueb7779/9dVX
ixYtetFFF23ZskWvbtq0qWbNmipzwYIF27Rpo3jco0cP/dmlS5eUlBRbwqef
flqhQoVy5crNmzdv/fr1zzzzTOHChcnJAJKKnAwAIZMHc/Lo0aOVgVWqWbNm
6c/U1NRq1arpz4kTJ9oMF1xwgf4cMGCAXtKfixYtypcv34knnrht2zb9uXnz
5vLly2vKXXfdZfPv379fmZmcDCCpyMkAEDJ5MCcPGTIkkq5hw4Z2cUWxYsX8
OfmFF16wPz05ec2aNfnz5z/hhBPWrVtnMyhO33PPPeRkAElFTgaAkMnLOblr
166PuqxcudJmSDQnHzx4sFOnTuRkAElFTgaAkMmDOXnq1KkKvc51F36J5mSu
uwCQA8jJABAyeTAnHzhwoFGjRirVww8/vHXrVk3ZsWPHK6+8MmfOHJshdk5O
SUlp166dptxwww27d+/WlJUrV5YqVYqcDCCpyMkAEDJ5MCeL4nHTpk2LFi1a
q1atVq1a1atX79JLL9XEI0eOTJ48uXjx4iqzXnrppZfSjn6E/PnzN2vWbP36
9WnpwXjgwIEFCxa85JJL9Hb9a+eTtcB33nkntz8cgHAiJwNAyOTNnJyW/ghl
ZdoXjrITy6mpqRMmTHAmLly4UBNnzpxpf44aNWrHjh329sOHD0+aNMmmL1my
ZM2aNfZ/5yJnAAgWORkAQibP5mQAOL6QkwEgZMjJABAIcjIAhAw5GQACQU4G
gJAhJwNAIMjJABAy5GQACAQ5GQBChpwMAIEgJwNAyJCTASAQ5GQACBlyMgAE
gpwMACFDTgaAQJCTASBkyMkAEAhyMgCEDDkZAAJBTgaAkCEnA0AgyMkAEDLk
ZAAIBDkZAEKGnAwAgSAnA0DIkJMBIBDkZAAIGXIyAASCnAwAIUNOBoBAkJMB
IGTIyQAQCHIyAIQMORkAAkFOBoCQIScDQCDIyQAQMuRkAAgEORkAQoacDACB
ICcDQMiQkwEgEORkAAgZcjIABIKcDAAhQ04GgECQkwEgZMjJABAIcjIAhAw5
GQACQU4GgJAhJwNAIMjJABAy5GQACAQ5GQBChpwMAIEgJwNAyJCTASAQ5GQA
CBlyMgAEgpwMACFDTgaAQJCTASBkyMkAEAhyMgCEDDkZAAJBTgaAkCEnA0Ag
yMkAEDLkZAAIBDkZAEKGnAwAgSAnA0DIkJMBIBDkZAAIGXIyAASCnAwAIUNO
BoBAkJMBIGTIyQAQCHIyAIQMORkAAkFOBoCQsZx84YUXXg8AyIZatWqRkwEg
TCwnAwACQU4GgNBYs2bNPABAQDZu3Jjb/ToAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACAvOunn36aFYeNGzfa/EeO
HOnVq9ctt9xy6NChXC14Ev3www9jx45N9lpGjhx58ODBZK8lOzZs2DBgwICm
6Z577jlnujb9qFGjOnTo8Ne//vW2227bunVrWvYaxo4dO9q1a/fYY48FWXrE
R43ws88+Gz58+FVXXZWamprbxYlL1BaIqNTPXHfddVSR3/HV8vfu3TtmzJg7
77zzvvvu++CDD3K7OP9f3ixVMvwZkk8yvP32261atVq8eHFuFyRbfvvtt9mz
Z59//vmRdHXq1LnxqM6dO7du3fq0007T9Kefftrm/+6772zOJUuW5G7Jk0EJ
uWfPngUKFND4m9QVrVu3Ll++fOPGjUvqWrLjq6++Kl269Pbt23UkValSJW3x
999/X9MPHz7cokWLESNGqN+46667NP2aa65Jy17DeP311/XGggULHjhwIPhP
gowtW7ZMabNo0aK27Y6LISCjFgg/VVHx4sVVRS+++GJulyVvOb5a/vz588uV
K1ehQoWyZctagW+++ebcLlQeLVWShDv5JE/Dhg1VabfffntuFyQAb775prWB
jz/+2POSOpAmTZo8/vjjzpSRI0fqT/XAOVvGpJszZ84TTzzRvHlz1UOyc7Ka
jdZSrVo1DfpJXVGWNWvW7NJLL7X/f/3113feeacOqfT/GTNmqOQrV67U/1NT
UwcOHOicRshyw9i3b9/gwYMnT54cXPEzsXv37hxbV97Xv3//4yItmBgt8E8u
aqueOXOmqogGH9Vx0fLXr19fv359BXv7U629SJEiKvN7771Hqfw0AO3ZsycZ
Swhr8onT3r17sxBXFi1adPfdd3///ffJKFIOUzy27uLzzz/3v/rOO+8MGzYs
50uVK6ZPn57snPzLL7+cdNJJVuHTpk1L3oqybNu2bSpbu3bt/C9dffXVeum4
HnYnTJigWJ7bpchDnn766byfFhwhaIHJQKvOguOi5Q8ZMuSnn35yTxkwYIDK
PHTo0NwqUlpeLZX069cvm6Nq9pcQPgcPHmzWrNmmTZtyuyC56ZNPPomRk9WH
7Nq1K+dLlStmzZqV7Jz8wAMPdOjQoXHjxlrRBRdckLwVZdnChQszysk1a9Y8
rlOKDvry589///3353ZB8pDjIi04jvcWmAy06qw5Llq+/1zcSy+9pDKPHj06
/oVs3bq1UaNGMU7r/etf/7r33ntzuFSBe/zxx1WGN954IxeXED6HDx9u3769
qsW5T+3PKUZOnj59un9+zZbRkcXatWtfe+21l19+WfPs37/f8+oPP/yw+Kj1
69fbRA15i1327t3reZc2k0q4bt06/f/bb78dNWrUp59+6p5Bvdxnn302duxY
Ne9sHvIkOyf//vvvpUqVWrp0qYY2q/O5c+fGfss333xj8xw5cuTrr7/Wx9RG
yc5XS//73/8+/PDDF198UWXYsWOH+yXbFk8++aQKpuNH2yJWpV999ZX+X7Jk
Sb303//+117yLDmjhqGjUW0yrXHKlCnbt2+POoMKo8pJqLSOOKtICylUqJBd
R2fl37lzZ4bVFI0K8Prrr9v/V6xYMWbMmHHjxqlmMvpCSgX74osv0tK/RFCp
1Lo8I7JqQyVXk9an094RY9UamCZNmqQ1Llq0KKN59NknTJjw6quvar0xFqVB
Uzvps88++9Zbb/3222/+tJA399N4WmBqaurKlSsnT56stag17tu3L+qiMi1q
PFQD8+bNe+GFF1SNUVek1mX9p1Y3e/Zs9Yrbtm1zz6BWoelauz5ORkU9cODA
Bx98oO3+n//8R23Jfw1/pq1aH1Adjuddqih9ZGtL2vtUV0o4c+bMiZEY1QA0
gz7vu+++++OPP2ZYL5mJp/JXrVqlHe35559/7733fv7556jL2bJli5NnNmzY
MDFd7DsWM235bprh448/VrVoI6qcGX3hrmU6xfjpp580sz6Ryu/MoK1sn8V/
WWPW3Hrrreedd546xvjfos9y4YUXVqhQwdmd3Z544glVgvtm7ZwplWPz5s12
/4syg3o5VZd/OdrE2mpq7fPnz/f322rDyvm2NZV1bUf4448/3PPE3pXiWUKM
5BNnTx7saB5I27Ob1PRG1byK5HlVVW1f4cnbb7+tOvF0JpnuziqY+reoq9au
rW2qt2i7ZHQvbaaDWkpKihqPelf1xtvTZfRJsymjnKyW4z7hqXL279+/cuXK
mlMjvmchqm0ddFx++eXqRdW3nHbaaUWKFNG+ecMNN7Rr107jY1r6ZlUfdcIJ
J2gJ1157rb1RG0L925VXXmllcFfpzJkzu3Xrduqpp2q6Nre24//93//ZbHaB
oqhymjdvfv/99z/66KP16tXTS/fcc0+W7whLdk5Wi23cuHFa+m5So0YNrcv+
9FPDu+2228qXL6951FDVk2jOEiVKWA1o+po1a7JQAB31X3HFFcOGDXvggQcq
VqyobaRW6rxqlyJrBq2iatWqd6azK4eHDBmi/xcoUEAvqWD2kuXD2A1DG1Tb
RWvU1mzbtm3BggXVLTuvqtPr0aOHPpfe6/kiL9PSJlRFq1evVoFPOeUUvVS/
fn0rf5w3ZWjXU+u65JJL8uXLp4Wrqav1RlwaNGjgPtbWftS3b98zzjjDWqPW
YuuVV155xebRQjSy1K1bVz2Aakb/16vag/yVoHDetWtX7UfaENp9VIZGjRp5
Tqjq07Vp00afaMSIEa1bt7YK8R9WaBjq06ePavKpp57SjqPq1Yf629/+5kkL
eXM/jdECjfrnmjVr9u7dW0OV2kmdOnVU7RpY3QknnqLGQ0OtWtHIkSM1NqmT
VHrXSu0ldf4KYNpG+fPnP/nkk9WN2w4lzjX/mjh48ODrrrtOI3K/fv2KFi1a
rlw5VZFnLWotmq5tumzZMiXGv6Rzn8qL0aq1ER977DFFF72k3cd5i3r7jh07
2ls0XVH57LPP1sG7lVCfJeqorWFIq9awrrHS2sBZZ52llqa+/eGHH46z0uKp
fO1HapNqvRr7dGR00003aYur23QWoh1Hvc0555yjd6lydLSiA4RixYrZwcJJ
J52kQd+/6jhbvtHA98gjj6gDtIOC++67r3Dhwtp27haiBKXGfO655+rtGuxU
DLVn/Ue1ZMtUC9HQr75LVV29enX1e5qojx9nXWVEAa9JkyZZSFYWlVUDCpzu
6XZWJJshOWulWrt2rVqgNVElBx1FVqtWzWrvrrvucmZTgZs1a6YmMW3aNB3m
tGzZUl3TwIED3edVtE179epl79UMtiO4+9JMd6UYS8g0+WTakwc7mgfV9tQx
Dho0qEqVKuPGjdNnVPeu3Ucdl/sgRTv+9ddfb4vVElQn6q/spdi7sxqD+l4t
TQOWPrJn1er5//GPf1x22WVavrZp6dKltbt5KiGeQU1dhD6gal41rPJoGzVs
2DD+mkyIk5OVbz9Jp6MP9YeqHzUtZzYdii5YsMBGT39r0SfSS84VGuqrbZnD
hw9XV+NuM2pR7vHXM797/FUlqIpsusYUjd2aonaoEcGOGlQMlfDXX3+1+VX5
1lSyfKleUnOyxnQVzxlP1Tjto9kpR//Maq4atjRDpUqV9PHtkE3txDqWVq1a
JVoA7Tj6aM6Bm/ZWG1zUwNyz2QMoPBvIaNzXS562GqNh6MNqiFmxYoX9qQhh
u5Jz3Kodyr6wi/hycqalzUIVWT+c6DfU6ojUu9qtu6Kmrr1D/YDGdKU++0RK
xU6/rf7f+b5A/b/GWfUAinnnn3++HTCqo9PerVDnPl+hXkXzn3766U57Fq1F
x1PqBp0p11xzjWbToO9M0erUz7hPrto8LVq0cH8KLUqJSC3QfYJOH00To6aF
vLmfRm2Baen34Wq6+xBMbUPZxlNXmRY1HgpRam9OGZTotDRlXYv9ql61FsUw
i20a8XXcNHXqVKUyjUr2FnX4f//7350FWmvRcOYeuBX7NVFtxpkyfvx4TdER
k6c8UVu1Uoc2lkafyLE5WXuNPqmCpaYrbfbs2dPag1qRnatXQ/UsX6094nrq
kdqJHeloEFTfHv9Dn+KpfAvAzjkrRdYTTzxRNePUtgZ3TbzxxhutehXaNWBp
og49FNotdXjOTSXa8rWDq37cJ//Vv6nzUWJfvny5uya1a+vt6uI6dOjg1IN9
RqUglU0t3w7lVL12iBe1t4+H2rMyrYpRtmxZpYssLMEflXXUoCK5D0NyslSb
Nm1SI1ePpzIo9ekId9WqVc8884y69AkTJtg8Kqr2LFWv8y5t61tuuUVv0Q7l
PkxWX2pb03/VRJy7UkZLiDHAxdmTBz6aB9L2dJiviapMZ4q6Sk3RQtyzOfnQ
c91F7N159+7dyt5Nmza1fOspf9u2bXVg5TwaVz2qZlOf6cwQ56CmZuPO/zrq
v+iii+Ksw0Q59aCG1PAo/V8BwJ2TjfUtntaijW4dlHuiHa1ra3qWoPDjH39V
pf7xNy29Idl0d1QwGpUqVKigAz33RI1E1n9m7ZGYSc3J2vuUeZyzWyq/PVHH
34ocdnBap04d9zmxUaNGaaIOFRNau3Z27ekar90TrRlrS7knJpqTjb9hqOtQ
k+jevbt7NsUGdSDur//27dvnz8nxlzahKspaTja2L4vnWz9bl3hud7Xn6SlL
+BelQ3K9pKNgz3SNYp7ee8CAARqy3SdqlLRLlSrlDoTqEnVg7l6O3Y4q7u/g
br75Zk2ZOHGiZ6UPPfRQ1LSQN/fTqC1QAUA9VfHixT0nqJVXrVTuZ2LEKGo8
1Nflz5/f/b2GBiNtZY137rWrMdhabEB0s0d2uAcdNV3LqH379nUmTpkyxdN+
VOeaUqVKFc8CY7Tqzp07R47NyUZjWcR3ium2226LRPuGq0GDBpFjH2Wgpqsp
Gsj8a4wtduVr3FQ95MuXz11pdkj14Ycfuue0g2uN/u58olHVFu65uiChlq/Z
PBvCWD+jDtz93Hs7OhP3uU21Rpv42muvuZdg1Rj/6Xc3tRZtSvUPltYiWT0D
bFFZXZMWaCH5hRdeyMJyAiyVfa2vQcF/oaao/Xv6sbT0cG79gDvRxcjJce5K
MZaQlkHyib8nTwt0NE8Lou3ZdSbO+eG09MvUNeX66693z5ZRTk6Loy+1S3o8
CUfVq4nuDPzLL7+oTXbp0sWZEs+gZtvL0/G6zz8EK6PrLpYsWaLCe2auXbu2
v7VYz6+jfncDsKfu6CDRs4SExl/tETbduS7U8e6772q6etELXTRknJguoW9R
HUnNySqe54j7scces0+XUWm10f3lcZ7jl5KSEv/abeDW8Ze7uipWrKi6OvXU
U91xJWs52d8wZs6cGUn/Dih2wTRI2cdx5+T4S5tQFWUnJ1sfooNHz3SNm/aF
midg2LqidiB2nYnzVCWH6spWYV2f9iZFkdit8eeff1auKFOmjLui1HXYXuCc
llm+fLlViPtktcnoKs28uZ9GbYE6noqkX3jgn98GLPeTXWMUNR6DBw/We2Nf
AZ52tLWotP6XNGpok114LLVq1cbll1/unlNrcQZBjQV2k1FCR386So1Ey8m2
cT1jimbTROUBz8zWXN1hwE6MFClSJFYVRJNp5WvEdA/HK1assC92PXfK2J6i
Ecc98YcffrCFL1y40JmYaMvX6Kwp/ofbO8tx3yAwb968qPuOnb5TL+SeaCfE
evbsGfWDx2nz5s0WHdW0/PcIxMOish2XZSckB1Uq+xbA0/LNhg0b9JJCuP9o
2rp9DRDOlNgpN55dKfYSoiafOHtyd5kDGc3Tgmh7qlX3zTVqGPY1TdOmTd2z
xcjJme7Ozz77bMSXk1u0aFG4cOEYT9iLc1CTs846y6pUH8SmJO9XGGLcx9em
TRvPlKitxRk93ZdwP/roo1E7nKDGXzu/5z+Uy47k5WR7+F6PHj3+7mJne8R9
JOUWe8/y3GUQm+0pngPzqILKyfbFkA57Y68uak6Ov7QJVVEycnJa+m4SSb9U
zL8uf052RnNn13ZoCLaX7AsyGybatm0bo1T2pb//aNTDdpaiRYv6X0p2Tg52
P43aArVBNTHqN252LlF9bDxFjUezZs30XsW52LPFyMkVKlTQMBH/GjUKDxo0
qF+/fnZY7V9msDlZS/PMbMca7pPP+viRY78njVOclb9z506NsH369BkzZoyq
yx9dYudkjWjOxERbvgVI5z4Ch2KMzez+0ZaMsopdEerJKnZTg6JIjA8ej337
9tmBuftjJsQ2tD5pgA+2zXKpYuRk68YV/PyZSglfL+XPn9/p4WOnXBN7V0o0
J8ffk5sAR/O04NqecvLcuXP79u07ZMgQ+2UHz7YIPCfr4KJixYoxPlqcg1pa
+q1AdquFcrXSlI7XMn1LlsXIyf5wHjUnyx133GFtwG7c1qHKxRdf3LBhQ/+v
Mwc1/g4cODDi+7I7m5KXk1u1atWxY8dRPmqTtr9HfehKgHtWkyZN9JZ33303
0zmDyslW+Ex/CyxqTo6/tHkhJ9tlXZ5v8TLKyQr/Vra3337b89L27dvtpS+/
/DLt6CmsunXrxijVtGnT/B2Rn9WSOhP/Hp3snBzsfhq1BapH1cSyZcv653/w
wQcjx16amM2cbKEx0ztAY+Rk+428jB7e4rZy5Up1oRrdLJbbl8U5n5M1QJx4
4omKK8552tGjRyvqZ+G3yTKt/P379+v4ulatWk4Ds+suspyTE2r5ygx2E8RD
Dz3kL1uZMmUixz76LFdyctrRA8Os/TaTnUpV+1RLVrINMCpnrVQxcrJd3iOe
B8XI7NmzI+mnmp3TsLFTbjy7UqI5Of6e3OTBnKxEWr16dXXOtnbrtZKdk5V2
tOFiPFonzkHNbNiwQeHKilGsWLHkPfs69vOTPTLKyWnp18arL61Ro0a3bt1u
uOGG4cOHR33SV1Djr13Yk9Fl2/7LAuORpJys40213qg3Cjlf50W9ribAPctG
zF69evlf0ujg7i2Dysm203Xt2tU/s/s7pqg5Of7S5oWcrNYe8T1xOqOcrM9r
Y7EW6HnJTiA7J0l2796tPxVR/A8wdyrQrslU/xB1X3P2AueGC/8FA8nOycHu
p1Fb4NixYyPpWch+NdLNrv5yXySfzZxsw/ozzzzjf8ndqmPkZNtT/Gcs09K3
uHOmes6cOWoJ7m/0cisnp6X/bq+ya+nSpVWe22+/vVOnTmvXrvXPlqnYla9X
NXxo73A/WSubOTnRlm+3r+oD+otnNz+6r6vMrZysrB459vKSOFlt2OUWe/bs
ifGwuBwrVYycrHEzam+TdvRSK+1KzpQYKTfOXSnRnBx/T27yWk62b/zdZzBy
JifbHm23tLvpg9hFIHEOavYW+8/8+fNtz81o82VfIDlZI1eHDh2cJxvEYPf3
ea7ocG7BiH/8dYrt/63M6dOnjxkzJtOS+CUpJzdv3rxjx44ZvWrnTgsXLux/
UmiAe5YNCkWLFvW39sGDB7tPDQWVk21HVl+xevVq95xLly51n5OJmpPjL21C
VWT3YmTtBq6McvKRI0fOPPNMhTTP7hPj+mR7spb74jpjNdayZUtnit0M6LkJ
TjXWu3dv+y5y7969dhPNI4884lnaqlWrnLWrG7EK8dxWmZZxTs6b+2nUFqjj
JqsE//WWNkC4m2U2c7J9Y1u2bFnPI17Hjx/vvuosRk5WBoukP2vC0zhTU1N1
UOkcE9kvqrifRfDhhx9GXWaMVh1UTh4+fPjIkSOz8MO1HrEr/9///nfk2JP/
UqVKFf/YF39OTrTl29ViOjj1XGdrtyypMO7z0rmVk++9997TTz890Xtg7aYq
9z6iqKwD2KCictZKFSMnHzx4sFy5cpFj7y8wthu6G7ZzYYz7+lUT564UYwlp
GSSf+HvytDyWk/ft26ehOXLsGW/7rsGzLex3x8T/8Lqs5WQrjGKP53Iajex2
liDOQU1rd9+EqHqwrtX9dJQA2Y02oi4l05mrV6/u3wrqOtQUb7311nieoNit
W7dI+r3SzmD322+/WX8e8d2voRqL0XRtKFdrnzJlivXh+/fvV2/QoEGDrHXp
dsI/o5y8bNmyq666yvPZM2W7ZIzLdBUV7DOqAj0v2fVCnvJMnjzZ5o96tJUR
bRrVeST9jirnUE7JvGfPnnfccYd7zldeeSWSwZNq7PA56q8M+BuG9gK7rV7r
nT17tp1tUz/TsGFD966tTWYfx30SKf7SJlRF9qAwpx/I9CpTN0s+4jlpaYcV
7gd+GrvF4M477/QvasOGDRqI/Xtc+/btdWjgvsjKTtHIgAED7PuITZs2qREu
WLDAmUerjqQHeOcbHDV+5Qrtku4jL7uwVrO5z2RqTns0ZcR3NXje3E8zaoH2
7IJatWq5Y4xqTKOG567z2EXNlHKs3byjcVNHDSq/1qjhwJN/7MSdtrJ/CStW
rLBnCTZu3Nj5ZuTbb7/VBnLfzWFHBE6fr11GbSmSfuDpuZgtRqvu0qVLJNqp
ZqWjiC8n2xUyareemfVZ1Ax0xBrj1ps4xa58jYCR9KegOO120aJFNpq/9NJL
7jntGwRPTlZl2sI9v6qQUMtXy7SH6T311FPuhWjnivgeu2EXUvqzio3ynsf1
2D0XUb9fi0HV7umm1DeWKVPGs/BM2XOS/QeSWYvKQZUq7eiXcRk99tae6qD9
yH0WRe1QrVRHmp5739R5RlwHjE4J49+VMlpCWgbJJ/6ePC3Q0Twt223vu+++
s7erYdgUxU67CrROnTru965du9bmdMKwUy2Z9qXW6jzHC87DRdu0aWMd4O7d
u/v06ePe4+IZ1FTgSpUqudvAF1984enu9C5lBtV81h6A5lAl33TTTVZsLS32
L3iqrRYuXDjie9qb9prIUcWKFStbtqy6Go0j6oi0Y3qaol2EoDm1W+k4UXV1
3nnnKQvZ2zUG9erVy4phNWPTO3fu7C/b6tWrnWdra1/Q/zWMqh36v36Nh1Zn
T0bSMWzUn8eye4K0peJf5q+//mrPA4+Rrj/44AOn9txX5Orz2sWQ6sTcJzds
d5OPPvoo/pKkpT+m1XqMSPpNZ5UrV1ZHoQ/lySr2dErPStNczdt/8JhRw/j6
668rVqxo79JGL1KkiBq250H3dhwhM2bMSLS0iVaRpSktRz3hvffe63QR8XBy
cqNGjdQrqlUrMinHaljXp/Zc/agPrg8bSb+DLOpvVGmjq2ZOOeWUefPm6RNp
Z1eHoL3GM8Rr77bfDDXFixdX4T2DnToZ5xcTtBW0F6iL1sIVvdyzKVvaQ33t
I6gzGTJkyMUXX+z8dIh2Pfezc/PgfhqjBWql2qDqV3V8Zyl6y5Yt+nQqj3st
mRY1HjNnztRGt4XoPwUKFFD9u3sMrdEGJnEf0TjU8Cz+WdNVh6nRzXlAsXG6
5SZNmmhp9erV09hng+DVV1993XXXOXNm1KrVqOxMWosWLdx7jRqMRX33I0z1
H2tFGvc9hyH2PEbbhRWYtSfWqFFDxzgKGwn9lG2mla/Gny9fPr2q1qvjDh31
DB061NKsdg19ZOeQ2R6xFTn2sXvOCQfPfp1oy1+zZk3dunVVny+//LLq0Ipd
vnx5/5PlnGdFuk+1rVy50ia6D0PsQbuR9CfLJXRLvmpbDUwZT4tVPtReqc2R
6UOEPLQD+vsNhyKuasPzlIMcKFVa+qaxb0PUE2qHjTqPDpHUoSkV27NxVFrl
PR0b+oN927ZtbVFqNnfccYdzqWr8u1JGS8hogEuLuycPfDTPZtvTVrNkoj6z
Xbt2l112WfPmze3uSNVMp06dnC8xNQbZb2ZVq1bt0Ucf1Vhgz/fIdHfWKuwg
SK3F89A/Lcf2dBsR9H9FL/cM8Qxqdja7e/fuzql4bbUqVaq4v210bqjMwkVK
DtWwcvttLvrT/5ATozZz991322zauCNGjHCfPVZr0VbQIKXhTy1f3anz4yz+
Sw50/K7a1mHsVVddpT5NH1ObT/3hs88+61z2pn578ODB7rKpib711lueRamu
VOdq/FqaVqRCZu2kh1q1RhlnXcoAKphn03/66ac67PU8mTAGdQI6SnKWGfXJ
mdqyqkxnHv3fztTpUPQf//iHuzyqYdsH3TMnetOEFjtgwADtEepnevTo4blG
aNOmTSqks3yNuePHj7eXxo4d27t3b2e9OvRzDpZjNwwdKWgMUi/arFmzYcOG
eQ5AnnvuOX00e692bfdjaTMtbRaqSK8OHDhQTeWKK65I9Com57oL9c8appUT
tCPrWNX/o8DPP/+8u92qXXnOhhk1XUUj9TAar7VANf6MfrxYA7Q6Lo1l6hP8
Py2alt5lKbFrnvr161977bWq1ahPGdKuoUXpOEg7qY7xtUPpcF71o08xa9Ys
//NL89R+GqMFOhSkBw0apPrUwYWq3fOj8HEWNR7qOfv27asGoHFWG9edQlUG
p0lbUdVy/GO6OnB9HLUijd1alP92qt9///2BBx5Qy9fYrQq3DarBUaOtFus+
0xW1VX/yySf6dE4xHnzwQVuFiqcR0JmuVX/zzTfqqdy7khKCe5RX7FfbU7vS
YKpjJXteh/XtJUuWjP176444K3/OnDlqbKoWdT7WxlRgVYImOj9t/PjjjzsL
UdO1R6mMGzdO/3emax73YhNt+coGSn2aXx2XdgE1Xc+tZBrHtfM6XbdqzK4g
0jJ1+OAuxtatWxUjtYGcieoP3b9XEpsSnQqshFC7dm3lwyeeeCKeO0D9vvvu
uxivKrll9PvgySuVtr577NPuMHLkyKhfSStCa+zQjqAORMOENmXU76G0U2hj
KQYr+rovgop/V4q6hNgDXFocPXmwo3lQbU/hX+9Vv9GlSxdbtWpVW1MHlZrN
fTSn+G3HFxqArCvLdHdWD6njd+dVlcHzKyfz589XXalj0dFW1G/bMx3UNB6p
zWjLKrXqX9WqKtlz7kURTsvXpvE/UCLnqRp1nO7pSfQxNUVHSUr4iV57A+Q1
Me7jA8JKY5MOUf0/tabxaPXq1TfeeGNQz+AFgLDauHFj0aJFhw4dmtEMOhLJ
yfIAyUBOxp+Qeu8KFSpk9OqLL77ovz0TAOBmtx7XrVvX/9yzXbt29e3bd+bM
mblSMCBAlpPz5cuX2wUBckhqamrBggXV5v1fjOql6dOn9+zZM5s3yABA6O3c
ufP888+3uzwuu+yym2++uXfv3h06dLjkkkuuvPJK92VCwPHrtvR7PMVzfxwQ
YnaTYCT996w7derUp08f9fAtW7asXbv2yJEj88JVfwCQ96WkpEyePLlz584N
GjRQPL7xxhsfeeQR9/PYgeOXWrIO/erWrXtBuqZNmw4dOpQDQPxJLFu2rF+/
fi1atNAu0KZNm/79+0+aNCmhhzYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAJA8/w96b9HH
    "], {{0, 782}, {952, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->{464.00003878275123`, Automatic},
  ImageSizeRaw->{952, 782},
  PlotRange->{{0, 952}, {0, 782}}]], "Input"]], "Text",
 CellChangeTimes->{3.5550349112526865`*^9}],

Cell[TextData[{
 "Below is a set of commands illustrating the Arvo algorithm for generating a \
random rotation. \n\n\tInput: \n\t3 random numbers, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["r", "1"], ",", 
     SubscriptBox["r", "2"], ",", 
     SubscriptBox["r", "3"]}], ")"}], TraditionalForm]]],
 ", each uniformly distributed on the interval from 0 to 1\n\t\n\tOutput:\n\t\
9 components of a uniformly distributed random rotation\n\t\nThe following \
slightly modifies the Arvo algorithm so that the rotation is the identity \
when all three random numbers are zero.\nFor nonzero random numbers, the \
behavior is as follows\n\tWhen ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]]],
 " varies, the cube rotates about the local 1-axis\n\tWhen ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]]],
 " varies, I\[CloseCurlyQuote]m not sure how to describe it except when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], "=", "0"}], TraditionalForm]]],
 ", in which case, the cube rotates about the 2-axis.\n\tWhen ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "3"], TraditionalForm]]],
 " varies, the result is fascinating because (when the other two are zero) it \
provides a view from every possible angle.\n\t\n\nThe normal to the face is \
set by crossing the above listed local directions with each other. Thus, the \
side opposite face #1 has a normal pointing in the opposite direction as \
desired.  When permMap is False, the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["4", "th"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["6", "th"], TraditionalForm]]],
 " face ID numbers are reversed so that opposite sides sum to 7 as on a die."
}], "Text",
 CellChangeTimes->{3.594564952979885*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"OriginalArvoRotation", "[", 
   RowBox[{"r1_", ",", "r2_", ",", "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[DoubleStruckCapitalR]", ",", "n", ",", "\[Theta]", ",", "\[Phi]", ",",
       "z", ",", "\[Rho]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Rho]", "=", 
      SqrtBox["r3"]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}]]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[DoubleStruckCapitalR]", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"Outer", "[", 
           RowBox[{"Times", ",", "n", ",", "n"}], "]"}]}], "-", 
         RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ")"}], ".", 
       RowBox[{"(", GridBox[{
          {
           RowBox[{"Cos", "[", "\[Theta]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "0"},
          {
           RowBox[{"-", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "0"},
          {"0", "0", "1"}
         }], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Chop", "[", "\[DoubleStruckCapitalR]", "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"jacOriginal", "=", 
  RowBox[{
  "jacRot", "[", "OriginalArvoRotation", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"visRotation", "[", 
    RowBox[{
    "OriginalArvoRotation", ",", "diskDotPlot", ",", "r1", ",", "r2", ",", 
     "r3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQB2IQXXtmgc7GmleOjUUchiB61+FauRO1rxzdGJ8ogegz
k9YYgmiBFa3GIHrbgcn/TwJpPn9F5lNAWqhQgvECkObSecoEoqet0lDVP/7K
UeTAdj0QXXQp2gZEJxzcAaZ/L7ZbHAykOdwCwPQqfveQUCCtEb8TTIt9EOmJ
BdLijklgevXevNUgep//HDDNFxX2uxlkfrziHxDtH3A1swVIL2dLywLRJj8z
vk4D0nM+VzNMB9KPosRYQfS/zl4uEF3WMZsfRJ97tVUARM/rOCAGos3ctsuB
aPP7PivmgdRJeG8B0Qfn2+0E0erH48E0U2rirYVAWseoCkwfaq0OXASk+wLu
hoJol7dlU5cAaRtjqWkgWmlr/KX1QDp78QQwDQDJ+cSH
  "]],

Cell["\<\

Demonstration that the mean rotation is zero:\
\>", "Text",
 CellChangeTimes->{{3.5945676966208124`*^9, 3.594567710404601*^9}, {
  3.5945691758184175`*^9, 3.5945691797456427`*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"OriginalArvoRotation", "[", 
    RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.59433206085954*^9, 3.594332076966461*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A modified version of the Arvo method that rearranges the random numbers to \
get a nice canonical orientation when all of the random numbers are equal to \
1/2\
\>", "Subsection",
 CellChangeTimes->{{3.5945649007608986`*^9, 3.5945649361759243`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
        RowBox[{"-", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]},
       {"0", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}], 
        RowBox[{"-", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ".", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1"}], "0", "0"},
      {"0", 
       RowBox[{"-", "1"}], "0"},
      {"0", "0", "1"}
     }], ")"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.5943258569286957`*^9, 3.594325860312889*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ModifiedArvoRotation", "[", 
   RowBox[{"r1_", ",", "r2_", ",", "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[DoubleStruckCapitalR]", ",", "n", ",", "\[Theta]", ",", "\[Phi]", ",",
       "\[Rho]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Phi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"2", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{"r3", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Rho]", "=", 
      SqrtBox["r2"]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["\[Rho]", "2"]}]]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[DoubleStruckCapitalR]", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"Outer", "[", 
           RowBox[{"Times", ",", "n", ",", "n"}], "]"}]}], "-", 
         RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ")"}], ".", 
       TagBox[
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {"0", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}], 
            RowBox[{"-", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}]},
           {"0", 
            RowBox[{"-", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], 
            RowBox[{"-", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
           {
            RowBox[{"-", "1"}], "0", "0"}
          },
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
        Function[BoxForm`e$, 
         MatrixForm[BoxForm`e$]]]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Chop", "[", "\[DoubleStruckCapitalR]", "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"jacModified", "=", 
  RowBox[{"jacRot", "[", "ModifiedArvoRotation", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5702028895676603`*^9, 3.5702029019063663`*^9}, {
   3.570202939353508*^9, 3.5702029402915616`*^9}, {3.5702030301727023`*^9, 
   3.5702030311007557`*^9}, {3.570203142303116*^9, 3.5702031548528337`*^9}, {
   3.5702032137332015`*^9, 3.570203231765233*^9}, {3.570203348771925*^9, 
   3.570203365219866*^9}, {3.5702034783873386`*^9, 3.5702035037617903`*^9}, {
   3.5702035752738805`*^9, 3.5702037089765277`*^9}, {3.570203750017875*^9, 
   3.5702037528100348`*^9}, {3.5702037857939215`*^9, 
   3.5702037957774925`*^9}, {3.5702039271850085`*^9, 
   3.5702039595988626`*^9}, {3.5702046646891913`*^9, 
   3.5702046678883743`*^9}, {3.570204714579045*^9, 3.5702047239785824`*^9}, {
   3.5702048064883018`*^9, 3.570204809112452*^9}, {3.57020493005637*^9, 
   3.5702049761360054`*^9}, {3.5702055441104918`*^9, 
   3.5702055738601933`*^9}, {3.5702065790526867`*^9, 3.570206579763727*^9}, {
   3.5702066216351223`*^9, 3.570206722418887*^9}, 3.5702067601790466`*^9, {
   3.5702068012383947`*^9, 3.5702068247357388`*^9}, {3.570206878527816*^9, 
   3.570206892833634*^9}, {3.5702069246404533`*^9, 3.570206985448931*^9}, 
   3.5940910638503*^9, 3.5940911506562643`*^9, {3.594099498498734*^9, 
   3.5940995356238575`*^9}, {3.5940995689837656`*^9, 
   3.5940995707188644`*^9}, {3.594099617866561*^9, 3.594099622865847*^9}, {
   3.5940996537556143`*^9, 3.5940997349392576`*^9}, {3.594100184607977*^9, 
   3.594100211631523*^9}, {3.594129370138294*^9, 3.5941294211992145`*^9}, {
   3.594129470532036*^9, 3.594129507415146*^9}, {3.5941297415995407`*^9, 
   3.594129743950675*^9}, {3.594131012387225*^9, 3.5941310545556374`*^9}, {
   3.594131151003154*^9, 3.5941311920214996`*^9}, {3.59413124361145*^9, 
   3.5941312841227674`*^9}, 3.594131329402357*^9, {3.594131457866705*^9, 
   3.5941314727775583`*^9}, {3.5941315150189743`*^9, 
   3.5941315735543222`*^9}, {3.594133508387988*^9, 3.5941335208597016`*^9}, {
   3.594163900078294*^9, 3.5941639010173473`*^9}, {3.594165355192521*^9, 
   3.594165367150205*^9}, {3.5941688189596376`*^9, 3.59416882040772*^9}, {
   3.5942643122205396`*^9, 3.594264375764174*^9}, 3.594264729345398*^9, {
   3.5943194404156923`*^9, 3.5943194483641467`*^9}, {3.594319522102364*^9, 
   3.59431953182292*^9}, {3.5943197219977975`*^9, 3.594319738773757*^9}, 
   3.594319835616296*^9, {3.5943200953391514`*^9, 3.5943201012674904`*^9}, {
   3.594324518925166*^9, 3.594324556596321*^9}, {3.5943246568040524`*^9, 
   3.594324661043295*^9}, 3.5943248650369625`*^9, 3.5943250436491785`*^9, {
   3.594325108959914*^9, 3.5943251218686523`*^9}, {3.59432584232586*^9, 
   3.5943258831611958`*^9}, {3.5943259258226357`*^9, 
   3.5943259658549256`*^9}, {3.5943259969937067`*^9, 
   3.5943259977717514`*^9}, {3.5943267387161307`*^9, 
   3.5943267485126915`*^9}, {3.594331318964106*^9, 3.5943313218032684`*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"visRotation", "[", 
    RowBox[{
    "ModifiedArvoRotation", ",", "diskDotPlot", ",", "r1", ",", "r2", ",", 
     "r3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.5945677488618007`*^9, {3.5945679122371454`*^9, 3.594567919636568*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"showMap", "[", 
       RowBox[{
        RowBox[{"OriginalArvoRotation", "[", 
         RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", 
        RowBox[{"1.75", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"showMap", "[", 
       RowBox[{
        RowBox[{"ModifiedArvoRotation", "[", 
         RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", 
        RowBox[{"1.75", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.594176343166998*^9, 3.594176386999504*^9}, {
  3.5943325145854917`*^9, 3.5943325196017785`*^9}, {3.5943326118650556`*^9, 
  3.594332635848428*^9}, {3.594567807543157*^9, 3.5945678123584323`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
My Random Rotation (gives uniform rotation)\
\>", "Subsection",
 CellChangeTimes->{{3.555607116769866*^9, 3.5556071208100967`*^9}, {
   3.594344574523281*^9, 3.594344575442333*^9}, 3.594345787723672*^9, {
   3.5945650169035416`*^9, 3.594565024727989*^9}}],

Cell["\<\
I don\[CloseCurlyQuote]t think the following is nearly as elegant as the Arvo \
method, but I\[CloseCurlyQuote]m including it because it is a direct \
application of the statement that the uniform rotation corresponds to a \
uniform placement of the sailboat\[CloseCurlyQuote]s mast on the surface of \
the sphere, together with a uniform rotation about the mast.\
\>", "Text",
 CellChangeTimes->{{3.594564767273264*^9, 3.594564861848673*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MyRotation", "[", 
   RowBox[{"r1_", ",", "r2_", ",", "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Beta]", ",", "cos\[Beta]", ",", "sin\[Beta]", ",", "\[Phi]", ",", 
      "cos\[Phi]", ",", "sin\[Phi]", ",", "\[Theta]", ",", "cos\[Theta]", ",",
       "sin\[Theta]", ",", "\[DoubleStruckCapitalR]", ",", "er", ",", 
      "e\[Theta]", ",", "e\[Phi]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Beta]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cos\[Theta]", "=", 
      RowBox[{"1", "-", 
       RowBox[{"2", "r2"}]}]}], ";", 
     RowBox[{"sin\[Theta]", "=", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["cos\[Theta]", "2"]}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cos\[Phi]", "=", 
      RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ";", 
     RowBox[{"sin\[Phi]", "=", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cos\[Beta]", "=", 
      RowBox[{"Cos", "[", "\[Beta]", "]"}]}], ";", 
     RowBox[{"sin\[Beta]", "=", 
      RowBox[{"Sin", "[", "\[Beta]", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"er", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sin\[Theta]", " ", "cos\[Phi]"}], ",", 
        RowBox[{"sin\[Theta]", " ", "sin\[Phi]"}], ",", "cos\[Theta]"}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"e\[Theta]", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"cos\[Theta]", " ", "cos\[Phi]"}], ",", 
        RowBox[{"cos\[Theta]", " ", "sin\[Phi]"}], ",", 
        RowBox[{"-", "sin\[Theta]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"e\[Phi]", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "sin\[Phi]"}], ",", "cos\[Phi]", ",", "0"}], "}"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[DoubleStruckCapitalR]", "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"cos\[Beta]", " ", "e\[Theta]"}], "+", 
          RowBox[{"sin\[Beta]", " ", "e\[Phi]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "sin\[Beta]"}], " ", "e\[Theta]"}], "+", 
          RowBox[{"cos\[Beta]", " ", "e\[Phi]"}]}], ",", "er"}], "}"}], 
       "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Chop", "[", "\[DoubleStruckCapitalR]", "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MyRotation", "[", 
   RowBox[{"0", ",", "0", ",", "0"}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"jacMy", "=", 
  RowBox[{"jacRot", "[", "MyRotation", "]"}]}]}], "Input",
 CellChangeTimes->{{3.555035493024962*^9, 3.5550355282639775`*^9}, {
   3.5556067719301424`*^9, 3.5556068071251554`*^9}, {3.5556069253929195`*^9, 
   3.5556069401767654`*^9}, {3.5556106206172743`*^9, 3.5556106490409*^9}, {
   3.5556229207638025`*^9, 3.555622935161626*^9}, {3.5940907932708235`*^9, 
   3.594090869742197*^9}, {3.594090978869439*^9, 3.5940909817736053`*^9}, {
   3.594165529957517*^9, 3.5941655305085487`*^9}, {3.594168994220662*^9, 
   3.5941689977928658`*^9}, {3.5941858246543074`*^9, 
   3.5941858270704455`*^9}, {3.594186075460653*^9, 3.594186076884734*^9}, {
   3.594264538698493*^9, 3.594264545042856*^9}, {3.5942654226660533`*^9, 
   3.594265427188312*^9}, {3.5943034032804203`*^9, 3.5943034918734875`*^9}, {
   3.594303528698594*^9, 3.5943035724230947`*^9}, {3.594303612860408*^9, 
   3.5943036216849127`*^9}, {3.594303670016677*^9, 3.5943037337273207`*^9}, {
   3.594319170402248*^9, 3.594319266346736*^9}, {3.594319305957001*^9, 
   3.5943193069930606`*^9}, {3.59432571504358*^9, 3.5943257158186245`*^9}, {
   3.594326667860078*^9, 3.5943267029160833`*^9}, {3.594331307716463*^9, 
   3.594331312818754*^9}, {3.5943446043819885`*^9, 3.594344780662071*^9}, {
   3.594344820068325*^9, 3.594345211701725*^9}, {3.594345249037861*^9, 
   3.59434545551167*^9}, {3.5943454997992034`*^9, 3.5943456784704227`*^9}, {
   3.5943457886247234`*^9, 3.5943457905688343`*^9}, {3.5943461731877193`*^9, 
   3.5943461737947536`*^9}, {3.5943463200421185`*^9, 
   3.5943463357440166`*^9}, {3.5943463863939133`*^9, 3.594346480817314*^9}, {
   3.5943465328722916`*^9, 3.5943465479601545`*^9}, {3.594346995509753*^9, 
   3.59434700909953*^9}, {3.594347190723919*^9, 3.594347206849841*^9}, 
   3.5943477439835634`*^9, {3.5943477880130816`*^9, 3.594347790133203*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"visRotation", "[", 
    RowBox[{
    "MyRotation", ",", "diskDotPlot", ",", "r1", ",", "r2", ",", "r3"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.594567865621479*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Uniform Axis and Angle (UAA) Rotation (does NOT give uniform rotation)\
\>", "Subsection",
 CellChangeTimes->{{3.555607116769866*^9, 3.5556071208100967`*^9}, {
   3.594344574523281*^9, 3.594344575442333*^9}, 3.594345787723672*^9, {
   3.5943513138347473`*^9, 3.594351323570304*^9}, {3.5945650067279596`*^9, 
   3.5945650139593735`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"UAARotation", "[", 
   RowBox[{"r1_", ",", "r2_", ",", "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[CapitalIota]", "=", 
       RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", "\[Alpha]", ",", 
      "cos\[Alpha]", ",", "sin\[Alpha]", ",", "\[Phi]", ",", "cos\[Phi]", ",",
       "sin\[Phi]", ",", "\[Theta]", ",", "cos\[Theta]", ",", "sin\[Theta]", 
      ",", "\[DoubleStruckCapitalR]", ",", "n", ",", "nn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Alpha]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cos\[Theta]", "=", 
      RowBox[{"1", "-", 
       RowBox[{"2", "r2"}]}]}], ";", 
     RowBox[{"sin\[Theta]", "=", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["cos\[Theta]", "2"]}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cos\[Phi]", "=", 
      RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ";", 
     RowBox[{"sin\[Phi]", "=", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cos\[Alpha]", "=", 
      RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], ";", 
     RowBox[{"sin\[Alpha]", "=", 
      RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sin\[Theta]", " ", "cos\[Phi]"}], ",", 
        RowBox[{"sin\[Theta]", " ", "sin\[Phi]"}], ",", "cos\[Theta]"}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"nn", "=", 
      RowBox[{"Outer", "[", 
       RowBox[{"Times", ",", "n", ",", "n"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[DoubleStruckCapitalR]", "=", 
      RowBox[{
       RowBox[{"cos\[Alpha]", " ", 
        RowBox[{"(", 
         RowBox[{"\[CapitalIota]", "-", "nn"}], ")"}]}], "+", "nn", "+", 
       RowBox[{"sin\[Alpha]", " ", 
        RowBox[{"(", GridBox[{
           {"0", 
            RowBox[{"-", 
             RowBox[{"n", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], 
            RowBox[{"n", "[", 
             RowBox[{"[", "2", "]"}], "]"}]},
           {
            RowBox[{"n", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "0", 
            RowBox[{"-", 
             RowBox[{"n", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]},
           {
            RowBox[{"-", 
             RowBox[{"n", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], 
            RowBox[{"n", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "0"}
          }], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Chop", "[", "\[DoubleStruckCapitalR]", "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UAARotation", "[", 
   RowBox[{"0", ",", "0", ",", "0"}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"jacUAA", "=", 
    RowBox[{"jacRot", "[", "UAARotation", "]"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.555035493024962*^9, 3.5550355282639775`*^9}, {
   3.5556067719301424`*^9, 3.5556068071251554`*^9}, {3.5556069253929195`*^9, 
   3.5556069401767654`*^9}, {3.5556106206172743`*^9, 3.5556106490409*^9}, {
   3.5556229207638025`*^9, 3.555622935161626*^9}, {3.5940907932708235`*^9, 
   3.594090869742197*^9}, {3.594090978869439*^9, 3.5940909817736053`*^9}, {
   3.594165529957517*^9, 3.5941655305085487`*^9}, {3.594168994220662*^9, 
   3.5941689977928658`*^9}, {3.5941858246543074`*^9, 
   3.5941858270704455`*^9}, {3.594186075460653*^9, 3.594186076884734*^9}, {
   3.594264538698493*^9, 3.594264545042856*^9}, {3.5942654226660533`*^9, 
   3.594265427188312*^9}, {3.5943034032804203`*^9, 3.5943034918734875`*^9}, {
   3.594303528698594*^9, 3.5943035724230947`*^9}, {3.594303612860408*^9, 
   3.5943036216849127`*^9}, {3.594303670016677*^9, 3.5943037337273207`*^9}, {
   3.594319170402248*^9, 3.594319266346736*^9}, {3.594319305957001*^9, 
   3.5943193069930606`*^9}, {3.59432571504358*^9, 3.5943257158186245`*^9}, {
   3.594326667860078*^9, 3.5943267029160833`*^9}, {3.594331307716463*^9, 
   3.594331312818754*^9}, {3.5943446043819885`*^9, 3.594344780662071*^9}, {
   3.594344820068325*^9, 3.594345211701725*^9}, {3.594345249037861*^9, 
   3.59434545551167*^9}, {3.5943454997992034`*^9, 3.5943456784704227`*^9}, {
   3.5943457886247234`*^9, 3.5943457905688343`*^9}, {3.5943461731877193`*^9, 
   3.5943461737947536`*^9}, {3.5943463200421185`*^9, 
   3.5943463357440166`*^9}, {3.5943463863939133`*^9, 3.594346480817314*^9}, {
   3.5943465328722916`*^9, 3.5943465479601545`*^9}, {3.594346995509753*^9, 
   3.59434700909953*^9}, {3.594347190723919*^9, 3.594347206849841*^9}, 
   3.5943477439835634`*^9, {3.5943477880130816`*^9, 3.594347790133203*^9}, {
   3.594351327182511*^9, 3.594351354830092*^9}, {3.5943513979495583`*^9, 
   3.5943516046493807`*^9}, {3.5943516577334175`*^9, 3.5943517100124073`*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"visRotation", "[", 
    RowBox[{
    "UAARotation", ",", "diskDotPlot", ",", "r1", ",", "r2", ",", "r3"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.5945679633650694`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Shoemake algorithm (does give uniform rotation)\
\>", "Subsection",
 CellChangeTimes->{{3.5556194911626406`*^9, 3.5556195046664133`*^9}, {
  3.5945649918481083`*^9, 3.594565002399712*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ShoemakeRotation", "[", 
   RowBox[{"r1_", ",", "r2_", ",", "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Psi]1", ",", "\[Psi]2", ",", "s1", ",", "s2", ",", "c1", ",", "c2", 
      ",", "s3", ",", "c3", ",", "u1", ",", "u2", ",", "u3", ",", "u", ",", 
      "u0", ",", "R"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Psi]1", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", 
     RowBox[{"s1", "=", 
      RowBox[{"Sin", "[", "\[Psi]1", "]"}]}], ";", 
     RowBox[{"c1", "=", 
      RowBox[{"Cos", "[", "\[Psi]1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Psi]2", "=", 
      RowBox[{"2", "\[Pi]", " ", "r2"}]}], ";", 
     RowBox[{"s2", "=", 
      RowBox[{"Sin", "[", "\[Psi]2", "]"}]}], ";", 
     RowBox[{"c2", "=", 
      RowBox[{"Cos", "[", "\[Psi]2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s3", "=", 
      SqrtBox["r3"]}], ";", 
     RowBox[{"c3", "=", 
      SqrtBox[
       RowBox[{"1", "-", "r3"}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u1", "=", 
      RowBox[{"s1", " ", "c3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u2", "=", 
      RowBox[{"c1", " ", "c3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u3", "=", 
      RowBox[{"s2", " ", "s3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"u0", "=", 
      RowBox[{"c2", " ", "s3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"R", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SuperscriptBox["u0", "2"]}], "-", "1"}], ")"}], 
        RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "+", 
       RowBox[{"2", 
        RowBox[{"Outer", "[", 
         RowBox[{"Times", ",", "u", ",", "u"}], "]"}]}], "+", 
       RowBox[{"2", " ", "u0", 
        RowBox[{"(", GridBox[{
           {"0", 
            RowBox[{"-", "u3"}], "u2"},
           {"u3", "0", 
            RowBox[{"-", "u1"}]},
           {
            RowBox[{"-", "u2"}], "u1", "0"}
          }], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Chop", "[", "R", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jacShoemake", "=", 
   RowBox[{"jacRot", "[", "ShoemakeRotation", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ShoemakeRandomRotation", "[", "]"}], ":=", 
  RowBox[{"ShoemakeRotation", "@@", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ShoemakeRandomRotation", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.5556107102554016`*^9, 3.5556107152546873`*^9}, {
  3.5556107565110474`*^9, 3.5556109416876388`*^9}, {3.5556109777917037`*^9, 
  3.5556109781987267`*^9}, {3.5556110342279315`*^9, 3.5556112077808585`*^9}, {
  3.555622693756819*^9, 3.5556227001571846`*^9}, {3.555622738242363*^9, 
  3.555622739049409*^9}, {3.555622801032954*^9, 3.555622813969694*^9}, {
  3.5943313726681776`*^9, 3.59433140592908*^9}, {3.59456815569607*^9, 
  3.594568156962143*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"visRotation", "[", 
    RowBox[{
    "ShoemakeRotation", ",", "diskDotPlot", ",", "r1", ",", "r2", ",", "r3"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", "1"}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.5945680169721355`*^9, {3.5945680872121534`*^9, 3.5945681066752663`*^9}}],

Cell["\<\
The Shoemake algorithm maps to the entire surface of the 4D sphere, whereas \
the Arvo algorithm maps only to the 4D hemisphere, so this leads to a \
difference in the Jacobians. Both methods give uniform rotations.\
\>", "Text",
 CellChangeTimes->{{3.555626749151774*^9, 3.5556268056790075`*^9}, {
  3.594568218040636*^9, 3.5945682674084597`*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ShoemakeRotation", "[", 
    RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5943315098340235`*^9, 3.59433158565536*^9}, {
  3.5943317032380853`*^9, 3.594331704214141*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Uniform Euler Angles (does NOT give uniform rotation)\
\>", "Subsection",
 CellChangeTimes->{{3.5556194911626406`*^9, 3.5556195046664133`*^9}, {
  3.555623208960286*^9, 3.5556232107683897`*^9}, {3.5945651046865625`*^9, 
  3.5945651368304005`*^9}}],

Cell[BoxData[
 RowBox[{"jacEulerAngle", "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Phi]", ",", "\[Theta]", ",", "\[Psi]", ",", "R", ",", "jacobian"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Psi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"\[Pi]", " ", "r2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"R", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"(", GridBox[{
           {
            RowBox[{"Cos", "[", "\[Phi]", "]"}], 
            RowBox[{"-", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "0"},
           {
            RowBox[{"Sin", "[", "\[Phi]", "]"}], 
            RowBox[{"Cos", "[", "\[Phi]", "]"}], "0"},
           {"0", "0", "1"}
          }], ")"}], ".", 
        RowBox[{"(", GridBox[{
           {"1", "0", "0"},
           {"0", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}], 
            RowBox[{"-", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
           {"0", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}], 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}
          }], ")"}], ".", 
        RowBox[{"(", GridBox[{
           {
            RowBox[{"Cos", "[", "\[Psi]", "]"}], 
            RowBox[{"-", 
             RowBox[{"Sin", "[", "\[Psi]", "]"}]}], "0"},
           {
            RowBox[{"Sin", "[", "\[Psi]", "]"}], 
            RowBox[{"Cos", "[", "\[Psi]", "]"}], "0"},
           {"0", "0", "1"}
          }], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"{", 
       RowBox[{"r1", ",", "r2", ",", "r3"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"dRdr", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"R", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"r", "[", 
           RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"jacobian", "=", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Det", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", "dRdr", "]"}], ".", "dRdr"}], "]"}], 
        "]"}], "]"}]}], ";", "\[IndentingNewLine]", "jacobian"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.555626104070877*^9, 3.55562632143431*^9}, {
   3.555626386114009*^9, 3.5556263913933115`*^9}, {3.555626438329996*^9, 
   3.555626445832425*^9}, {3.5943322260469885`*^9, 3.594332227677081*^9}, 
   3.594569251792763*^9}],

Cell["\<\

Note that the Euler angle Jacobian is not constant, which implies it will not \
produce a uniform rotation.  The fact that this Jacobian depends on r2 \
furthermore tells us that the correct solution will need to change the \
distribution for r2 to a something non-uniform. The problem lies with the \
distribution being used for \[Theta]; it over-samples at the poles.


\
\>", "Text",
 CellChangeTimes->{{3.5556268543827925`*^9, 3.5556268811263227`*^9}, {
  3.594176513747754*^9, 3.5941765165639153`*^9}, {3.5945682775610404`*^9, 
  3.5945683659600964`*^9}, {3.594568507855212*^9, 3.5945685257592363`*^9}, {
  3.5945686183665333`*^9, 3.594568676925883*^9}, {3.594569259369197*^9, 
  3.594569317009494*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EulerAngleRotation", "[", 
   RowBox[{"r1_", ",", "r2_", ",", "r3_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", "\[Theta]", ",", "\[Psi]"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Psi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"\[Pi]", " ", "r2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"2", "\[Pi]", " ", "r3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Chop", "[", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"(", GridBox[{
            {
             RowBox[{"Cos", "[", "\[Phi]", "]"}], 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "0"},
            {
             RowBox[{"Sin", "[", "\[Phi]", "]"}], 
             RowBox[{"Cos", "[", "\[Phi]", "]"}], "0"},
            {"0", "0", "1"}
           }], ")"}], ".", 
         RowBox[{"(", GridBox[{
            {"1", "0", "0"},
            {"0", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}], 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
            {"0", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}
           }], ")"}], ".", 
         RowBox[{"(", GridBox[{
            {
             RowBox[{"Cos", "[", "\[Psi]", "]"}], 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "\[Psi]", "]"}]}], "0"},
            {
             RowBox[{"Sin", "[", "\[Psi]", "]"}], 
             RowBox[{"Cos", "[", "\[Psi]", "]"}], "0"},
            {"0", "0", "1"}
           }], ")"}]}], "]"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EulerAngleRandomRotation", "[", "]"}], ":=", 
  RowBox[{"EulerAngleRotation", "@@", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"EulerAngleRandomRotation", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.5556107102554016`*^9, 3.5556107152546873`*^9}, {
   3.5556107565110474`*^9, 3.5556109416876388`*^9}, {3.5556109777917037`*^9, 
   3.5556109781987267`*^9}, {3.5556110342279315`*^9, 
   3.5556112077808585`*^9}, {3.5556195568103957`*^9, 3.555619587817169*^9}, {
   3.5556197305763345`*^9, 3.555619851010223*^9}, {3.5556198813379574`*^9, 
   3.5556200429602013`*^9}, {3.5556200765271215`*^9, 3.555620162903062*^9}, {
   3.555622180520463*^9, 3.555622229374257*^9}, {3.555622497253579*^9, 
   3.5556225130454826`*^9}, {3.555622546816414*^9, 3.555622576584117*^9}, {
   3.5556230230016503`*^9, 3.5556230436898336`*^9}, {3.555623117674065*^9, 
   3.555623123163379*^9}, 3.594169117323703*^9, {3.5941806741647167`*^9, 
   3.5941807027403507`*^9}, {3.5941880654704747`*^9, 3.594188093440075*^9}, {
   3.5945688602833705`*^9, 3.594568882723654*^9}, {3.5945689709376993`*^9, 
   3.59456897130072*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"visRotation", "[", 
    RowBox[{
    "EulerAngleRotation", ",", "diskDotPlot", ",", "r1", ",", "r2", ",", 
     "r3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r3", ",", "0"}], "}"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.594568796414717*^9, 3.5945688229742365`*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"EulerAngleRotation", "[", 
    RowBox[{"r1", ",", "r2", ",", "r3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r3", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5943321056110992`*^9, 3.5943321090852985`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Animated output", "Section",
 CellChangeTimes->{{3.594569760014832*^9, 3.59456976207795*^9}}],

Cell["\<\


Uncomment the following to make an animated gif\
\>", "Text",
 CellChangeTimes->{{3.594334091532688*^9, 3.5943341008922234`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"dr", "=", "0.01"}], ";", 
   RowBox[{"iframe", "=", "1"}], ";", 
   RowBox[{"rot", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ModifiedArvoRotation", "[", 
       RowBox[{"r1", ",", 
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r1", ",", "0", ",", 
        RowBox[{"1", "-", "dr"}], ",", "dr"}], "}"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"frames", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"visRotation", "[", 
       RowBox[{"ModifiedArvoRotation", ",", "diskDotPlot", ",", "r1", ",", 
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r1", ",", "0", ",", 
        RowBox[{"1", "-", "dr"}], ",", "dr"}], "}"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListAnimate", "[", "frames", "]"}], "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<RandomRotation.gif\>\"", ",", "frames", ",", 
      RowBox[{"\"\<DisplayDurations\>\"", "\[Rule]", ".1"}]}], "]"}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.594333601832679*^9, 3.594333691047782*^9}, {
  3.594333728215907*^9, 3.594333729599986*^9}, {3.5943337774717245`*^9, 
  3.5943337969828405`*^9}, {3.5943340762538137`*^9, 3.594334086813418*^9}, {
  3.5943349512088585`*^9, 3.5943349593593245`*^9}, {3.5943616270676303`*^9, 
  3.5943616603625345`*^9}, {3.5943617116034656`*^9, 3.5943619456728535`*^9}, {
  3.5943619882492886`*^9, 3.59436199928292*^9}, {3.594565387457736*^9, 
  3.5945653905449123`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"frames", "[", 
         RowBox[{"[", "46", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"rot", "[", 
          RowBox[{"[", "46", "]"}], "]"}], "//", "MatrixForm"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"frames", "[", 
         RowBox[{"[", "51", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{"rot", "[", 
           RowBox[{"[", "51", "]"}], "]"}], "]"}], "//", "MatrixForm"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"frames", "[", 
         RowBox[{"[", "26", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{"rot", "[", 
           RowBox[{"[", "26", "]"}], "]"}], "]"}], "//", "MatrixForm"}]}], 
       "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<visRotGeneral.png\>\"", ",", 
     RowBox[{"frames", "[", 
      RowBox[{"[", "46", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<visRot123.png\>\"", ",", 
     RowBox[{"frames", "[", 
      RowBox[{"[", "51", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<visRot365.png\>\"", ",", 
     RowBox[{"frames", "[", 
      RowBox[{"[", "26", "]"}], "]"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.594334967831809*^9, 3.594334970886984*^9}, {
  3.594362088113001*^9, 3.5943621256961503`*^9}, {3.5943621847125263`*^9, 
  3.5943622726075535`*^9}, {3.5943626429097333`*^9, 3.5943626624128485`*^9}, {
  3.594565418896534*^9, 3.5945654338463893`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Comparison plots", "Section",
 CellChangeTimes->{{3.594187202137095*^9, 3.594187209688527*^9}, 
   3.59456606326439*^9}],

Cell[BoxData[
 RowBox[{"skipLengthyComputations", "=", "True"}]], "Input",
 CellChangeTimes->{{3.594569479085764*^9, 3.594569494332636*^9}, {
  3.5945695828406982`*^9, 3.5945695833567276`*^9}, {3.5945698112707634`*^9, 
  3.5945698117387905`*^9}}],

Cell["\<\
The following illustrates the various rotation functions in two ways: 
\t1. the input numbers {r1,r2,r3} are sampled at regular intervals (this \
illustrates the algorithms mapping scheme)
\t2. the input numbers {r1,r2,r3} are sampled randomly (this helps to reveal \
bias clustering}

In the images on the sphere, some of the sample points are randomly tossed \
out to avoide \
\>", "Text",
 CellChangeTimes->{{3.594565463781101*^9, 3.5945655888432546`*^9}, {
  3.5945656539469786`*^9, 3.5945656731710777`*^9}, {3.5945660676966434`*^9, 
  3.5945660966322985`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"overlaid", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.594168624221499*^9, 3.594168634320077*^9}, 
   3.594168699891827*^9, {3.594169150736614*^9, 3.594169151413653*^9}, {
   3.594355967131901*^9, 3.594355975458377*^9}, 3.5945654474051647`*^9}],

Cell["\<\
The regular interval sampling in the following image shows that two of the \
Arvo r-value inputs control the spherical coordinates of of the \
\[OpenCurlyDoubleQuote]mast\[CloseCurlyDoubleQuote] in the sailboat in the \
nautical representation (but done in a way to ensure a uniformly distributed \
mast (this is why the spacing is wider near the north pole -- to compensate \
for the convergence of grid lines there).  The third r-value input to the \
Arvo mapping controls the heading of the boat (i.e., rotation about the mast)\
\>", "Text",
 CellChangeTimes->{{3.59456561795492*^9, 3.594565621203106*^9}, {
  3.5945656805304985`*^9, 3.594565937921221*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "OriginalArvoRotation", ",", "sphereDotPlot", ",", "15", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.555611375393445*^9, 3.5556113958126135`*^9}, 
   3.555611895169175*^9, {3.5556119946648655`*^9, 3.5556120376003213`*^9}, {
   3.5556182981874065`*^9, 3.555618298827443*^9}, {3.555618753856469*^9, 
   3.555618778744893*^9}, {3.555619038734763*^9, 3.55561905039043*^9}, {
   3.5556192237173433`*^9, 3.5556192241573687`*^9}, {3.5556193168206687`*^9, 
   3.5556193299814215`*^9}, {3.5556230755066533`*^9, 
   3.5556230760666857`*^9}, {3.555623135043059*^9, 3.5556231534431114`*^9}, {
   3.5556236424960833`*^9, 3.555623643718153*^9}, {3.5556238550772424`*^9, 
   3.555623875037384*^9}, {3.5941656762308836`*^9, 3.5941656778729773`*^9}, {
   3.5941679352410917`*^9, 3.5941679360211363`*^9}, 3.5941686395813775`*^9, 
   3.5941691666485243`*^9, 3.5941711657788677`*^9, {3.594252581876602*^9, 
   3.5942525832756824`*^9}, 3.5943481392181697`*^9, {3.594348187009903*^9, 
   3.594348188334979*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{"MyRotation", ",", "sphereDotPlot", ",", "15", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5943482032738333`*^9, 3.5943482035618496`*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "ShoemakeRotation", ",", "sphereDotPlot", ",", "15", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.594165745859866*^9, 3.594165746704914*^9}, {
   3.594168134010461*^9, 3.5941681348195066`*^9}, 3.5941686447006702`*^9, 
   3.5943481414582977`*^9}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "ModifiedArvoRotation", ",", "sphereDotPlot", ",", "15", ",", "overlaid"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "EulerAngleRotation", ",", "sphereDotPlot", ",", "15", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5941681618240514`*^9, 3.5941681626350975`*^9}, 
   3.594168648100865*^9, 3.5943481460505605`*^9}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "OriginalArvoRotation", ",", "diskDotPlot", ",", "10", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5941659576429796`*^9, 3.594165958551031*^9}, {
   3.5941682010472946`*^9, 3.5941682018183393`*^9}, 3.5941686511890416`*^9, {
   3.594252594900347*^9, 3.5942525969324636`*^9}, {3.594566012161467*^9, 
   3.5945660135855484`*^9}, {3.5945660461614113`*^9, 3.5945660467934475`*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{"MyRotation", ",", "diskDotPlot", ",", "10", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5942530199206567`*^9, 3.5942530212487326`*^9}, 
   3.5943482565138783`*^9}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "ShoemakeRotation", ",", "diskDotPlot", ",", "10", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.594165971394766*^9, 3.5941659723598213`*^9}, {
  3.594168657364395*^9, 3.59416865850846*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "ModifiedArvoRotation", ",", "diskDotPlot", ",", "10", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5942530199206567`*^9, 3.5942530212487326`*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{
  "EulerAngleRotation", ",", "diskDotPlot", ",", "10", ",", "overlaid"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.594168321023157*^9, 3.594168345294545*^9}, {
  3.5941686628677096`*^9, 3.594168665395854*^9}, {3.5943518397838297`*^9, 
  3.594351859055932*^9}}],

Cell[BoxData[
 RowBox[{"visualizeRotation", "[", 
  RowBox[{"UAARotation", ",", "diskDotPlot", ",", "10", ",", "overlaid"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<UAA.png\>\"", ",", "%", ",", 
    RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.594566903371441*^9, 3.5945669079557037`*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{1824, 996},
WindowMargins->{{-2, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.3000000715255737`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 260, 5, 131, "Title"],
Cell[CellGroupData[{
Cell[864, 31, 104, 1, 112, "Section"],
Cell[CellGroupData[{
Cell[993, 36, 210, 4, 61, "Subsection"],
Cell[1206, 42, 3112, 100, 439, "Text"],
Cell[4321, 144, 272, 6, 65, "Input"],
Cell[4596, 152, 17744, 454, 894, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22377, 611, 184, 4, 61, "Subsection"],
Cell[22564, 617, 337, 7, 64, "Text"],
Cell[22904, 626, 8996, 241, 401, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31937, 872, 283, 5, 61, "Subsection"],
Cell[32223, 879, 2861, 68, 490, "Input"],
Cell[35087, 949, 330, 8, 89, "Text"],
Cell[35420, 959, 8036, 193, 1233, "Input"],
Cell[43459, 1154, 307, 8, 164, "Text"],
Cell[43769, 1164, 3231, 86, 328, "Input"],
Cell[47003, 1252, 9248, 225, 815, "Input"],
Cell[56254, 1479, 452, 8, 64, "Text"],
Cell[56709, 1489, 2205, 56, 90, "Input"],
Cell[58917, 1547, 6736, 134, 260, "Input"],
Cell[65656, 1683, 478, 10, 139, "Text"],
Cell[66137, 1695, 1596, 43, 115, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67770, 1743, 178, 2, 61, "Subsection"],
Cell[67951, 1747, 526, 9, 64, "Text"],
Cell[68480, 1758, 6650, 156, 571, "Input"],
Cell[75133, 1916, 143, 1, 39, "Text"],
Cell[75279, 1919, 7359, 177, 456, "Input"],
Cell[82641, 2098, 810, 15, 91, "Text"],
Cell[83454, 2115, 477, 7, 39, "Input"],
Cell[83934, 2124, 1914, 50, 215, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85885, 2179, 186, 2, 61, "Subsection"],
Cell[86074, 2183, 546, 10, 89, "Text"],
Cell[86623, 2195, 164, 3, 39, "Text"],
Cell[86790, 2200, 393, 10, 65, "Input"],
Cell[87186, 2212, 7193, 155, 415, "Input"],
Cell[94382, 2369, 7094, 154, 415, "Input"],
Cell[101479, 2525, 251, 7, 114, "Text"],
Cell[101733, 2534, 3948, 87, 215, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105730, 2627, 224, 5, 71, "Section"],
Cell[105957, 2634, 199, 4, 39, "Text"],
Cell[CellGroupData[{
Cell[106181, 2642, 252, 5, 61, "Subsection"],
Cell[106436, 2649, 112120, 1842, 513, "Text"],
Cell[218559, 4493, 1840, 45, 440, "Text"],
Cell[220402, 4540, 2966, 79, 363, "Input"],
Cell[223371, 4621, 191, 5, 64, "Text"],
Cell[223565, 4628, 436, 11, 39, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224038, 4644, 260, 5, 61, "Subsection"],
Cell[224301, 4651, 1174, 35, 77, "Input"],
Cell[225478, 4688, 5481, 109, 338, "Input"],
Cell[230962, 4799, 764, 24, 39, "Input"],
Cell[231729, 4825, 1993, 57, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[233759, 4887, 265, 5, 61, "Subsection"],
Cell[234027, 4894, 453, 7, 64, "Text"],
Cell[234483, 4903, 4586, 93, 380, "Input"],
Cell[239072, 4998, 616, 20, 39, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[239725, 5023, 346, 6, 61, "Subsection"],
Cell[240074, 5031, 5027, 106, 401, "Input"],
Cell[245104, 5139, 619, 20, 39, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[245760, 5164, 198, 4, 61, "Subsection"],
Cell[245961, 5170, 3272, 83, 467, "Input"],
Cell[249236, 5255, 677, 21, 39, "Input"],
Cell[249916, 5278, 358, 6, 64, "Text"],
Cell[250277, 5286, 485, 12, 39, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250799, 5303, 257, 5, 61, "Subsection"],
Cell[251059, 5310, 2873, 77, 334, "Input"],
Cell[253935, 5389, 719, 15, 164, "Text"],
Cell[254657, 5406, 3088, 72, 285, "Input"],
Cell[257748, 5480, 651, 20, 39, "Input"],
Cell[258402, 5502, 439, 11, 39, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[258890, 5519, 99, 1, 112, "Section"],
Cell[258992, 5522, 141, 5, 89, "Text"],
Cell[259136, 5529, 1661, 39, 115, "Input"],
Cell[260800, 5570, 1841, 47, 215, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[262678, 5622, 126, 2, 71, "Section"],
Cell[262807, 5626, 246, 4, 39, "Input"],
Cell[263056, 5632, 575, 12, 139, "Text"],
Cell[263634, 5646, 290, 5, 39, "Input"],
Cell[263927, 5653, 670, 10, 89, "Text"],
Cell[264600, 5665, 1069, 17, 39, "Input"],
Cell[265672, 5684, 215, 4, 39, "Input"],
Cell[265890, 5690, 324, 7, 39, "Input"],
Cell[266217, 5699, 158, 4, 39, "Input"],
Cell[266378, 5705, 276, 6, 39, "Input"],
Cell[266657, 5713, 456, 8, 39, "Input"],
Cell[267116, 5723, 241, 5, 39, "Input"],
Cell[267360, 5730, 268, 6, 39, "Input"],
Cell[267631, 5738, 226, 5, 39, "Input"],
Cell[267860, 5745, 322, 7, 39, "Input"],
Cell[268185, 5754, 144, 3, 39, "Input"],
Cell[268332, 5759, 247, 5, 39, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
